/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.jmf.JDFJobPhase;
import org.cip4.jdflib.node.JDFActivity;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFModuleStatus;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.JDFDuration;

public abstract class JDFAutoDeviceInfo
extends JDFElement {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[12];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoDeviceInfo(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoDeviceInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoDeviceInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return " JDFAutoDeviceInfo[  --> " + super.toString() + " ]";
    }

    public void setCounterUnit(String value) {
        this.setAttribute("CounterUnit", value, null);
    }

    public String getCounterUnit() {
        return this.getAttribute("CounterUnit", null, "");
    }

    public void setDeviceCondition(EnumDeviceCondition enumVar) {
        this.setAttribute("DeviceCondition", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumDeviceCondition getDeviceCondition() {
        return EnumDeviceCondition.getEnum(this.getAttribute("DeviceCondition", null, null));
    }

    public void setDeviceID(String value) {
        this.setAttribute("DeviceID", value, null);
    }

    public String getDeviceID() {
        return this.getAttribute("DeviceID", null, "");
    }

    public void setDeviceOperationMode(EnumDeviceOperationMode enumVar) {
        this.setAttribute("DeviceOperationMode", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumDeviceOperationMode getDeviceOperationMode() {
        return EnumDeviceOperationMode.getEnum(this.getAttribute("DeviceOperationMode", null, null));
    }

    public void setDeviceStatus(EnumDeviceStatus enumVar) {
        this.setAttribute("DeviceStatus", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumDeviceStatus getDeviceStatus() {
        return EnumDeviceStatus.getEnum(this.getAttribute("DeviceStatus", null, null));
    }

    public void setHourCounter(JDFDuration value) {
        this.setAttribute("HourCounter", value, null);
    }

    public JDFDuration getHourCounter() {
        String strAttrName = this.getAttribute("HourCounter", null, null);
        JDFDuration nPlaceHolder = JDFDuration.createDuration(strAttrName);
        return nPlaceHolder;
    }

    public void setIdleStartTime(JDFDate value) {
        JDFDate date = value;
        if (date == null) {
            date = new JDFDate();
        }
        this.setAttribute("IdleStartTime", date.getDateTimeISO(), null);
    }

    public JDFDate getIdleStartTime() {
        String str = this.getAttribute("IdleStartTime", null, null);
        JDFDate ret = JDFDate.createDate(str);
        return ret;
    }

    public void setPowerOnTime(JDFDate value) {
        JDFDate date = value;
        if (date == null) {
            date = new JDFDate();
        }
        this.setAttribute("PowerOnTime", date.getDateTimeISO(), null);
    }

    public JDFDate getPowerOnTime() {
        String str = this.getAttribute("PowerOnTime", null, null);
        JDFDate ret = JDFDate.createDate(str);
        return ret;
    }

    public void setProductionCounter(double value) {
        this.setAttribute("ProductionCounter", value, null);
    }

    public double getProductionCounter() {
        return this.getRealAttribute("ProductionCounter", null, 0.0);
    }

    public void setSpeed(double value) {
        this.setAttribute("Speed", value, null);
    }

    public double getSpeed() {
        return this.getRealAttribute("Speed", null, 0.0);
    }

    public void setStatusDetails(String value) {
        this.setAttribute("StatusDetails", value, null);
    }

    public String getStatusDetails() {
        return this.getAttribute("StatusDetails", null, "");
    }

    public void setTotalProductionCounter(double value) {
        this.setAttribute("TotalProductionCounter", value, null);
    }

    public double getTotalProductionCounter() {
        return this.getRealAttribute("TotalProductionCounter", null, 0.0);
    }

    public JDFActivity getCreateActivity(int iSkip) {
        return (JDFActivity)this.getCreateElement_KElement("Activity", null, iSkip);
    }

    public JDFActivity getActivity(int iSkip) {
        return (JDFActivity)this.getElement("Activity", null, iSkip);
    }

    public Collection<JDFActivity> getAllActivity() {
        VElement vc = this.getChildElementVector("Activity", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFActivity> v = new Vector<JDFActivity>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFActivity)vc.get(i));
        }
        return v;
    }

    public JDFActivity appendActivity() {
        return (JDFActivity)this.appendElement("Activity", null);
    }

    public JDFDevice getDevice() {
        return (JDFDevice)this.getElement("Device", null, 0);
    }

    public JDFDevice getCreateDevice() {
        return (JDFDevice)this.getCreateElement_KElement("Device", null, 0);
    }

    public JDFDevice appendDevice() throws JDFException {
        return (JDFDevice)this.appendElementN("Device", 1, null);
    }

    public JDFEmployee getCreateEmployee(int iSkip) {
        return (JDFEmployee)this.getCreateElement_KElement("Employee", null, iSkip);
    }

    public JDFEmployee getEmployee(int iSkip) {
        return (JDFEmployee)this.getElement("Employee", null, iSkip);
    }

    public Collection<JDFEmployee> getAllEmployee() {
        VElement vc = this.getChildElementVector("Employee", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFEmployee> v = new Vector<JDFEmployee>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFEmployee)vc.get(i));
        }
        return v;
    }

    public JDFEmployee appendEmployee() {
        return (JDFEmployee)this.appendElement("Employee", null);
    }

    public JDFJobPhase getCreateJobPhase(int iSkip) {
        return (JDFJobPhase)this.getCreateElement_KElement("JobPhase", null, iSkip);
    }

    public JDFJobPhase getJobPhase(int iSkip) {
        return (JDFJobPhase)this.getElement("JobPhase", null, iSkip);
    }

    public Collection<JDFJobPhase> getAllJobPhase() {
        VElement vc = this.getChildElementVector("JobPhase", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFJobPhase> v = new Vector<JDFJobPhase>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFJobPhase)vc.get(i));
        }
        return v;
    }

    public JDFJobPhase appendJobPhase() {
        return (JDFJobPhase)this.appendElement("JobPhase", null);
    }

    public JDFModuleStatus getCreateModuleStatus(int iSkip) {
        return (JDFModuleStatus)this.getCreateElement_KElement("ModuleStatus", null, iSkip);
    }

    public JDFModuleStatus getModuleStatus(int iSkip) {
        return (JDFModuleStatus)this.getElement("ModuleStatus", null, iSkip);
    }

    public Collection<JDFModuleStatus> getAllModuleStatus() {
        VElement vc = this.getChildElementVector("ModuleStatus", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFModuleStatus> v = new Vector<JDFModuleStatus>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFModuleStatus)vc.get(i));
        }
        return v;
    }

    public JDFModuleStatus appendModuleStatus() {
        return (JDFModuleStatus)this.appendElement("ModuleStatus", null);
    }

    static {
        JDFAutoDeviceInfo.atrInfoTable[0] = new AtrInfoTable("CounterUnit", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoDeviceInfo.atrInfoTable[1] = new AtrInfoTable("DeviceCondition", 0x33333311L, AttributeInfo.EnumAttributeType.enumeration, EnumDeviceCondition.getEnum(0), null);
        JDFAutoDeviceInfo.atrInfoTable[2] = new AtrInfoTable("DeviceID", 0x33333111L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoDeviceInfo.atrInfoTable[3] = new AtrInfoTable("DeviceOperationMode", 0x33333311L, AttributeInfo.EnumAttributeType.enumeration, EnumDeviceOperationMode.getEnum(0), null);
        JDFAutoDeviceInfo.atrInfoTable[4] = new AtrInfoTable("DeviceStatus", 0x22222222L, AttributeInfo.EnumAttributeType.enumeration, EnumDeviceStatus.getEnum(0), null);
        JDFAutoDeviceInfo.atrInfoTable[5] = new AtrInfoTable("HourCounter", 0x33333333L, AttributeInfo.EnumAttributeType.duration, null, null);
        JDFAutoDeviceInfo.atrInfoTable[6] = new AtrInfoTable("IdleStartTime", 0x33331111L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFAutoDeviceInfo.atrInfoTable[7] = new AtrInfoTable("PowerOnTime", 0x33333333L, AttributeInfo.EnumAttributeType.dateTime, null, null);
        JDFAutoDeviceInfo.atrInfoTable[8] = new AtrInfoTable("ProductionCounter", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoDeviceInfo.atrInfoTable[9] = new AtrInfoTable("Speed", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoDeviceInfo.atrInfoTable[10] = new AtrInfoTable("StatusDetails", 0x33333333L, AttributeInfo.EnumAttributeType.shortString, null, null);
        JDFAutoDeviceInfo.atrInfoTable[11] = new AtrInfoTable("TotalProductionCounter", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        elemInfoTable = new ElemInfoTable[5];
        JDFAutoDeviceInfo.elemInfoTable[0] = new ElemInfoTable("Activity", 0x33311111L);
        JDFAutoDeviceInfo.elemInfoTable[1] = new ElemInfoTable("Device", 0x66666666L);
        JDFAutoDeviceInfo.elemInfoTable[2] = new ElemInfoTable("Employee", 0x44433333L);
        JDFAutoDeviceInfo.elemInfoTable[3] = new ElemInfoTable("JobPhase", 0x33333333L);
        JDFAutoDeviceInfo.elemInfoTable[4] = new ElemInfoTable("ModuleStatus", 0x33333333L);
    }

    public static class EnumDeviceStatus
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumDeviceStatus Unknown = new EnumDeviceStatus("Unknown");
        public static final EnumDeviceStatus Idle = new EnumDeviceStatus("Idle");
        public static final EnumDeviceStatus Down = new EnumDeviceStatus("Down");
        public static final EnumDeviceStatus Setup = new EnumDeviceStatus("Setup");
        public static final EnumDeviceStatus Running = new EnumDeviceStatus("Running");
        public static final EnumDeviceStatus Cleanup = new EnumDeviceStatus("Cleanup");
        public static final EnumDeviceStatus Stopped = new EnumDeviceStatus("Stopped");

        private EnumDeviceStatus(String name) {
            super(name, m_startValue++);
        }

        public static EnumDeviceStatus getEnum(String enumName) {
            return (EnumDeviceStatus)EnumDeviceStatus.getEnum(EnumDeviceStatus.class, (String)enumName);
        }

        public static EnumDeviceStatus getEnum(int enumValue) {
            return (EnumDeviceStatus)EnumDeviceStatus.getEnum(EnumDeviceStatus.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumDeviceStatus.getEnumMap(EnumDeviceStatus.class);
        }

        public static List getEnumList() {
            return EnumDeviceStatus.getEnumList(EnumDeviceStatus.class);
        }

        public static Iterator iterator() {
            return EnumDeviceStatus.iterator(EnumDeviceStatus.class);
        }
    }

    public static class EnumDeviceOperationMode
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumDeviceOperationMode Productive = new EnumDeviceOperationMode("Productive");
        public static final EnumDeviceOperationMode NonProductive = new EnumDeviceOperationMode("NonProductive");
        public static final EnumDeviceOperationMode Maintenance = new EnumDeviceOperationMode("Maintenance");

        private EnumDeviceOperationMode(String name) {
            super(name, m_startValue++);
        }

        public static EnumDeviceOperationMode getEnum(String enumName) {
            return (EnumDeviceOperationMode)EnumDeviceOperationMode.getEnum(EnumDeviceOperationMode.class, (String)enumName);
        }

        public static EnumDeviceOperationMode getEnum(int enumValue) {
            return (EnumDeviceOperationMode)EnumDeviceOperationMode.getEnum(EnumDeviceOperationMode.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumDeviceOperationMode.getEnumMap(EnumDeviceOperationMode.class);
        }

        public static List getEnumList() {
            return EnumDeviceOperationMode.getEnumList(EnumDeviceOperationMode.class);
        }

        public static Iterator iterator() {
            return EnumDeviceOperationMode.iterator(EnumDeviceOperationMode.class);
        }
    }

    public static class EnumDeviceCondition
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumDeviceCondition OK = new EnumDeviceCondition("OK");
        public static final EnumDeviceCondition NeedsAttention = new EnumDeviceCondition("NeedsAttention");
        public static final EnumDeviceCondition Failure = new EnumDeviceCondition("Failure");
        public static final EnumDeviceCondition OffLine = new EnumDeviceCondition("OffLine");

        private EnumDeviceCondition(String name) {
            super(name, m_startValue++);
        }

        public static EnumDeviceCondition getEnum(String enumName) {
            return (EnumDeviceCondition)EnumDeviceCondition.getEnum(EnumDeviceCondition.class, (String)enumName);
        }

        public static EnumDeviceCondition getEnum(int enumValue) {
            return (EnumDeviceCondition)EnumDeviceCondition.getEnum(EnumDeviceCondition.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumDeviceCondition.getEnumMap(EnumDeviceCondition.class);
        }

        public static List getEnumList() {
            return EnumDeviceCondition.getEnumList(EnumDeviceCondition.class);
        }

        public static Iterator iterator() {
            return EnumDeviceCondition.iterator(EnumDeviceCondition.class);
        }
    }
}

