/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoCustomerInfo;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFContact;
import org.w3c.dom.Node;

public class JDFCustomerInfo
extends JDFAutoCustomerInfo {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[6];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        AttributeInfo ai = this.getParentNode().getLocalName().equals("JDF") ? super.getTheAttributeInfo_JDFElement().updateReplace(atrInfoTable) : super.getTheAttributeInfo().updateReplace(atrInfoTable);
        return ai;
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        ElementInfo ei = this.getParentNode().getLocalName().equals("JDF") ? new ElementInfo(super.getTheElementInfo_JDFElement(), elemInfoTable) : new ElementInfo(super.getTheElementInfo(), elemInfoTable);
        return ei;
    }

    public JDFCustomerInfo(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFCustomerInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFCustomerInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public boolean init() {
        Node n = this.getParentNode();
        if (n != null && n instanceof JDFResourcePool) {
            super.init();
            this.setResStatus(JDFResource.EnumResStatus.Available, false);
            this.setPartUsage(JDFResource.EnumPartUsage.Implicit);
        }
        return true;
    }

    @Override
    public String toString() {
        return "JDFCustomerInfo[  --> " + super.toString() + " ]";
    }

    public VElement getLinkedResources(JDFAttributeMap mResAtt, boolean bFollowRefs) {
        VElement v = this.getChildElementVector(null, null, null, true, 0, false);
        VElement vL = new VElement();
        for (int i = 0; i < v.size(); ++i) {
            if (!(v.elementAt(i) instanceof JDFRefElement)) continue;
            JDFRefElement l = (JDFRefElement)v.elementAt(i);
            JDFResource r = l.getTarget();
            JDFResource jDFResource = r = r == null ? null : r.getResourceRoot();
            if (r == null || !r.includesAttributes(mResAtt, true)) continue;
            vL.addElement(r);
            if (!bFollowRefs) continue;
            vL.appendUnique(r.getvHRefRes(bFollowRefs, true));
        }
        return vL;
    }

    public JDFContact getContactWithContactType(String contactType, int iSkip) {
        return (JDFContact)this.getChildWithMatchingAttribute("Contact", "ContactTypes", null, contactType, iSkip, true, AttributeInfo.EnumAttributeType.NMTOKENS);
    }

    public JDFContact getCreateContactWithContactType(String contactType, int iSkip) {
        JDFContact c = this.getContactWithContactType(contactType, iSkip);
        return c == null ? this.appendContact(contactType) : c;
    }

    public VElement getContactVectorWithContactType(String contactType) {
        VElement v = this.getChildElementVector("Contact", null, null, true, 0, true);
        if (JDFCustomerInfo.isWildCard(contactType)) {
            return v.size() == 0 ? null : v;
        }
        VElement v2 = new VElement();
        int siz = v.size();
        for (int i = 0; i < siz; ++i) {
            JDFContact contact = (JDFContact)v.elementAt(i);
            VString contactTypes = contact.getContactTypes();
            if (!contactTypes.contains(contactType)) continue;
            v2.add(contact);
        }
        return v2.size() > 0 ? v2 : null;
    }

    public JDFContact appendContact(JDFContact.EnumContactType typ) {
        JDFContact c = this.appendContact();
        c.setContactTypes(typ);
        return c;
    }

    public JDFContact appendContact(String typ) {
        JDFContact c = this.appendContact();
        c.setContactTypes(typ);
        return c;
    }

    static {
        JDFCustomerInfo.atrInfoTable[0] = new AtrInfoTable("BillingCode", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFCustomerInfo.atrInfoTable[1] = new AtrInfoTable("CustomerID", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFCustomerInfo.atrInfoTable[2] = new AtrInfoTable("CustomerJobName", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFCustomerInfo.atrInfoTable[3] = new AtrInfoTable("CustomerOrderID", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFCustomerInfo.atrInfoTable[4] = new AtrInfoTable("CustomerProjectID", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFCustomerInfo.atrInfoTable[5] = new AtrInfoTable("rRefs", 0x44444433L, AttributeInfo.EnumAttributeType.IDREFS, null, null);
        elemInfoTable = new ElemInfoTable[3];
        JDFCustomerInfo.elemInfoTable[0] = new ElemInfoTable("Company", 0x44444446L);
        JDFCustomerInfo.elemInfoTable[1] = new ElemInfoTable("Contact", 0x33333331L);
        JDFCustomerInfo.elemInfoTable[2] = new ElemInfoTable("CustomerMessage", 0x33333311L);
    }
}

