/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.AttrNSImpl;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.ElementNSImpl;
import org.apache.xerces.dom.ParentNode;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.cip4.jdflib.core.DocumentJDFImpl;
import org.cip4.jdflib.core.DocumentXMLImpl;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.core.XPathHelper;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class KElement
extends ElementNSImpl
implements Element {
    private static final long serialVersionUID = 1L;
    private static final Log kLog = LogFactory.getLog(JDFElement.class);
    private static int m_lStoreID = 0;
    private static boolean bIDDate = true;
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyMMdd_kkmmssSSS");

    public KElement(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public KElement(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public KElement(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public boolean isDirty() {
        return ((DocumentXMLImpl)this.ownerDocument).bGlobalDirtyFlag;
    }

    @Deprecated
    public void setDirty() {
        this.setDirty(false);
    }

    public void setDirty(boolean bAttribute) {
        ((DocumentXMLImpl)this.ownerDocument).bGlobalDirtyFlag = true;
    }

    public XMLDoc getOwnerDocument_KElement() {
        Document doc = this.getOwnerDocument();
        return new XMLDoc(doc);
    }

    public String getInheritedAttribute(String attrib, String nameSpaceURI, String def) {
        return this.getInheritedAttribute_KElement(attrib, nameSpaceURI, def);
    }

    private String getInheritedAttribute_KElement(String attrib, String nameSpaceURI, String def) {
        KElement parentNode;
        String strRet = this.getAttribute_KElement(attrib, nameSpaceURI, null);
        if (strRet == null && (parentNode = this.getParentNode_KElement()) != null) {
            strRet = parentNode.getInheritedAttribute(attrib, nameSpaceURI, def);
        }
        return strRet == null ? def : strRet;
    }

    public String getAttribute(String attrib, String nameSpaceURI, String def) {
        return this.getAttribute_KElement(attrib, nameSpaceURI, def);
    }

    public String getAttribute_KElement(String attrib, String nameSpaceURI, String def) {
        Attr attribute = this.getDOMAttr(attrib, nameSpaceURI, false);
        return attribute == null ? def : attribute.getValue();
    }

    @Override
    public String getAttribute(String strLocalName) {
        return this.getAttribute(strLocalName, null, "");
    }

    public String getAttributeRaw(String qualifiedName) {
        Attr a = this.getAttributeNode(qualifiedName);
        return a == null ? null : a.getValue();
    }

    public String getAttribute_KElement(String strLocalName) {
        return this.getAttribute_KElement(strLocalName, null, "");
    }

    public KElement getParentNode_KElement() {
        Node parentNode = this.getParentNode();
        if (parentNode instanceof KElement) {
            return (KElement)parentNode;
        }
        return null;
    }

    @Deprecated
    public void setvStringAttribute(String key, VString value, String nameSpaceURI) {
        this.setAttribute(key, value, nameSpaceURI);
    }

    public void setAttribute(String key, VString value, String nameSpaceURI) {
        String s = StringUtil.setvString(value);
        this.setAttribute(key, s, nameSpaceURI);
    }

    public Attr getDOMAttr(String attrib, String nameSpaceURI, boolean bInherit) {
        KElement parent;
        String xmlnsLocalName;
        Attr a = null;
        if (nameSpaceURI == null || nameSpaceURI.equals("")) {
            a = this.getAttributeNode(attrib);
            if (a != null) {
                return a;
            }
            nameSpaceURI = null;
            String attribPrefix = KElement.xmlnsPrefix(attrib);
            String elementPrefix = this.getPrefix();
            if (elementPrefix != null && attribPrefix != null && attribPrefix.equals(elementPrefix)) {
                a = this.getAttributeNode(attrib.substring(elementPrefix.length() + 1));
            } else if (elementPrefix != null && attribPrefix == null) {
                a = this.getAttributeNode(elementPrefix + ":" + attrib);
            }
            if (a == null && !attrib.startsWith("xmlns")) {
                nameSpaceURI = this.getNamespaceURIFromPrefix(attribPrefix);
            }
        }
        if (a == null && nameSpaceURI != null && (a = this.getAttributeNodeNS(nameSpaceURI, xmlnsLocalName = KElement.xmlnsLocalName(attrib))) == null && nameSpaceURI.equals(this.getNamespaceURI())) {
            a = this.getAttributeNodeNS(null, xmlnsLocalName);
        }
        if (a == null && bInherit && (parent = this.getParentNode_KElement()) != null) {
            return parent.getDOMAttr(attrib, nameSpaceURI, bInherit);
        }
        return a;
    }

    public void setAttribute(String key, String value, String nameSpaceURI) {
        Document d = this.getOwnerDocument();
        if (d instanceof DocumentXMLImpl && !((DocumentXMLImpl)((Object)d)).isStrictNSCheck()) {
            super.setAttributeNS(nameSpaceURI, key, value);
            return;
        }
        boolean bDirty = false;
        if (value == null) {
            this.removeAttribute(key, nameSpaceURI);
            return;
        }
        bDirty = nameSpaceURI == null || nameSpaceURI.equals("") ? this.setDomAttribute2FromDom1(key, value) : this.setDomAttribute2FromDom2(key, value, nameSpaceURI);
        if (bDirty) {
            this.setDirty(true);
        }
    }

    private boolean setDomAttribute2FromDom2(String key, String value, String nameSpaceURI) {
        boolean bDirty = false;
        if ("http://www.w3.org/2000/xmlns/".equals(nameSpaceURI)) {
            if (value.equals("")) {
                bDirty = true;
                this.removeAttributeNS(nameSpaceURI, key);
            } else if (!value.equals(this.getInheritedAttribute(KElement.xmlnsLocalName(key), nameSpaceURI, null))) {
                bDirty = true;
                this.removeAttribute(key);
                super.setAttributeNS("http://www.w3.org/2000/xmlns/", key, value);
                this.getNamespaceURIFromPrefix(StringUtil.rightStr(key, -6), true);
            }
        } else {
            Attr a = this.getAttributeNodeNS(nameSpaceURI, KElement.xmlnsLocalName(key));
            if (a == null || !value.equals(a.getNodeValue())) {
                bDirty = true;
                if (a != null) {
                    String nodeName = a.getNodeName();
                    if (!key.equals(nodeName)) {
                        super.setAttributeNS(nameSpaceURI, key, value);
                    } else {
                        a.setNodeValue(value);
                    }
                } else {
                    String namespaceURI2 = this.getNamespaceURIFromPrefix(KElement.xmlnsPrefix(key), true);
                    if (!(namespaceURI2 == null || "".equals(namespaceURI2) || namespaceURI2.equals(nameSpaceURI) || ContainerUtil.equals(namespaceURI2 = this.getNamespaceURIFromPrefix(KElement.xmlnsPrefix(key), false), nameSpaceURI))) {
                        String message = "KElement.setAttribute: inconsistent namespace URI for prefix: " + KElement.xmlnsPrefix(key) + "; existing URI: " + namespaceURI2 + "; attempting to set URI: " + nameSpaceURI;
                        kLog.error((Object)message);
                        throw new JDFException(message);
                    }
                    this.removeAttribute(key);
                    if (nameSpaceURI.equals(this.getNamespaceURI())) {
                        this.removeAttributeNS(nameSpaceURI, KElement.xmlnsLocalName(key));
                        if (KElement.xmlnsPrefix(key) == null) {
                            nameSpaceURI = null;
                        }
                    }
                    super.setAttributeNS(nameSpaceURI, key, value);
                }
            }
        }
        return bDirty;
    }

    private boolean setDomAttribute2FromDom1(String key, String value) {
        String nameSpaceURI = null;
        boolean bDirty = false;
        if (key.startsWith("xmlns") && (key.length() == 5 || key.charAt(5) == ':')) {
            if (value.equals("")) {
                Attr a = this.getAttributeNode(key);
                if (a != null) {
                    bDirty = true;
                    this.removeAttribute(key);
                }
            } else if (!value.equals(this.getInheritedAttribute(key, null, null))) {
                bDirty = true;
                String myPrefix = KElement.xmlnsLocalName(key);
                if ("xmlns".equals(key)) {
                    myPrefix = null;
                } else {
                    super.setAttributeNS("http://www.w3.org/2000/xmlns/", key, value);
                }
                DocumentXMLImpl doc = (DocumentXMLImpl)((Object)this.getOwnerDocument());
                doc.setNamespaceURIFromPrefix(myPrefix, value);
            }
            String prefixElem = this.getPrefix();
            String prefixValue = StringUtil.token(key, 1, ":");
            if (ContainerUtil.equals(prefixElem, prefixValue) && !value.equals(super.getNamespaceURI())) {
                this.setNamespaceURI(value);
            }
        } else {
            String attributePrefix = KElement.xmlnsPrefix(key);
            if (attributePrefix == null) {
                bDirty = true;
                super.setAttributeNS(null, key, value);
            } else {
                String namespaceURI2 = this.getNamespaceURIFromPrefix(attributePrefix);
                if (namespaceURI2 != null) {
                    this.setAttribute(key, value, namespaceURI2);
                } else {
                    Attr a = this.getDOMAttr(key, null, false);
                    if (a == null || !value.equals(a.getNodeValue())) {
                        bDirty = true;
                        if (a != null) {
                            String nodeName = a.getNodeName();
                            if (key.equals(nodeName)) {
                                this.removeAttribute(nodeName);
                                super.setAttribute(key, value);
                            } else {
                                a.setNodeValue(value);
                            }
                        } else {
                            String nsURI2 = this.getNamespaceURIFromPrefix(KElement.xmlnsPrefix(key));
                            if (nsURI2 != null && !nsURI2.equals(nameSpaceURI)) {
                                throw new JDFException("KElement.setAttribute: inconsistent namespace URI for prefix: " + KElement.xmlnsPrefix(key) + "; existing URI: " + nsURI2 + "; attempting to set URI: " + nameSpaceURI);
                            }
                            try {
                                super.setAttributeNS(nsURI2, key, value);
                            }
                            catch (DOMException de) {
                                super.setAttribute(key, value);
                            }
                        }
                    }
                }
            }
        }
        return bDirty;
    }

    @Override
    public void setAttribute(String key, String value) {
        this.setAttribute(key, value, null);
    }

    public void setAttributeRaw(String key, String value) {
        super.setAttribute(key, value);
    }

    public void setAttributeNSRaw(String ns, String key, String value) {
        super.setAttributeNS(ns, key, value);
    }

    @Deprecated
    public void setIntAttribute(String key, int value, String nameSpaceURI) {
        this.setAttribute(key, value, nameSpaceURI);
    }

    public void setAttribute(String key, int value, String nameSpaceURI) {
        this.setAttribute(key, StringUtil.formatInteger(value), nameSpaceURI);
    }

    public void setAttribute(String key, long value, String nameSpaceURI) {
        this.setAttribute(key, StringUtil.formatLong(value), nameSpaceURI);
    }

    @Deprecated
    public void setRealAttribute(String key, double value, String nameSpaceURI) {
        this.setAttribute(key, StringUtil.formatDouble(value), nameSpaceURI);
    }

    public void setAttribute(String key, double value, String nameSpaceURI) {
        this.setAttribute(key, StringUtil.formatDouble(value), nameSpaceURI);
    }

    public void setAttribute(String key, double value, String nameSpaceURI, int precision) {
        this.setAttribute(key, StringUtil.formatDouble(value, precision), nameSpaceURI);
    }

    @Deprecated
    public void setBoolAttribute(String key, boolean b, String nameSpaceURI) {
        this.setAttribute(key, b, nameSpaceURI);
    }

    public void setAttribute(String key, boolean b, String nameSpaceURI) {
        this.setAttribute(key, b ? "true" : "false", nameSpaceURI);
    }

    public double addAttribute(String key, double inc, String nameSpaceURI) {
        double d = this.getRealAttribute(key, nameSpaceURI, 0.0);
        this.setAttribute(key, d += inc, this.namespaceURI);
        return d;
    }

    public int addAttribute(String key, int inc, String nameSpaceURI) {
        int i = this.getIntAttribute(key, nameSpaceURI, 0);
        this.setAttribute(key, i += inc, this.namespaceURI);
        return i;
    }

    public void removeAttribute(String attrib, String nameSpaceURI) {
        this.removeAttribute_KElement(attrib, nameSpaceURI);
    }

    public void removeAttribute_KElement(String attrib, String nameSpaceURI) {
        if (this.hasAttribute(attrib, nameSpaceURI, false)) {
            if (nameSpaceURI == null || nameSpaceURI.equals("")) {
                super.removeAttribute(attrib);
            } else {
                super.removeAttributeNS(nameSpaceURI, KElement.xmlnsLocalName(attrib));
                if (nameSpaceURI.equals(this.getNamespaceURI())) {
                    super.removeAttributeNS(null, attrib);
                }
            }
            this.setDirty(true);
        }
    }

    @Override
    public boolean hasAttribute(String attrib) {
        return this.hasAttribute_KElement(attrib, null, false);
    }

    public boolean hasAttribute(String attrib, String nameSpaceURI, boolean bInherit) {
        return this.hasAttribute_KElement(attrib, nameSpaceURI, bInherit);
    }

    public boolean hasAttribute_KElement(String attrib, String nameSpaceURI, boolean bInherit) {
        return this.getDOMAttr(attrib, nameSpaceURI, bInherit) != null;
    }

    public String appendAttribute(String key, String value, String nameSpaceURI, String sep, boolean bUnique) {
        if (value == null) {
            return this.getAttribute(key, nameSpaceURI, null);
        }
        String oldVal = this.getAttribute_KElement(key, nameSpaceURI, null);
        if (oldVal == null) {
            this.setAttribute(key, value, nameSpaceURI);
            return value;
        }
        if (sep == null) {
            sep = " ";
        }
        if (!bUnique || !StringUtil.hasToken(oldVal, value, sep, 0)) {
            String newValue = oldVal + sep + value;
            this.setAttribute(key, newValue, nameSpaceURI);
            return newValue;
        }
        return oldVal;
    }

    public static boolean isWildCard(String nodeName) {
        return nodeName == null || "".equals(nodeName) || "*".equals(nodeName);
    }

    public boolean fitsName(String nodeName, String nameSpaceURI) {
        return this.fitsName_KElement(nodeName, nameSpaceURI);
    }

    protected boolean fitsName_KElement(String nodeName, String nameSpaceURI) {
        String s;
        boolean bNameOK;
        boolean bl = bNameOK = nodeName == null || KElement.isWildCard(nodeName);
        if (!bNameOK && (bNameOK = (s = this.getNodeName()).endsWith(nodeName)) && !s.equals(nodeName) && nodeName != null) {
            bNameOK = nodeName.equals(KElement.xmlnsLocalName(s));
        }
        if (bNameOK && nameSpaceURI != null && !KElement.isWildCard(nameSpaceURI) && !nameSpaceURI.equals(this.getNamespaceURI())) {
            bNameOK = false;
        }
        return bNameOK;
    }

    public String getNamespaceURIFromPrefix(String prefix) {
        return this.getNamespaceURIFromPrefix(prefix, true);
    }

    private String getNamespaceURIFromPrefix(String prefix, boolean bcache) {
        String strNamespaceURI = null;
        if (prefix == null || prefix.equals("")) {
            String elementPrefix = this.getPrefix();
            if (elementPrefix == null && (strNamespaceURI = this.getNamespaceURI()) != null) {
                return strNamespaceURI;
            }
            strNamespaceURI = this.getAttribute("xmlns", null, null);
            if (strNamespaceURI != null) {
                return strNamespaceURI;
            }
        } else {
            if (prefix.equals("xsi")) {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
            if (prefix.equals("xmlns")) {
                return "http://www.w3.org/2000/xmlns/";
            }
            DocumentXMLImpl DocumentXMLImpl2 = (DocumentXMLImpl)((Object)this.getOwnerDocument());
            if (bcache && (strNamespaceURI = DocumentXMLImpl2.getNamespaceURIFromPrefix(prefix)) != null) {
                return strNamespaceURI;
            }
            String elementPrefix = this.getPrefix();
            if (prefix.equals(elementPrefix) && (strNamespaceURI = this.getNamespaceURI()) != null) {
                DocumentXMLImpl2.setNamespaceURIFromPrefix(prefix, strNamespaceURI);
                return strNamespaceURI;
            }
            strNamespaceURI = this.getAttribute(prefix, "http://www.w3.org/2000/xmlns/", null);
            if (strNamespaceURI == null) {
                strNamespaceURI = StringUtil.getNonEmpty(super.getAttribute("xmlns:" + prefix));
            }
            if (strNamespaceURI != null) {
                DocumentXMLImpl2.setNamespaceURIFromPrefix(prefix, strNamespaceURI);
                return strNamespaceURI;
            }
            NamedNodeMap nl = this.getAttributes();
            int length = nl.getLength();
            for (int i = 0; i < length; ++i) {
                AttrNSImpl ati;
                Node at = nl.item(i);
                if (!(at instanceof AttrNSImpl) || !prefix.equals((ati = (AttrNSImpl)at).getPrefix()) || (strNamespaceURI = ati.getNamespaceURI()) == null) continue;
                DocumentXMLImpl2.setNamespaceURIFromPrefix(prefix, strNamespaceURI);
                return strNamespaceURI;
            }
            KElement e = this.getParentNode_KElement();
            if (e != null) {
                return e.getNamespaceURIFromPrefix(prefix, bcache);
            }
        }
        return null;
    }

    @Override
    public String getNamespaceURI() {
        String s = super.getNamespaceURI();
        if (s != null && s != "" || ((DocumentXMLImpl)((Object)this.getOwnerDocument())).isIgnoreNSDefault()) {
            return s;
        }
        s = this.getPrefix();
        for (KElement parent = this.getParentNode_KElement(); parent != null; parent = parent.getParentNode_KElement()) {
            String nsuri;
            String prefix = KElement.xmlnsPrefix(parent.getNodeName());
            if ((prefix != null || s != null) && (prefix == null || !prefix.equals(s)) || (nsuri = parent.getNamespaceURI()) == null) continue;
            this.namespaceURI = nsuri;
            return nsuri;
        }
        String nsuri = s != null ? this.getInheritedAttribute("xmlns:" + s, null, null) : this.getInheritedAttribute("xmlns", null, null);
        if (nsuri != null) {
            this.namespaceURI = nsuri;
        } else if (s == null) {
            // empty if block
        }
        return nsuri;
    }

    public static String xmlnsPrefix(String nodeName) {
        int posColon;
        if (nodeName != null && (posColon = nodeName.indexOf(58)) > 0) {
            return nodeName.substring(0, posColon);
        }
        return null;
    }

    @Deprecated
    public static String getLocalNameStatic(KElement kElem) {
        return kElem.getLocalName();
    }

    public int setAttributes(JDFAttributeMap map) {
        int iRet = 0;
        if (map != null && !map.isEmpty()) {
            Iterator<String> it = map.getKeyIterator();
            while (it.hasNext()) {
                String key = it.next();
                String value = map.get(key);
                this.setAttribute(key, value, null);
            }
            iRet = map.size();
        }
        return iRet;
    }

    public int setAttributes(KElement kElem) {
        return this.setAttributes(kElem, null);
    }

    public void setAttributesRaw(KElement kElem) {
        if (kElem == null) {
            return;
        }
        NamedNodeMap nm = kElem.getAttributes();
        if (nm != null) {
            int siz = nm.getLength();
            for (int i = 0; i < siz; ++i) {
                Node a = nm.item(i);
                super.setAttributeNS(a.getNamespaceURI(), a.getNodeName(), a.getNodeValue());
            }
        }
    }

    public int setAttributes(KElement kElem, VString ignoreList) {
        if (kElem == null) {
            return 0;
        }
        int siz = 0;
        NamedNodeMap nm = kElem.getAttributes();
        if (nm != null) {
            siz = nm.getLength();
            boolean bCatch = false;
            for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < siz; ++i) {
                    Node a = nm.item(i);
                    if (ignoreList != null && ignoreList.contains(a.getLocalName())) continue;
                    try {
                        this.setAttribute(a.getNodeName(), a.getNodeValue(), a.getNamespaceURI());
                        continue;
                    }
                    catch (JDFException x) {
                        bCatch = true;
                        if (j != 1) continue;
                        throw x;
                    }
                }
                if (!bCatch) break;
            }
        }
        return siz;
    }

    public JDFAttributeMap getAttributeMap() {
        JDFAttributeMap m = new JDFAttributeMap();
        NamedNodeMap nm = this.getAttributes();
        if (nm != null) {
            int siz = nm.getLength();
            for (int i = 0; i < siz; ++i) {
                Node a = nm.item(i);
                String nodeName = a.getNodeName();
                m.put(nodeName, a.getNodeValue());
            }
        }
        return m;
    }

    public boolean init() {
        return true;
    }

    public synchronized KElement appendElement(String elementName, String nameSpaceURI) {
        KElement newChild = this.appendElementRaw(elementName, nameSpaceURI);
        this.setDirty(false);
        return newChild;
    }

    public synchronized KElement appendElementRaw(String elementName, String nameSpaceURI) {
        KElement newChild = this.createChildFromName(elementName, nameSpaceURI);
        this.appendChild(newChild);
        return newChild;
    }

    private KElement createChildFromName(String elementName, String nameSpaceURI) {
        KElement newChild = null;
        DocumentXMLImpl ownerDoc = (DocumentXMLImpl)((Object)this.getOwnerDocument());
        if (nameSpaceURI == null || "".equals(nameSpaceURI)) {
            if (ownerDoc.isStrictNSCheck()) {
                String xmlnsPrefix = KElement.xmlnsPrefix(elementName);
                boolean ignoreNSDefault = ownerDoc.isIgnoreNSDefault();
                String namespaceURI2 = ignoreNSDefault && xmlnsPrefix == null ? nameSpaceURI : this.getNamespaceURIFromPrefix(xmlnsPrefix);
                namespaceURI2 = StringUtil.getNonEmpty(namespaceURI2);
                if (xmlnsPrefix != null && namespaceURI2 == null) {
                    throw new JDFException("You tried to add an element \"" + elementName + "\" in an unspecified Namespace");
                }
                newChild = namespaceURI2 != null ? ownerDoc.factoryCreate((ParentNode)this, namespaceURI2, elementName) : ownerDoc.factoryCreate((ParentNode)this, elementName);
            } else {
                newChild = ownerDoc.factoryCreate((ParentNode)this, elementName);
            }
        } else {
            newChild = ownerDoc.factoryCreate((ParentNode)this, nameSpaceURI, elementName);
        }
        return newChild;
    }

    public KElement appendElement(String elementName) {
        return this.appendElement(elementName, null);
    }

    public void copyElements(VElement v, KElement beforeChild) {
        if (v == null) {
            return;
        }
        for (KElement e : v) {
            this.copyElement(e, beforeChild);
        }
    }

    public KElement deleteNode() {
        KElement parentElement = this.getParentNode_KElement();
        if (parentElement != null) {
            return (KElement)parentElement.removeChild(this);
        }
        return null;
    }

    public synchronized KElement[] getChildElementArray() {
        VElement v = new VElement();
        v.ensureCapacity(10);
        for (Node n = this.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            v.add((KElement)n);
        }
        int size = v.size();
        KElement[] a = new KElement[size];
        return v.toArray(a);
    }

    @Deprecated
    public VElement getChildElementVector(String nodeName, String nameSpaceURI, JDFAttributeMap mAttrib, boolean bAnd, int maxSize) {
        return this.getChildElementVector(nodeName, nameSpaceURI, mAttrib, bAnd, maxSize, false);
    }

    public VElement getChildElementVector(String nodeName, String nameSpaceURI, JDFAttributeMap mAttrib, boolean bAnd, int maxSize, boolean bResolveTarget) {
        return this.getChildElementVector_KElement(nodeName, nameSpaceURI, mAttrib, bAnd, maxSize);
    }

    public VElement getChildElementVector(String nodeName, String nameSpaceURI) {
        return this.getChildElementVector(nodeName, nameSpaceURI, null, true, 0, true);
    }

    public synchronized VElement getChildElementVector_KElement(String nodeName, String nameSpaceURI, JDFAttributeMap mAttrib, boolean bAnd, int maxSize) {
        VElement v = new VElement();
        if (KElement.isWildCard(nodeName)) {
            nodeName = null;
        }
        if (KElement.isWildCard(nameSpaceURI)) {
            nameSpaceURI = null;
        }
        if (mAttrib != null && mAttrib.isEmpty()) {
            mAttrib = null;
        }
        boolean bAlwaysFit = nodeName == null && nameSpaceURI == null;
        boolean bMapEmpty = mAttrib == null;
        int iSize = 0;
        for (KElement kElem = this.getFirstChildElement(); kElem != null; kElem = kElem.getNextSiblingElement()) {
            if (!bAlwaysFit && !kElem.fitsName_KElement(nodeName, nameSpaceURI) || !bMapEmpty && !kElem.includesAttributes(mAttrib, bAnd)) continue;
            v.addElement(kElem);
            if (++iSize == maxSize) break;
        }
        return v;
    }

    public void removeChildrenByClass(Class<? extends Node> clazz) {
        Node parent;
        Node n = this.getFirstChild();
        Node node = parent = n == null ? null : n.getParentNode();
        while (n != null) {
            Node nTmp = n.getNextSibling();
            if (clazz.isInstance(n)) {
                parent.removeChild(n);
            }
            n = nTmp;
        }
    }

    public <a extends KElement> Vector<a> getChildrenByClass(Class<a> clazz, boolean bRecurse, int nMax) {
        Vector<KElement> v = new Vector<KElement>();
        boolean bFound = false;
        for (Node n = this.getFirstChild(); n != null; n = n.getNextSibling()) {
            Vector<a> childrenByClass;
            if (clazz.isInstance(n)) {
                v.add((KElement)n);
                bFound = true;
            }
            if (bRecurse && n instanceof KElement && (childrenByClass = ((KElement)n).getChildrenByClass(clazz, bRecurse, nMax)) != null) {
                v.addAll(childrenByClass);
                bFound = true;
            }
            if (bFound && nMax > 0 && nMax >= v.size()) break;
        }
        return v;
    }

    public KElement getFirstChildElement() {
        for (Node firstChildElement = this.getFirstChild(); firstChildElement != null; firstChildElement = firstChildElement.getNextSibling()) {
            if (!(firstChildElement instanceof KElement)) continue;
            return (KElement)firstChildElement;
        }
        return null;
    }

    public KElement getNextSiblingElement() {
        for (Node nextSiblingElement = this.getNextSibling(); nextSiblingElement != null; nextSiblingElement = nextSiblingElement.getNextSibling()) {
            if (!(nextSiblingElement instanceof KElement)) continue;
            return (KElement)nextSiblingElement;
        }
        return null;
    }

    public KElement getPreviousSiblingElement() {
        for (Node previousSiblingElement = this.getPreviousSibling(); previousSiblingElement != null; previousSiblingElement = previousSiblingElement.getPreviousSibling()) {
            if (!(previousSiblingElement instanceof KElement)) continue;
            return (KElement)previousSiblingElement;
        }
        return null;
    }

    public <a extends KElement> a getNextSiblingElement(Class<a> clazz) {
        for (Node e = this.getNextSibling(); e != null; e = e.getNextSibling()) {
            if (!clazz.isInstance(e)) continue;
            return (a)((KElement)e);
        }
        return null;
    }

    public <a extends KElement> a getFirstChildElement(Class<a> clazz) {
        for (Node e = this.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (!clazz.isInstance(e)) continue;
            return (a)((KElement)e);
        }
        return null;
    }

    public KElement getNextSiblingElement(String nodeName, String nameSpaceURI) {
        for (KElement e = this.getNextSiblingElement(); e != null; e = e.getNextSiblingElement()) {
            if (!e.fitsName(nodeName, nameSpaceURI)) continue;
            return e;
        }
        return null;
    }

    public KElement getFirstChildElement(String nodeName, String nameSpaceURI) {
        for (KElement e = this.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!e.fitsName(nodeName, nameSpaceURI)) continue;
            return e;
        }
        return null;
    }

    public KElement getPreviousSiblingElement(String nodeName, String nameSpaceURI) {
        for (KElement e = this.getPreviousSiblingElement(); e != null; e = e.getPreviousSiblingElement()) {
            if (!e.fitsName(nodeName, nameSpaceURI)) continue;
            return e;
        }
        return null;
    }

    public boolean includesAttributes(JDFAttributeMap aMap, boolean bAnd) {
        if (aMap == null || aMap.isEmpty()) {
            return true;
        }
        Iterator<String> it = aMap.getKeyIterator();
        if (bAnd) {
            while (it.hasNext()) {
                String value;
                String key = it.next();
                if (this.includesAttribute(key, value = aMap.get(key))) continue;
                return false;
            }
            return true;
        }
        while (it.hasNext()) {
            String value;
            String key = it.next();
            if (!this.includesAttribute(key, value = aMap.get(key))) continue;
            return true;
        }
        return false;
    }

    public boolean includesAttribute(String attName, String attValue) {
        Attr attr = this.getDOMAttr(attName, null, false);
        if (attr == null) {
            return false;
        }
        if (KElement.isWildCard(attValue)) {
            return true;
        }
        return attValue.equals(attr.getValue());
    }

    public VElement getChildrenByTagName(String elementName, String nameSpaceURI, JDFAttributeMap mAttrib, boolean bDirect, boolean bAnd, int maxSize) {
        boolean bAlwaysFit;
        if (bDirect) {
            return this.getChildElementVector(elementName, nameSpaceURI, mAttrib, bAnd, maxSize, true);
        }
        boolean bHasNoMap = mAttrib == null || mAttrib.isEmpty();
        VElement v = new VElement();
        boolean bl = bAlwaysFit = KElement.isWildCard(elementName) && KElement.isWildCard(nameSpaceURI);
        for (KElement e = this.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if ((bAlwaysFit || e.fitsName(elementName, nameSpaceURI)) && (bHasNoMap || e.includesAttributes(mAttrib, bAnd))) {
                v.add(e);
                if (maxSize > 0 && v.size() == maxSize) {
                    return v;
                }
            }
            int maxSizeRecurse = maxSize > 0 ? maxSize - v.size() : maxSize;
            VElement v2 = e.getChildrenByTagName(elementName, nameSpaceURI, mAttrib, bDirect, bAnd, maxSizeRecurse);
            v.addAll(v2);
            if (maxSize <= 0 || v.size() < maxSize) continue;
            return v;
        }
        return v;
    }

    public VElement getChildrenByTagName_KElement(String elementName, String nameSpaceURI, JDFAttributeMap mAttrib, boolean bDirect, boolean bAnd, int maxSize) {
        boolean bAlwaysFit;
        if (bDirect) {
            return this.getChildElementVector_KElement(elementName, nameSpaceURI, mAttrib, bAnd, maxSize);
        }
        boolean bHasNoMap = mAttrib == null || mAttrib.isEmpty();
        VElement v = new VElement();
        boolean bl = bAlwaysFit = KElement.isWildCard(elementName) && KElement.isWildCard(nameSpaceURI);
        for (KElement e = this.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if ((bAlwaysFit || e.fitsName_KElement(elementName, nameSpaceURI)) && (bHasNoMap || e.includesAttributes(mAttrib, bAnd))) {
                v.add(e);
                if (maxSize > 0 && v.size() == maxSize) {
                    return v;
                }
            }
            int maxSizeRecurse = maxSize > 0 ? maxSize - v.size() : maxSize;
            VElement v2 = e.getChildrenByTagName_KElement(elementName, nameSpaceURI, mAttrib, bDirect, bAnd, maxSizeRecurse);
            v.addAll(v2);
            if (maxSize <= 0 || v.size() < maxSize) continue;
            return v;
        }
        return v;
    }

    public VElement getElementsByTagName_KElement(String s, String nameSpaceURI) {
        VElement vEle = null;
        if (s == null) {
            s = "*";
        }
        vEle = nameSpaceURI == null || nameSpaceURI.equals("") ? new VElement(this.getElementsByTagName(s)) : new VElement(this.getElementsByTagNameNS(nameSpaceURI, s));
        return vEle;
    }

    @Deprecated
    public VElement getChildrenWithAttribute(String nodeName, String attName, String nameSpaceURI, String attVal, boolean bDirect) {
        return this.getChildrenByTagName(nodeName, nameSpaceURI, new JDFAttributeMap(attName, attVal), bDirect, true, 0);
    }

    public KElement getCreateElement(String nodeName) {
        return this.getCreateElement(nodeName, null, 0);
    }

    public VString getMultipleIDs(String JDFCoreConstants2) {
        VString vRet = new VString();
        this.getMultipleIDs(JDFCoreConstants2, vRet, new HashSet<String>());
        return vRet.isEmpty() ? null : vRet;
    }

    private void getMultipleIDs(String JDFCoreConstants2, VString vRet, Set<String> setID) {
        String id = this.getAttribute_KElement(JDFCoreConstants2, null, null);
        if (id != null) {
            if (setID.contains(id)) {
                vRet.appendUnique(id);
            } else {
                setID.add(id);
            }
        }
        for (KElement child = this.getFirstChildElement(); child != null; child = child.getNextSiblingElement()) {
            child.getMultipleIDs(JDFCoreConstants2, vRet, setID);
        }
    }

    public KElement getCreateElement(String nodeName, String nameSpaceURI, int iSkip) {
        KElement e = this.getElement(nodeName, nameSpaceURI, iSkip);
        return e == null ? this.appendElement(nodeName, nameSpaceURI) : e;
    }

    public KElement getCreateElement_KElement(String nodeName, String nameSpaceURI, int iSkip) {
        KElement kElem = this.getElement_KElement(nodeName, nameSpaceURI, iSkip);
        if (kElem == null) {
            kElem = this.appendElement(nodeName, nameSpaceURI);
        }
        return kElem;
    }

    public KElement getElement(String nodeName) {
        return this.getElement(nodeName, null, 0);
    }

    public KElement getElement(String nodeName, String nameSpaceURI, int iSkip) {
        return this.getElement_KElement(nodeName, nameSpaceURI, iSkip);
    }

    public HashMap<String, KElement> getElementHashMap(String elementName, String elementNS, String JDFCoreConstants2) {
        HashMap<String, KElement> m = new HashMap<String, KElement>();
        VElement v = this.getChildElementVector_KElement(elementName, elementNS, new JDFAttributeMap(JDFCoreConstants2, (String)null), true, 0);
        int siz = v.size();
        for (int i = 0; i < siz; ++i) {
            KElement e = v.elementAt(i);
            m.put(e.getAttribute(JDFCoreConstants2), e);
        }
        return m;
    }

    public KElement getElement_KElement(String nodeName, String nameSpaceURI, int iSkip) {
        KElement kElem = this.getFirstChildElement();
        int i = 0;
        if (iSkip < 0) {
            iSkip = this.numChildElements_KElement(nodeName, nameSpaceURI) + iSkip;
        }
        if (iSkip < 0) {
            return null;
        }
        while (kElem != null) {
            if (kElem.fitsName_KElement(nodeName, nameSpaceURI) && i++ == iSkip) {
                return kElem;
            }
            kElem = kElem.getNextSiblingElement();
        }
        return null;
    }

    public <a extends KElement> a getElementByClass(Class<a> clazz, int iSkip, boolean bRecurse) {
        Vector<a> v;
        if (iSkip < 0 && (v = this.getChildrenByClass(clazz, bRecurse, 0)) != null) {
            iSkip = v.size() + iSkip;
            return (a)(iSkip >= 0 ? (KElement)v.get(iSkip) : null);
        }
        int i = 0;
        for (KElement n = this.getFirstChildElement(); n != null; n = n.getNextSiblingElement()) {
            a ret;
            if (clazz.isInstance(n) && iSkip == i++) {
                return (a)n;
            }
            if (!bRecurse || (ret = n.getElementByClass(clazz, iSkip - i, bRecurse)) == null) continue;
            return ret;
        }
        return null;
    }

    public KElement getDeepParent(String parentNode, int depth) {
        KElement parentElement = this.getParentNode_KElement();
        if (!this.getLocalName().equals(parentNode) && !KElement.isWildCard(parentNode)) {
            return parentElement == null ? null : parentElement.getDeepParent(parentNode, depth);
        }
        if (depth > 0) {
            if (parentElement == null) {
                return this.getDeepParent(parentNode, 0);
            }
            if (KElement.isWildCard(parentNode) || parentNode.equals(parentElement.getLocalName())) {
                return parentElement.getDeepParent(parentNode, depth - 1);
            }
        }
        return this;
    }

    @Deprecated
    public KElement getDeepParent(Vector vParentElement, int depth) {
        KElement par;
        KElement kRet = this;
        if (!vParentElement.contains(this.getNodeName())) {
            kRet = this.getParentNode_KElement().getDeepParent(vParentElement, depth);
        } else if (depth > 0 && (par = this.getParentNode_KElement()) != null && vParentElement.contains(par.getNodeName())) {
            kRet = par.getDeepParent(vParentElement, depth - 1);
        }
        return kRet;
    }

    public KElement getDocRoot() {
        KElement kDocRoot = null;
        Element rootElem = this.getOwnerDocument().getDocumentElement();
        if (rootElem != null) {
            kDocRoot = (KElement)rootElem;
        }
        return kDocRoot;
    }

    public VString getAttributeVector() {
        return this.getAttributeVector_KElement();
    }

    public VString getAttributeVector_KElement() {
        VString v = new VString();
        NamedNodeMap nm = this.getAttributes();
        if (nm != null) {
            int siz = nm.getLength();
            for (int i = 0; i < siz; ++i) {
                Node a = nm.item(i);
                v.addElement(a.getNodeName());
            }
        }
        return v;
    }

    public KElement getTarget(String id, String attrib) {
        return this.getTarget_KElement(id, attrib);
    }

    public KElement getTarget_KElement(String id, String attrib) {
        KElement docRoot;
        if (id == null || id.equals("")) {
            return null;
        }
        if (StringUtil.getNonEmpty(attrib) == null) {
            attrib = "ID";
        }
        if ((docRoot = this.getDocRoot()).includesAttribute(attrib, id)) {
            return docRoot;
        }
        return docRoot.getChildWithAttribute(null, attrib, null, id, 0, false);
    }

    public VString getElementNameVector() {
        VElement vChildElem = this.getChildElementVector(null, null, null, true, 0, false);
        VString v = new VString();
        for (KElement e : vChildElem) {
            v.add(e.getNodeName());
        }
        v.unify();
        return v;
    }

    @Deprecated
    public static Element getFirstElementNode(Element parent) {
        Node firstChildElement;
        for (firstChildElement = parent.getFirstChild(); firstChildElement != null && firstChildElement.getNodeType() != 1; firstChildElement = firstChildElement.getNextSibling()) {
        }
        return (Element)firstChildElement;
    }

    @Deprecated
    public static Element getNextElementNode(Element elem) {
        Node nextSiblingElement;
        for (nextSiblingElement = elem.getNextSibling(); nextSiblingElement != null && nextSiblingElement.getNodeType() != 1; nextSiblingElement = nextSiblingElement.getNextSibling()) {
        }
        return (Element)nextSiblingElement;
    }

    public boolean isEqual(KElement kElem) {
        if (kElem == null) {
            return false;
        }
        if (this.equals(kElem)) {
            return true;
        }
        if (this.numChildNodes(0) != kElem.numChildNodes(0)) {
            return false;
        }
        if (this.numChildNodes(2) != kElem.numChildNodes(2)) {
            return false;
        }
        if (!this.getNodeName().equals(kElem.getNodeName())) {
            return false;
        }
        if (this.getNodeType() != kElem.getNodeType()) {
            return false;
        }
        NamedNodeMap atts = this.getAttributes();
        NamedNodeMap katts = kElem.getAttributes();
        int length = atts.getLength();
        if (length != katts.getLength()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Node node = atts.item(i);
            String key = node.getNodeName();
            Node kNode = katts.getNamedItem(key);
            if (kNode == null) {
                return false;
            }
            if (!key.equals(kNode.getNodeName())) {
                return false;
            }
            if (node.getNodeValue().equals(kNode.getNodeValue())) continue;
            return false;
        }
        if (!ContainerUtil.equals(this.getText(), kElem.getText())) {
            return false;
        }
        VElement l1 = this.getChildElementVector(null, null, null, true, 0, false);
        VElement l2 = kElem.getChildElementVector(null, null, null, true, 0, false);
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            KElement kNode2;
            KElement kNode1 = l1.elementAt(i);
            if (kNode1.isEqual(kNode2 = l2.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public VElement getChildNodes_KElement() {
        return new VElement(this.getChildNodes());
    }

    public boolean isAncestor(KElement child) {
        return this.ancestorDistance(child) >= 0;
    }

    public int ancestorDistance(KElement child) {
        if (child != null) {
            if (child == this) {
                return 0;
            }
            int ancestorDistance = this.ancestorDistance(child.getParentNode_KElement());
            return ancestorDistance < 0 ? ancestorDistance : 1 + ancestorDistance;
        }
        return -1;
    }

    public int numChildElements(String node, String nameSpaceURI) {
        return this.numChildElements_KElement(node, nameSpaceURI);
    }

    public int numChildrenByClass(Class<?> clazz, boolean bRecurse) {
        int i = 0;
        for (Node n = this.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (clazz.isInstance(n)) {
                ++i;
            }
            if (!bRecurse || !(n instanceof KElement)) continue;
            i += ((KElement)n).numChildrenByClass(clazz, true);
        }
        return i;
    }

    public int numChildElements_KElement(String node, String nameSpaceURI) {
        int n = 0;
        for (KElement kElem = this.getFirstChildElement(); kElem != null; kElem = kElem.getNextSiblingElement()) {
            if (!kElem.fitsName_KElement(node, nameSpaceURI)) continue;
            ++n;
        }
        return n;
    }

    public KElement removeChild(String node, String nameSpaceURI, int n) {
        KElement kRet = null;
        KElement kElem = this.getChildByTagName(node, nameSpaceURI, n, null, true, true);
        if (kElem != null) {
            kRet = (KElement)this.removeChild(kElem);
        }
        return kRet;
    }

    public KElement getChildByTagName(String s, String nameSpaceURI, int index, JDFAttributeMap mAttrib, boolean bDirect, boolean bAnd) {
        VElement v = this.getChildrenByTagName(s, nameSpaceURI, mAttrib, bDirect, bAnd, index + 1);
        if (index >= 0 && v.size() > index) {
            return v.item(index);
        }
        return null;
    }

    @Deprecated
    public void removeChildren(String nodeName, String nameSpaceURI) {
        this.removeChildren(nodeName, nameSpaceURI, null);
    }

    public void removeChildren(String nodeName, String nameSpaceURI, JDFAttributeMap mAttrib) {
        VElement v = this.getChildElementVector(nodeName, nameSpaceURI, mAttrib, true, 0, false);
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            this.removeChild(v.elementAt(i));
        }
    }

    public int removeFromAttribute(String key, String token, String nameSpaceURI, String sep, int nMax) {
        String strAttrValue = this.getAttribute_KElement(key, nameSpaceURI, null);
        if (strAttrValue == null || token == null) {
            return 0;
        }
        int n = 0;
        int posOfToken = StringUtil.posOfToken(strAttrValue, token, sep, 0);
        while (posOfToken >= 0) {
            strAttrValue = StringUtil.replaceToken(strAttrValue, posOfToken, sep, null);
            ++n;
            posOfToken = StringUtil.posOfToken(strAttrValue, token, sep, 0);
        }
        if (n > 0) {
            strAttrValue = strAttrValue.trim();
            this.setAttribute(key, StringUtil.getNonEmpty(strAttrValue), nameSpaceURI);
        }
        return n;
    }

    public boolean flush() {
        Node node = this.getFirstChild();
        while (node != null) {
            Node next = node.getNextSibling();
            this.removeChild(node);
            node = next;
        }
        this.removeAttributes(null);
        return true;
    }

    @Deprecated
    public Vector getChildNodeVector(int maxSize) {
        Vector<Node> v = new Vector<Node>();
        int i = 0;
        Node node = this.getFirstChild();
        if (node != null) {
            do {
                v.add(node);
                node = node.getNextSibling();
            } while (++i != maxSize && node != null);
        }
        return v;
    }

    public void removeAttributes(VString attribs) {
        block3: {
            block2: {
                if (attribs != null) break block2;
                NamedNodeMap nm = this.getAttributes();
                if (nm == null) break block3;
                int siz = nm.getLength();
                for (int i = siz - 1; i >= 0; --i) {
                    this.removeAttribute(nm.item(i).getNodeName());
                }
                break block3;
            }
            for (String attrib : attribs) {
                this.removeAttribute(attrib);
            }
        }
    }

    public void eraseEmptyAttributes(boolean bRecurse) {
        NamedNodeMap nm = this.getAttributes();
        if (nm != null) {
            int siz = nm.getLength();
            for (int i = siz - 1; i >= 0; --i) {
                Node item = nm.item(i);
                if (!item.getNodeValue().equals("")) continue;
                this.removeAttribute(item.getNodeName());
            }
        }
        if (bRecurse) {
            for (KElement e = this.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
                e.eraseEmptyAttributes(true);
            }
        }
    }

    @Deprecated
    public KElement getDeepElement(String nodeName, String nameSpaceURI, int iSkip) {
        return this.getChildByTagName(nodeName, nameSpaceURI, iSkip, null, false, true);
    }

    @Deprecated
    public KElement getChildFromList(VString nodeNames, int iSkip) {
        return this.getChildFromList(nodeNames, iSkip, null, true);
    }

    public KElement getChildFromList(VString nodeNames, int iSkip, JDFAttributeMap map, boolean bDirect) {
        int i = 0;
        for (KElement kElem = this.getFirstChildElement(); kElem != null; kElem = kElem.getNextSiblingElement()) {
            if (nodeNames.contains(kElem.getLocalName()) && (map == null || kElem.includesAttributes(map, true)) && i++ >= iSkip) {
                return kElem;
            }
            if (bDirect) continue;
            int j = 0;
            KElement e2 = null;
            do {
                if ((e2 = kElem.getChildFromList(nodeNames, j, map, bDirect)) == null) continue;
                if (i++ >= iSkip) {
                    return e2;
                }
                ++j;
            } while (e2 != null);
        }
        return null;
    }

    public KElement renameElement(String newName, String nameSpaceURI) {
        this.name = newName;
        this.localName = KElement.xmlnsLocalName(newName);
        if (nameSpaceURI != null) {
            this.namespaceURI = nameSpaceURI;
        }
        return this;
    }

    public void removeExtensions(String nsURI) {
        if (nsURI == null) {
            return;
        }
        KElement n = this.getFirstChildElement();
        while (n != null) {
            KElement next = n.getNextSiblingElement();
            String nsuri = n.getNamespaceURI();
            if (nsURI.equals(nsuri)) {
                this.removeChild(n);
            } else {
                n.removeExtensions(nsURI);
            }
            n = next;
        }
        NamedNodeMap nm = this.getAttributes();
        if (nm != null) {
            int siz = nm.getLength();
            for (int i = siz - 1; i >= 0; --i) {
                Node na = nm.item(i);
                String nsuri = na.getNamespaceURI();
                if (!nsURI.equals(nsuri)) continue;
                this.removeAttributeNode((Attr)na);
            }
        }
    }

    public KElement moveMe(KElement beforeChild) {
        KElement parent;
        KElement kElement = parent = beforeChild == null ? this.getParentNode_KElement() : beforeChild.getParentNode_KElement();
        if (beforeChild == this) {
            return this;
        }
        if (parent == null || this.getParentNode_KElement() == null) {
            return null;
        }
        return parent.moveElement(this, beforeChild);
    }

    public KElement moveElement(KElement src, KElement beforeChild) {
        KElement kRet = null;
        if (src != null) {
            KElement srcElement;
            if (src.isAncestor(this)) {
                return null;
            }
            Node parentNode = src.getParentNode();
            Node node = srcElement = parentNode == null ? src : parentNode.removeChild(src);
            if (beforeChild != null && beforeChild.getParentNode() != this) {
                throw new JDFException("KElement.moveElement beforeChild is not child of this");
            }
            if (src.getOwnerDocument() != this.getOwnerDocument()) {
                src.clearTargets();
                KElement dest = (KElement)this.getOwnerDocument().importNode(srcElement, true);
                dest.fixParent(this, dest);
                srcElement = dest;
            }
            kRet = beforeChild == null ? (KElement)this.appendChild(srcElement) : (KElement)this.insertBefore(srcElement, beforeChild);
        }
        return kRet;
    }

    protected void clearTargets() {
    }

    public void moveElements(VElement v, KElement beforeChild) {
        if (v == null) {
            return;
        }
        for (KElement e : v) {
            this.moveElement(e, beforeChild);
        }
    }

    public int eraseEmptyNodes(boolean bTrimWhite) {
        int nRemove = 0;
        Node n = this.getFirstChild();
        while (n != null) {
            Node nNext = n.getNextSibling();
            short nodeType = n.getNodeType();
            if (nodeType == 3) {
                String s = n.getNodeValue();
                if (bTrimWhite) {
                    s = s.trim();
                }
                if (s.equals("")) {
                    this.removeChild(n);
                    ++nRemove;
                } else if (bTrimWhite) {
                    n.setNodeValue(s);
                }
            } else if (nodeType == 1) {
                KElement kElem = (KElement)n;
                nRemove += kElem.eraseEmptyNodes(true);
            }
            n = nNext;
        }
        return nRemove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KElement copyElement(KElement src, KElement beforeChild) {
        if (src == null) {
            return null;
        }
        KElement kElement = this;
        synchronized (kElement) {
            return (KElement)this.copyNode(src, beforeChild);
        }
    }

    private Node copyNode(Node src, KElement beforeChild) {
        Node childNode = null;
        Document od = this.getOwnerDocument();
        if (src.getOwnerDocument() == od) {
            childNode = src.cloneNode(true);
        } else {
            if (od instanceof DocumentJDFImpl) {
                ((DocumentJDFImpl)((Object)od)).setParentNode(this);
            }
            childNode = od.importNode(src, true);
        }
        if (beforeChild != null && beforeChild.getParentNode() != this) {
            throw new JDFException("KElement.copyElement: beforeChild " + beforeChild + " is not child of this: " + this.toString());
        }
        return this.insertBefore(childNode, beforeChild);
    }

    public KElement copyInto(KElement src, boolean bRemove) {
        if (src == null || src == this) {
            return this;
        }
        if (bRemove) {
            this.removeChildren(null, null, null);
            this.removeAllText();
            this.removeAttributes(null);
        }
        this.setAttributes(src);
        this.setText(src.getText());
        String srcNS = StringUtil.getNonEmpty(src.getNamespaceURI());
        if (srcNS != null) {
            this.setNamespaceURI(srcNS);
        }
        for (Node e = src.getFirstChild(); e != null; e = e.getNextSibling()) {
            this.copyNode(e, null);
        }
        return this;
    }

    public KElement replaceElement(KElement src) {
        if (src == this) {
            return this;
        }
        KElement kRet = src;
        if (src != null) {
            if (this.getParentNode_KElement() == null) {
                kRet = this.replaceElement_isDocRoot(src);
            } else {
                KElement srcParentNode = src.getParentNode_KElement();
                if (srcParentNode != null) {
                    src = (KElement)srcParentNode.removeChild(src);
                }
                if (src.getOwnerDocument() == this.getOwnerDocument()) {
                    this.getParentNode_KElement().replaceChild(src, this);
                    this.fixParent(src, null);
                    kRet = src;
                } else {
                    KElement dn = (KElement)this.getOwnerDocument().importNode(src, true);
                    this.getParentNode_KElement().replaceChild(dn, this);
                    this.fixParent(dn, null);
                    kRet = dn;
                }
            }
        }
        this.ownerNode = null;
        return kRet;
    }

    private KElement replaceElement_isDocRoot(KElement src) {
        if (!ContainerUtil.equals(this.getNodeName(), src.getNodeName()) || !ContainerUtil.equals(this.getNamespaceURI(), src.getNamespaceURI())) {
            this.renameElement(src.getNodeName(), src.getNamespaceURI());
        }
        this.flush();
        this.setAttributes(src.getAttributeMap());
        VElement children = src.getChildElementVector(null, null, null, true, 0, false);
        for (int iv = 0; iv < children.size(); ++iv) {
            this.copyElement(children.elementAt(iv), null);
        }
        return this;
    }

    public long getLongAttribute(String attrib, String nameSpaceURI, long def) {
        String s = this.getAttribute(attrib, nameSpaceURI, null);
        return StringUtil.parseLong(s, def);
    }

    public int getIntAttribute(String attrib, String nameSpaceURI, int def) {
        String s = this.getAttribute(attrib, nameSpaceURI, null);
        return StringUtil.parseInt(s, def);
    }

    public boolean getBoolAttribute(String attrib, String nameSpaceURI, boolean def) {
        String s = this.getAttribute(attrib, nameSpaceURI, null);
        return StringUtil.parseBoolean(s, def);
    }

    public double getRealAttribute(String attrib, String nameSpaceURI, double def) {
        String s = this.getAttribute(attrib, nameSpaceURI, null);
        return StringUtil.parseDouble(s, def);
    }

    public KElement getDeepParentNotName(String thisNode) {
        KElement parent;
        KElement kRet = null;
        kRet = this.getLocalName().equals(thisNode) ? ((parent = this.getParentNode_KElement()) == null ? null : parent.getDeepParentNotName(thisNode)) : this;
        return kRet;
    }

    public KElement getDeepParentChild(String parentNode) {
        KElement kElem = this.getParentNode_KElement();
        if (kElem != null && parentNode != null) {
            if (!kElem.getNodeName().equals(parentNode)) {
                return kElem.getDeepParentChild(parentNode);
            }
            return this;
        }
        return null;
    }

    @Deprecated
    public void appendXMLComment(String commentText) {
        this.appendXMLComment(commentText, null);
    }

    public Node appendXMLComment(String commentText, KElement beforeChild) {
        commentText = StringUtil.replaceString(commentText, "--", "__");
        Comment newChild = this.getOwnerDocument().createComment(commentText);
        this.insertBefore(newChild, beforeChild);
        return newChild;
    }

    public void setXMLComment(String commentText) {
        if (commentText == null) {
            return;
        }
        KElement e = this.getParentNode_KElement();
        if (e == null) {
            commentText = StringUtil.replaceString(commentText, "--", "__");
            Comment newChild = this.getOwnerDocument().createComment(commentText);
            this.getOwnerDocument().insertBefore(newChild, this);
            Node last = newChild.getPreviousSibling();
            if (last != null && last.getNodeType() == 8) {
                this.getOwnerDocument().removeChild(last);
            }
        } else {
            Node last = this.getPreviousSibling();
            e.appendXMLComment(commentText, this);
            if (last != null && last.getNodeType() == 8) {
                e.removeChild(last);
            }
        }
    }

    public void appendCData(String cDataText) {
        CDATASection newChild = this.getOwnerDocument().createCDATASection(cDataText);
        this.appendChild(newChild);
    }

    public void appendCData(KElement cDataElem) {
        String s = cDataElem.toString();
        CDATASection newChild = this.getOwnerDocument().createCDATASection(s);
        this.appendChild(newChild);
    }

    public void appendText(String textName) {
        if (StringUtil.getNonEmpty(textName) == null) {
            return;
        }
        Text newChild = this.getOwnerDocument().createTextNode(textName);
        this.appendChild(newChild);
    }

    public void appendEntityReference(String refName) {
        EntityReference newChild = this.getOwnerDocument().createEntityReference(refName);
        this.appendChild(newChild);
    }

    public KElement appendTextElement(String nodeName, String text) {
        KElement kElem = this.appendElement(nodeName, null);
        kElem.appendText(text);
        return kElem;
    }

    public KElement mergeElement(KElement kElem, boolean bDelete) {
        if (kElem == null) {
            return this;
        }
        VElement v = kElem.getChildElementVector(null, null, null, true, 0, false);
        for (int i = 0; i < v.size(); ++i) {
            int nE;
            KElement m = v.elementAt(i);
            int nThis = this.numChildElements(m.getNodeName(), null);
            if (nThis == 1 && (nE = kElem.numChildElements(m.getNodeName(), null)) == 1) {
                this.getElement(m.getNodeName(), null, 0).mergeElement(m, bDelete);
                continue;
            }
            if (bDelete) {
                this.moveElement(m, null);
                continue;
            }
            this.copyElement(m, null);
        }
        this.setAttributes(kElem);
        return this;
    }

    public KElement getChildWithAttribute(String nodeName, String attName, String nameSpaceURI, String attVal, int index, boolean bDirect) {
        return this.getChildByTagName(nodeName, nameSpaceURI, index, new JDFAttributeMap(attName, attVal), bDirect, true);
    }

    public boolean hasChildElement(String nodeName, String nameSpaceURI) {
        return this.getElement(nodeName, nameSpaceURI, 0) != null;
    }

    public KElement getInheritedElement(String elementName, String nameSpaceURI, int iSkip) {
        KElement kElem = this.getElement(elementName, nameSpaceURI, iSkip);
        if (kElem == null && (kElem = this.getParentNode_KElement()) != null) {
            kElem = kElem.getInheritedElement(elementName, nameSpaceURI, iSkip);
        }
        return kElem;
    }

    public boolean addNameSpace(String strPrefix, String strNameSpaceURI) {
        boolean fSuccess = false;
        String strNameSpace = strPrefix == null || strPrefix.length() <= 0 ? "xmlns" : "xmlns:" + strPrefix;
        String strOldNameSpaceURI = this.getInheritedAttribute(strNameSpace, null, "");
        String myNameSpaceURI = this.getNamespaceURI();
        if (!strNameSpaceURI.equals(strOldNameSpaceURI) && !strNameSpaceURI.equals(myNameSpaceURI)) {
            fSuccess = true;
            this.setAttribute(strNameSpace, strNameSpaceURI, null);
        }
        DocumentXMLImpl doc = (DocumentXMLImpl)((Object)this.getOwnerDocument());
        doc.setNamespaceURIFromPrefix(strPrefix, strNameSpaceURI);
        return fSuccess;
    }

    public void sortChildren() {
        this.sortChildren(new SimpleNodeComparator());
    }

    public void sortChild(KElement e) {
        this.sortChild(e, new SimpleNodeComparator());
    }

    public synchronized void sortChildren(Comparator<KElement> comparator) {
        VElement v = this.getChildElementVector_KElement(null, null, null, true, -1);
        Collections.sort(v, comparator);
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            KElement e = v.get(i);
            this.moveElement(e, null);
        }
    }

    public synchronized void sortChild(KElement e, Comparator<KElement> comparator) {
        if (e == null) {
            return;
        }
        if (e.getParentNode_KElement() == this) {
            boolean bSorted;
            KElement prev = e.getPreviousSiblingElement();
            boolean bl = bSorted = prev == null || comparator.compare(prev, e) <= 0;
            if (bSorted) {
                KElement next = e.getNextSiblingElement();
                boolean bl2 = bSorted = next == null || comparator.compare(next, e) >= 0;
            }
            if (!bSorted) {
                e.deleteNode();
            } else {
                return;
            }
        }
        VElement v = this.getChildElementVector_KElement(null, null, null, true, -1);
        KElement before = null;
        if (v != null && v.size() > 0) {
            int posBefore = v.size();
            int posAfter = 0;
            int lastPos = -1;
            while (posBefore != posAfter) {
                int pos = (posBefore + posAfter) / 2;
                before = v.get(pos);
                int d = comparator.compare(before, e);
                if (d >= 0) {
                    posBefore = lastPos != pos ? pos : pos - 1;
                } else {
                    posAfter = lastPos != pos ? pos : pos + 1;
                }
                lastPos = pos;
            }
            before = v.get(posBefore);
        }
        this.insertBefore(e, before);
    }

    public String toString() {
        return this.toXML();
    }

    public String toXML() {
        return this.toXML(2);
    }

    public String toXML(int indent) {
        try {
            StringWriter osw = new StringWriter();
            OutputFormat format = new OutputFormat(this.getOwnerDocument());
            format.setIndenting(indent != 0);
            format.setIndent(indent);
            format.setEncoding("UTF-8");
            XMLSerializer serial = new XMLSerializer((Writer)osw, format);
            serial.setNamespaces(true);
            serial.asDOMSerializer();
            serial.serialize((Element)this);
            String s = osw.toString();
            return s;
        }
        catch (IOException e) {
            throw new JDFException("IOException while serializing " + this.getClass().getName() + " element " + e.getMessage());
        }
    }

    public String toDisplayXML(int indent) {
        String s = this.toXML(indent);
        int pos = s.indexOf("?>");
        if (pos > 0) {
            pos = s.indexOf("<", pos);
        }
        return pos > 0 ? s.substring(pos) : s;
    }

    public void renameAttribute(String oldName, String newName, String nameSpaceURI, String newNameSpaceURI) {
        if (this.hasAttribute(oldName, nameSpaceURI, false)) {
            String strAttValue = this.getAttribute_KElement(oldName, nameSpaceURI, null);
            this.setAttribute(newName, strAttValue, newNameSpaceURI);
            this.removeAttribute(oldName, nameSpaceURI);
        }
    }

    public VString getChildAttributeList(String nodeName, String attName, String nameSpaceURI, String attValue, boolean bDirect, boolean bUnique) {
        VString v = new VString();
        VElement vChildren = this.getChildrenByTagName(nodeName, nameSpaceURI, new JDFAttributeMap(attName, ""), bDirect, true, 0);
        boolean bAttWildCard = KElement.isWildCard(attValue);
        for (int i = 0; i < vChildren.size(); ++i) {
            boolean bAddElement = true;
            KElement kElem = vChildren.elementAt(i);
            String s = kElem.getAttribute_KElement(attName, nameSpaceURI, "");
            if (!bAttWildCard && !s.equals(attValue)) continue;
            if (bUnique && v.contains(s)) {
                bAddElement = false;
            }
            if (!bAddElement) continue;
            v.addElement(s);
        }
        return v;
    }

    public KElement insertBefore(String elementName, Node beforeChild, String nameSpaceURI) {
        KElement newChild = this.createChildFromName(elementName, nameSpaceURI);
        if (newChild != null) {
            this.insertBefore(newChild, beforeChild);
        }
        return newChild;
    }

    public VElement getChildrenFromList(VString nodeNames, JDFAttributeMap map, boolean bDirect, VElement v) {
        if (v == null) {
            v = new VElement();
        }
        for (KElement kElem = this.getFirstChildElement(); kElem != null; kElem = kElem.getNextSiblingElement()) {
            if ((nodeNames.contains(kElem.getLocalName()) || nodeNames.contains(kElem.getNodeName())) && (map == null || kElem.includesAttributes(map, true))) {
                v.addElement(kElem);
            }
            if (bDirect) continue;
            kElem.getChildrenFromList(nodeNames, map, bDirect, v);
        }
        return v;
    }

    public VElement getChildrenIgnoreList(VString nodeNames, boolean bDirect, VElement v) {
        KElement kElem = this.getFirstChildElement();
        if (v == null) {
            v = new VElement();
        }
        while (kElem != null) {
            if (!nodeNames.contains(kElem.getLocalName()) && !nodeNames.contains(kElem.getNodeName())) {
                v.addElement(kElem);
            }
            if (!bDirect) {
                kElem.getChildrenIgnoreList(nodeNames, bDirect, v);
            }
            kElem = kElem.getNextSiblingElement();
        }
        return v;
    }

    public KElement appendElementN(String elementName, int maxAllowed, String nameSpaceURI) {
        if (this.numChildElements_KElement(elementName, nameSpaceURI) >= maxAllowed) {
            throw new JDFException("KElement:appendElementN: too many elements (>" + maxAllowed + ") of type" + nameSpaceURI + ":" + elementName);
        }
        return this.appendElement(elementName, nameSpaceURI);
    }

    @Deprecated
    public String buildXPath() {
        return this.buildXPath(null, 1);
    }

    @Deprecated
    public String buildXPath(String relativeTo) {
        return this.buildXPath(relativeTo, 1);
    }

    public String buildXPath(String relativeTo, int methCountSiblings) {
        return new XPathHelper(this).buildXPath(relativeTo, methCountSiblings);
    }

    public KElement insertAt(String nodeName, int beforePos, String beforeNode, String nameSpaceURI, String beforeNameSpaceURI) {
        KElement kRet = null;
        String strBeforeNS = beforeNameSpaceURI == null || beforeNameSpaceURI.equals("") ? nameSpaceURI : beforeNameSpaceURI;
        KElement kElem = this.getElement_KElement(beforeNode, strBeforeNS, beforePos);
        kRet = kElem == null ? this.appendElement(nodeName, nameSpaceURI) : this.insertBefore(nodeName, kElem, nameSpaceURI);
        return kRet;
    }

    public void setXPathValue(String path, String value) {
        new XPathHelper(this).setXPathValue(path, value);
    }

    public void setXPathValues(JDFAttributeMap map) {
        new XPathHelper(this).setXPathValues(map);
    }

    public void setXPathAttribute(String path, String value) {
        new XPathHelper(this).setXPathAttribute(path, value);
    }

    public boolean hasXPathNode(String path) {
        return new XPathHelper(this).hasXPathNode(path);
    }

    public String getXPathAttribute(String path, String def) {
        return new XPathHelper(this).getXPathAttribute(path, def);
    }

    public String getInheritedXPathAttribute(String path, String def) {
        return new XPathHelper(this).getInheritedXPathAttribute(path, def);
    }

    public JDFAttributeMap getXPathAttributeMap(String path) {
        return new XPathHelper(this).getXPathAttributeMap(path, false);
    }

    public JDFAttributeMap getXPathValueMap() {
        return new XPathHelper(this).getXPathAttributeMap(null, true);
    }

    public KElement getXPathElement(String path) {
        return new XPathHelper(this).getXPathElement(path);
    }

    public VElement getXPathElementVector(String path, int maxSize) {
        return new XPathHelper(this).getXPathElementVectorInternal(path, maxSize, true);
    }

    public KElement getCreateXPathElement(String path) {
        return new XPathHelper(this).getCreateXPathElement(path);
    }

    @Override
    public boolean hasAttributes() {
        NamedNodeMap nm = this.getAttributes();
        int l = nm == null ? 0 : nm.getLength();
        return l != 0;
    }

    protected boolean hasChildNodes(int nodeType) {
        boolean bRet = false;
        Node node = this.getFirstChild();
        while (node != null && !bRet) {
            if (node.getNodeType() == nodeType) {
                bRet = true;
                continue;
            }
            node = node.getNextSibling();
        }
        return bRet;
    }

    public boolean hasChildElements() {
        return this.hasChildNodes(1);
    }

    public VElement getTree(String nodeName, String nameSpaceURI, JDFAttributeMap mAttrib, boolean bDirect, boolean bAnd) {
        boolean bAlwaysFit;
        VElement v = new VElement();
        boolean bHasNoMap = mAttrib == null || mAttrib.isEmpty();
        boolean bl = bAlwaysFit = KElement.isWildCard(nodeName) && KElement.isWildCard(nameSpaceURI);
        for (KElement e = this.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!bAlwaysFit && !e.fitsName_KElement(nodeName, nameSpaceURI)) continue;
            if (bHasNoMap || e.includesAttributes(mAttrib, bAnd)) {
                v.add(e);
            }
            if (bDirect) continue;
            VElement vv = e.getTree(nodeName, nameSpaceURI, mAttrib, bDirect, bAnd);
            v.addAll(vv);
        }
        return v;
    }

    public KElement getTreeElement(String nodeName, String nameSpaceURI, JDFAttributeMap mAttrib, boolean bDirect, boolean bAnd) {
        boolean bAlwaysFit;
        if (!bDirect && (mAttrib == null || this.includesAttributes(mAttrib, bAnd))) {
            return this;
        }
        boolean bl = bAlwaysFit = KElement.isWildCard(nodeName) && KElement.isWildCard(nameSpaceURI);
        for (KElement e = this.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            KElement ee;
            if (!bAlwaysFit && !e.fitsName_KElement(nodeName, nameSpaceURI)) continue;
            if (bDirect && (mAttrib == null || e.includesAttributes(mAttrib, bAnd))) {
                return e;
            }
            if (bDirect || (ee = e.getTreeElement(nodeName, nameSpaceURI, mAttrib, bDirect, bAnd)) == null) continue;
            return ee;
        }
        return null;
    }

    public String getText(int i) {
        Node n = this.getChildNode(3, i);
        return n == null ? null : n.getNodeValue();
    }

    public String getCData(int i) {
        Node n = this.getChildNode(4, i);
        return n == null ? null : n.getNodeValue();
    }

    public String getXMLComment(int i) {
        Node n = this.getChildNode(8, i);
        return n == null ? null : n.getNodeValue();
    }

    public String copyXPathValue(String dstXPath, KElement src, String srcXPath) {
        return new XPathHelper(this).copyXPathValue(dstXPath, src, srcXPath);
    }

    public void copyAttribute(String attrib, KElement src, String srcAttrib, String nameSpaceURI, String srcNameSpaceURI) {
        String pre;
        Attr an;
        String strNameSpace;
        String strSrcAttrib = srcAttrib == null || srcAttrib.equals("") ? attrib : srcAttrib;
        String string = strNameSpace = srcNameSpaceURI == null || srcNameSpaceURI.equals("") ? nameSpaceURI : srcNameSpaceURI;
        if (strNameSpace != null && KElement.xmlnsPrefix(attrib) == null && (an = src.getDOMAttr(strSrcAttrib, srcNameSpaceURI, false)) != null && !KElement.isWildCard(pre = an.getPrefix())) {
            attrib = pre + ":" + attrib;
        }
        this.setAttribute(attrib, src.getAttribute_KElement(strSrcAttrib, srcNameSpaceURI, null), strNameSpace);
    }

    public void copyAttribute(String attrib, KElement src) {
        this.copyAttribute(attrib, src, null, null, null);
    }

    public void moveAttribute(String attrib, KElement src, String srcAttrib, String nameSpaceURI, String srcNameSpaceURI) {
        String attribute;
        Attr attr;
        boolean b;
        String strNameSpace;
        if (src == null) {
            src = this;
        }
        String strSrcAttrib = srcAttrib == null || srcAttrib.equals("") ? attrib : srcAttrib;
        String string = strNameSpace = srcNameSpaceURI == null || srcNameSpaceURI.equals("") ? nameSpaceURI : srcNameSpaceURI;
        if (KElement.xmlnsPrefix(attrib) != null && nameSpaceURI == null && (b = src.hasAttribute(strSrcAttrib, strNameSpace, false)) && (attr = src.getDOMAttr(strSrcAttrib, strNameSpace, true)) != null) {
            nameSpaceURI = attr.getNamespaceURI();
        }
        if ((attribute = src.getAttribute(strSrcAttrib, strNameSpace, null)) != null) {
            src.removeAttribute(strSrcAttrib, strNameSpace);
        }
        this.setAttribute(attrib, attribute);
    }

    public void moveAttribute(String attrib, KElement src) {
        this.moveAttribute(attrib, src, null, null, null);
    }

    public boolean hasChildText() {
        return this.hasChildNodes(3);
    }

    public String getText() {
        int iBufferSize = 100;
        StringBuffer strBuff = new StringBuffer(100);
        NodeList nodeList = this.getChildNodes();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            strBuff.append(node.getNodeValue());
        }
        return strBuff.length() <= 0 ? null : strBuff.toString();
    }

    public void removeAllText() {
        NodeList allNodes = this.getChildNodes();
        for (int i = 0; i < allNodes.getLength(); ++i) {
            Node node = allNodes.item(i);
            if (node.getNodeType() != 3) continue;
            this.removeChild(node);
        }
    }

    public KElement pushUp(String newParentName) {
        KElement kEle = null;
        Node parent = this.getParentNode();
        if (parent != null) {
            while ((parent = parent.getParentNode()) != null && newParentName != null && !newParentName.equals("") && !parent.getNodeName().equals(newParentName)) {
            }
            if (parent != null) {
                kEle = ((KElement)parent).moveElement(this, null);
            }
        }
        return kEle;
    }

    public int numChildNodes(int nodeType) {
        int i = 0;
        for (Node n = this.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (nodeType != 0 && n.getNodeType() != nodeType) continue;
            ++i;
        }
        return i;
    }

    public boolean removeChildNode(int nodeType, int i) {
        boolean bRemoved = false;
        Node n = this.getChildNode(nodeType, i);
        if (n != null) {
            this.removeChild(n);
            bRemoved = true;
        }
        return bRemoved;
    }

    public void removeChildText(int i) {
        this.removeChildNode(3, i);
    }

    public void removeCData(int i) {
        this.removeChildNode(4, i);
    }

    public void removeXMLComment(int i) {
        this.removeChildNode(8, i);
    }

    public int getNumChildNodes(int nodeType) {
        int n = 0;
        NodeList nodeList = this.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != nodeType) continue;
            ++n;
        }
        return n;
    }

    public int getNumChildText() {
        return this.getNumChildNodes(3);
    }

    public int getNumCDatas() {
        return this.getNumChildNodes(4);
    }

    public int getNumXMLComments() {
        return this.getNumChildNodes(8);
    }

    protected Node getChildNode(int nodeType, int iPos) {
        Node retNode = null;
        int i = 0;
        for (Node node = this.getFirstChild(); node != null && i != iPos + 1; node = node.getNextSibling()) {
            if (node.getNodeType() != nodeType || i++ != iPos) continue;
            retNode = node;
        }
        return retNode;
    }

    @Deprecated
    public static String xmlNameSpace(String s) {
        return KElement.xmlnsPrefix(s);
    }

    @Deprecated
    public void setAttributes(String[] myAttributes, String[] strValues) {
        if (myAttributes.length != strValues.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        JDFAttributeMap attributeValueMap = new JDFAttributeMap();
        for (int nPara = 0; nPara < myAttributes.length; ++nPara) {
            attributeValueMap.put(myAttributes[nPara], strValues[nPara]);
        }
        this.setAttributes(attributeValueMap);
    }

    public static String xmlnsLocalName(String pc) {
        if (pc != null) {
            int posColon = pc.indexOf(58);
            if (posColon == -1) {
                return pc;
            }
            if (posColon == pc.length() - 1) {
                return null;
            }
            return pc.substring(posColon + 1);
        }
        return null;
    }

    @Deprecated
    public static String getXMLNSNameSpace(String pc) {
        return KElement.xmlnsPrefix(pc);
    }

    public void setXSIType(String typ) {
        this.setAttribute("xsi:type", typ, "http://www.w3.org/2001/XMLSchema-instance");
    }

    public String getXSIType() {
        return this.getAttribute("type", "http://www.w3.org/2001/XMLSchema-instance", null);
    }

    @Deprecated
    public static String getXMLNSPrefix(String pc) {
        return KElement.xmlnsPrefix(pc);
    }

    private void fixParent(KElement parentSrc, KElement flagSrc) {
        this.ownerNode = parentSrc.ownerNode;
        this.flags = flagSrc == null ? parentSrc.flags : flagSrc.flags;
    }

    public void setText(String text) {
        this.removeAllText();
        this.appendText(text);
    }

    @Override
    public void removeAttribute(String attrib) throws DOMException {
        this.removeAttribute_KElement(attrib, null);
    }

    @Override
    public void removeAttributeNS(String nameSpaceURI, String attrib) throws DOMException {
        this.removeAttribute_KElement(attrib, nameSpaceURI);
    }

    @Override
    public Attr removeAttributeNode(Attr arg0) throws DOMException {
        this.setDirty(true);
        return super.removeAttributeNode(arg0);
    }

    @Override
    public Attr setAttributeNode(Attr arg0) throws DOMException {
        this.setDirty(true);
        return super.setAttributeNode(arg0);
    }

    @Override
    public Attr setAttributeNodeNS(Attr arg0) throws DOMException {
        this.setDirty(true);
        return super.setAttributeNodeNS(arg0);
    }

    @Override
    public void setAttributeNS(String nsURI, String arg1, String arg2) throws DOMException {
        this.setDirty(true);
        this.setAttribute(arg1, arg2, nsURI);
    }

    @Override
    public void normalize() {
        this.setDirty(false);
        super.normalize();
    }

    @Override
    public void setNodeValue(String arg0) throws DOMException {
        this.setDirty(false);
        super.setNodeValue(arg0);
    }

    @Override
    public void setPrefix(String arg0) throws DOMException {
        super.setPrefix(arg0);
        this.setDirty(false);
    }

    public void setNamespaceURI(String arg0) throws DOMException {
        this.namespaceURI = arg0;
        this.setDirty(false);
    }

    @Override
    public Node appendChild(Node arg0) throws DOMException {
        return this.insertBefore(arg0, null);
    }

    @Override
    public synchronized Node removeChild(Node arg0) throws DOMException {
        this.setDirty(false);
        return super.removeChild(arg0);
    }

    @Override
    public synchronized Node insertBefore(Node arg0, Node arg1) throws DOMException {
        this.setDirty(false);
        return super.insertBefore(arg0, arg1);
    }

    @Override
    public synchronized Node replaceChild(Node arg0, Node arg1) throws DOMException {
        this.setDirty(false);
        return super.replaceChild(arg0, arg1);
    }

    KElement cloneRoot(XMLDoc d) {
        KElement e = (KElement)d.importNode(this, true);
        e.flags = (short)(e.flags | 8);
        return e;
    }

    public void removeXPathAttribute(String path) {
        new XPathHelper(this).removeXPathAttribute(path);
    }

    public void removeXPathElement(String path) {
        new XPathHelper(this).removeXPathElement(path);
    }

    @Deprecated
    public boolean matchesPath(String path) {
        return this.matchesPath(path, false);
    }

    public boolean matchesPath(String path, boolean bFollowRefs) {
        if (path == null) {
            return true;
        }
        if (bFollowRefs) {
            this.getClass();
        }
        VString v = StringUtil.tokenize(path, "/", false);
        KElement e = this;
        for (int i = v.size() - 1; i >= 0; --i) {
            if (e == null) {
                return false;
            }
            String pathAt = v.stringAt(i);
            if (!e.matchesPathName(pathAt)) {
                return false;
            }
            e = e.getParentNode_KElement();
        }
        if (path.startsWith("/") && !path.startsWith("//")) {
            return e == null;
        }
        return true;
    }

    protected boolean matchesPathName(String pathAt) {
        String startPath;
        if (pathAt == null || pathAt.equals("*")) {
            return true;
        }
        if (this.localName.equals(pathAt)) {
            return true;
        }
        String nodeName = this.getNodeName();
        if (nodeName.equals(pathAt)) {
            return true;
        }
        String string = pathAt.startsWith(this.localName) ? this.localName : (startPath = pathAt.startsWith(nodeName) ? nodeName : null);
        if (startPath != null) {
            String token = StringUtil.token(pathAt, 1, "[");
            if (token == null || !token.endsWith("]")) {
                return false;
            }
            int n = StringUtil.parseInt(token = StringUtil.leftStr(token, -1), 0);
            if (n != 0) {
                KElement p = this.getParentNode_KElement();
                if (p == null) {
                    return n == 1;
                }
                return p.getElement(this.localName, this.getNamespaceURI(), n - 1) == this;
            }
            if (token.startsWith("@")) {
                token = token.substring(1);
                String nam = StringUtil.token(token, 0, "=");
                String value = StringUtil.token(token, 1, "=");
                if (value == null) {
                    return false;
                }
                if (value.length() < 2 || !value.startsWith("\"") || !value.endsWith("\"")) {
                    return false;
                }
                return (value = value.substring(1, value.length() - 1)).equals("*") && this.hasAttribute_KElement(nam, null, false) || value.equals(this.getAttribute_KElement(nam));
            }
        }
        return false;
    }

    public final HashSet<String> fillHashSet(String attName, String attNS) {
        HashSet<String> preFill = new HashSet<String>();
        this.fillHashSet(attName, attNS, preFill, true);
        return preFill;
    }

    private void fillHashSet(String attName, String attNS, HashSet<String> preFill, boolean bFirst) {
        int i;
        String attVal;
        Attr attr = attNS == null ? super.getAttributeNodeNS(attNS, attName) : super.getAttributeNode(attName);
        String string = attVal = attr == null ? null : attr.getValue();
        if (attVal != null) {
            if (preFill.contains(attVal)) {
                if ("ID".equals(attName)) {
                    return;
                }
            } else {
                preFill.add(attVal);
            }
        }
        VElement v = this.getChildElementVector_KElement(null, null, null, true, 0);
        int siz = v.size();
        for (i = 0; i < siz; ++i) {
            v.item(i).fillHashSet(attName, attNS, preFill, false);
        }
        if (bFirst) {
            v = this.getChildElementVector(null, null, null, true, 0, false);
            siz = v.size();
            for (i = 0; i < siz; ++i) {
                v.item(i).fillHashSet(attName, attNS, preFill, true);
            }
        }
    }

    public KElement clone() {
        KElement e = this.createChildFromName(this.getNodeName(), this.getNamespaceURI());
        e.copyInto(this, false);
        return e;
    }

    public KElement cloneNewDoc() {
        XMLDoc d = new XMLDoc(this.getNodeName(), this.getNamespaceURI());
        d.copyMeta(this.getOwnerDocument_KElement());
        KElement e = d.getRoot();
        e.copyInto(this, false);
        return e;
    }

    public String appendAnchor(String newID) {
        String id = StringUtil.getNonEmpty(this.getAttribute("ID", null, null));
        if (id != null) {
            return id;
        }
        if (newID == null || newID.equals("")) {
            newID = "id_" + KElement.uniqueID(0);
        }
        this.setAttribute("ID", newID, null);
        return newID;
    }

    public String getID() {
        return this.getAttribute("ID", null, "");
    }

    public String generateDotID(String key, String nameSpaceURI) {
        String nodeName = this.getLocalName();
        KElement p = this.getParentNode_KElement();
        String idPrefix = this.getIDPrefix();
        if (p == null) {
            return idPrefix + KElement.uniqueID(0);
        }
        String parentID = p.getAttribute(key, nameSpaceURI, null);
        if (parentID == null) {
            return idPrefix + KElement.uniqueID(0);
        }
        VElement vn = p.getChildElementVector_KElement(nodeName, nameSpaceURI, null, true, 0);
        int siz = vn.size();
        parentID = parentID + ".";
        for (int i = siz; i < 2 * siz + 2; ++i) {
            String nn = parentID + i;
            boolean bFound = false;
            for (int j = 0; j < siz; ++j) {
                if (!nn.equals(vn.elementAt(j).getAttribute(key, nameSpaceURI, null))) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            return nn;
        }
        return idPrefix + KElement.uniqueID(0);
    }

    protected String getIDPrefix() {
        return "l";
    }

    public void setID(String id) {
        this.setAttribute("ID", id, null);
    }

    public static void setLongID(boolean bLong) {
        bIDDate = bLong;
    }

    public static synchronized String uniqueID(int id) {
        if (id != 0) {
            if (id < 0) {
                id = m_lStoreID - id;
            }
            m_lStoreID = id % 1000000;
        }
        String s = "00000" + Integer.toString(m_lStoreID);
        ++m_lStoreID;
        m_lStoreID %= 1000000;
        if (bIDDate) {
            String date = dateFormatter.format(new Date());
            return "_" + date + "_" + s.substring(s.length() - 6);
        }
        return "_" + s.substring(s.length() - 6);
    }

    public static KElement createRoot(String nodename, String namespaceURI) {
        return new XMLDoc(nodename, namespaceURI).getRoot();
    }

    public int numSiblingElements(String elementName, String nameSpaceURI) {
        KElement parent = this.getParentNode_KElement();
        if (parent == null) {
            return 0;
        }
        VElement ve = parent.getChildElementVector(elementName, nameSpaceURI);
        if (ve == null) {
            return 0;
        }
        int n = ve.size();
        if (ve.contains(this)) {
            --n;
        }
        return n;
    }

    public boolean write2Stream(OutputStream stream) {
        if (stream == null) {
            return false;
        }
        try {
            stream.write(this.toXML().getBytes("UTF-8"));
            stream.close();
            return true;
        }
        catch (IOException e) {
            kLog.error((Object)("cannot write " + this.getLocalName()));
            return false;
        }
    }

    public boolean write2File(File file) {
        BufferedOutputStream stream = FileUtil.getBufferedOutputStream(file);
        return this.write2Stream(stream);
    }

    public boolean write2File(String filename) {
        return this.write2File(UrlUtil.urlToFile(filename));
    }

    public static class SingleAttributeComparator
    extends SingleXPathComparator {
        public SingleAttributeComparator(String pAttName, boolean pInvert) {
            super("@" + pAttName, pInvert);
        }
    }

    public static class SingleXPathComparator
    implements Comparator<KElement> {
        final String xPath;
        final int invert;

        public SingleXPathComparator(String xPath, boolean pInvert) {
            this.xPath = xPath;
            this.invert = pInvert ? -1 : 1;
        }

        @Override
        public int compare(KElement o1, KElement o2) {
            String attribute1 = o1.getXPathAttribute(this.xPath, null);
            String attribute2 = o2.getXPathAttribute(this.xPath, null);
            if (StringUtil.isNumber(attribute1) && StringUtil.isNumber(attribute2)) {
                double d2;
                double d1 = StringUtil.parseDouble(attribute1, 0.0);
                if (d1 < (d2 = StringUtil.parseDouble(attribute2, 0.0))) {
                    return -this.invert;
                }
                if (d1 == d2) {
                    return 0;
                }
                return this.invert;
            }
            return this.invert * ContainerUtil.compare((Comparable)((Object)attribute1), (Comparable)((Object)attribute2));
        }
    }

    public static class SimpleNodeComparator
    implements Comparator<KElement> {
        @Override
        public int compare(KElement o1, KElement o2) {
            String nodeName2;
            String nodeName = o1.getNodeName();
            int i = nodeName.compareTo(nodeName2 = o2.getNodeName());
            if (i != 0) {
                return i;
            }
            i = (nodeName = nodeName + o1.getAttribute("ID")).compareTo(nodeName2 = nodeName2 + o2.getAttribute("ID"));
            if (i != 0) {
                return i;
            }
            nodeName = nodeName + o1.getAttributeMap();
            nodeName2 = nodeName2 + o2.getAttributeMap();
            return nodeName.compareTo(nodeName2);
        }
    }
}

