/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFBaseDataTypes;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.util.StringUtil;

public abstract class JDFNumList
extends Vector<Object>
implements JDFBaseDataTypes,
Cloneable {
    private static final long serialVersionUID = 1L;

    public JDFNumList() {
    }

    public JDFNumList(int size) {
        super(size);
        for (int i = 0; i < size; ++i) {
            this.addElement(0.0);
        }
    }

    @Deprecated
    public JDFNumList(Vector v) throws DataFormatException {
        this.addAll(v);
        this.isValid();
    }

    public JDFNumList(String sl) throws DataFormatException {
        this.setString(sl);
    }

    @Override
    public void set(int pos, double d) {
        super.set(pos, d);
    }

    public void setString(String string) throws DataFormatException {
        this.clear();
        if (string != null && string.length() > 0) {
            VString v = StringUtil.tokenize(string, null, false);
            if (v != null) {
                int size = v.size();
                boolean bInteger = this instanceof JDFIntegerList;
                int minValue = -2147483606;
                for (int i = 0; i < size; ++i) {
                    String s = v.stringAt(i);
                    if (bInteger) {
                        int theInt = StringUtil.parseInt(s, minValue);
                        if (theInt == minValue) {
                            throw new DataFormatException("JDFNumList: bad numeric value: " + s);
                        }
                        this.addElement(theInt);
                        continue;
                    }
                    double theDouble = StringUtil.parseDouble(s, Double.NaN);
                    if (Double.isNaN(theDouble)) {
                        throw new DataFormatException("JDFNumList: bad numeric value: " + s);
                    }
                    this.addElement(theDouble);
                }
            }
        } else {
            throw new DataFormatException("JDFNumList: bad string value: " + string);
        }
        this.isValid();
    }

    public JDFNumList(JDFNumList nl) throws DataFormatException {
        this.addAll(nl);
        this.isValid();
    }

    @Deprecated
    public String getString() {
        return this.toString();
    }

    public double[] getDoubleList() {
        double[] list = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            list[i] = this.doubleAt(i);
        }
        return list;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            Object o;
            if (i > 0) {
                sb.append(" ");
            }
            if ((o = this.elementAt(i)) instanceof Double) {
                sb.append(StringUtil.formatDouble((Double)o));
                continue;
            }
            if (o instanceof Integer) {
                sb.append(StringUtil.formatInteger((Integer)o));
                continue;
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    public String getString(int precision) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            Object o;
            if (i > 0) {
                sb.append(" ");
            }
            if ((o = this.elementAt(i)) instanceof Double) {
                sb.append(StringUtil.formatDouble((Double)o, precision));
                continue;
            }
            if (o instanceof Integer) {
                sb.append(StringUtil.formatInteger((Integer)o));
                continue;
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        boolean retVal = false;
        JDFNumList jdfNumList = (JDFNumList)other;
        int size = this.size();
        if (size == jdfNumList.size()) {
            retVal = true;
            for (int i = 0; i < size && retVal; ++i) {
                double d1 = this.doubleAt(i);
                double d2 = jdfNumList.doubleAt(i);
                retVal = StringUtil.isEqual(d1, d2);
            }
        }
        return retVal;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Object elementAt(int i) {
        if (i < 0) {
            i = this.size() + i;
        }
        if (i < 0 || i >= this.size()) {
            return null;
        }
        return super.elementAt(i);
    }

    public double doubleAt(int i) {
        Object o = this.elementAt(i);
        if (o instanceof Integer) {
            return ((Integer)o).doubleValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        return 0.0;
    }

    @Deprecated
    public Vector<Object> copyNumList() {
        return this.clone();
    }

    @Override
    public void removeElementAt(int i) {
        if (i < 0) {
            i += this.size();
        }
        if (i < this.size() && i >= 0) {
            super.removeElementAt(i);
        }
    }

    public boolean replaceElementAt(Object obj, int i) {
        if (i < 0) {
            i += this.size();
        }
        if (i < this.size() && i >= 0) {
            this.set(i, obj);
            return true;
        }
        return false;
    }

    public abstract boolean isValid() throws DataFormatException;

    public boolean isValidString(String st) {
        VString v = StringUtil.tokenize(st, null, false);
        if (v != null) {
            int size = v.size();
            for (int i = 0; i < size; ++i) {
                String s = v.stringAt(i);
                if (StringUtil.isNumber(s)) continue;
                return false;
            }
        }
        return true;
    }

    public JDFNumList scaleFromMM() {
        return this.scale(2.834645669291339);
    }

    public JDFNumList scaleFromCM() {
        return this.scale(28.346456692913385);
    }

    public JDFNumList scaleToMM() {
        return this.scale(0.35277777777777775);
    }

    public JDFNumList scaleToCM() {
        return this.scale(0.035277777777777776);
    }

    public JDFNumList scale(double factor) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double number = this.doubleAt(i) * factor;
            this.setElementAt(number, i);
        }
        return this;
    }

    public JDFNumList abs() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double number = Math.abs(this.doubleAt(i));
            this.setElementAt(number, i);
        }
        return this;
    }

    @Override
    public JDFNumList clone() {
        return (JDFNumList)super.clone();
    }

    public boolean matches(JDFNumList other, double delta) {
        if (other == null) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        JDFNumList dif = this.clone();
        dif.subtract(other);
        dif.abs();
        for (int i = 0; i < this.size(); ++i) {
            if (!(dif.doubleAt(i) > delta)) continue;
            return false;
        }
        return true;
    }

    public void subtract(JDFNumList l) {
        if (l == null || this.size() != l.size()) {
            return;
        }
        double[] me = this.getDoubleList();
        double[] them = l.getDoubleList();
        for (int i = 0; i < me.length; ++i) {
            int n = i;
            me[n] = me[n] - them[i];
            this.setElementAt(me[i], i);
        }
    }

    public void unify() {
        HashSet<Object> set = new HashSet<Object>();
        int j = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (set.contains(this.elementAt(j))) {
                this.remove(j);
                continue;
            }
            set.add(this.elementAt(j));
            ++j;
        }
    }

    public int[] getIntArray() {
        int size = this.size();
        int[] intArray = new int[size];
        for (int i = 0; i < size; ++i) {
            intArray[i] = ((Double)this.elementAt(i)).intValue();
        }
        return intArray;
    }

    public boolean contains(JDFNumList l) {
        if (l == null) {
            return false;
        }
        for (int i = 0; i < l.size(); ++i) {
            if (!this.contains(l.elementAt(i))) continue;
            return true;
        }
        return false;
    }

    public double norm() {
        double sum = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double di = this.doubleAt(i);
            sum += di * di;
        }
        return Math.sqrt(sum);
    }

    public double volume() {
        int size = this.size();
        if (size == 0) {
            return 0.0;
        }
        double product = 1.0;
        for (int i = 0; i < size; ++i) {
            double di = this.doubleAt(i);
            product *= di;
        }
        return product;
    }

    public boolean containsAll(JDFNumList l) {
        if (l == null) {
            return true;
        }
        for (int i = 0; i < l.size(); ++i) {
            if (this.contains(l.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    public static class NormComparator
    implements Comparator<JDFNumList> {
        @Override
        public int compare(JDFNumList o1, JDFNumList o2) {
            double d2;
            double d1 = o1 == null ? -1.0 : o1.norm();
            double d = d2 = o2 == null ? -1.0 : o2.norm();
            return d1 < d2 ? -1 : (d1 == d2 ? 0 : 1);
        }
    }

    public static class VolumeComparator
    implements Comparator<JDFNumList> {
        @Override
        public int compare(JDFNumList o1, JDFNumList o2) {
            double d2;
            double d1 = o1 == null ? Double.MIN_VALUE : o1.volume();
            double d = d2 = o2 == null ? Double.MIN_VALUE : o2.volume();
            return d1 < d2 ? -1 : (d1 == d2 ? 0 : 1);
        }
    }
}

