/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.CodeSource;
import java.util.zip.ZipEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.ElementWalker;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.zip.ZipReader;

public class PackageElementWalker
extends ElementWalker {
    private static final String WALK_CLASS = "Walk*.class";
    protected final Log log;

    public PackageElementWalker(BaseWalkerFactory _theFactory) {
        super(_theFactory);
        Class<?> myClass = this.getClass();
        this.log = LogFactory.getLog(myClass);
        this.constructWalkers();
    }

    private void constructWalkers() {
        Class<?> parent = this.getClass();
        CodeSource codesrc = parent.getProtectionDomain().getCodeSource();
        URL packsrc = codesrc.getLocation();
        File f = UrlUtil.urlToFile(UrlUtil.urlToString(packsrc));
        if (f.isDirectory()) {
            this.constructWorkersDir(f);
        } else {
            this.constructWorkersJar(f);
        }
    }

    private void constructWorkersJar(File jarFile) {
        ZipEntry ze;
        ZipReader zr = new ZipReader(jarFile);
        String packageName = this.getClass().getPackage().getName();
        int i = 0;
        while ((ze = zr.getMatchingEntry(WALK_CLASS, i)) != null) {
            String name = ZipReader.getEntryName(ze);
            name = packageName + "." + StringUtil.token(name, -1, "/");
            this.constructWalker(name);
            ++i;
        }
    }

    private void constructWorkersDir(File dir) {
        Class<?> currentClass = this.getClass();
        while (currentClass != null) {
            Class<?> nextClass;
            String packageName = currentClass.getPackage().getName();
            String packagePath = StringUtil.replaceChar(packageName, '.', "/", 0);
            packagePath = dir.getAbsolutePath() + "/" + packagePath;
            File[] classFiles = FileUtil.listFilesWithExpression(new File(packagePath), WALK_CLASS);
            if (classFiles != null) {
                for (File f : classFiles) {
                    String name = f.getName();
                    name = UrlUtil.prefix(name);
                    name = packageName + "." + name;
                    this.constructWalker(name);
                }
            }
            if (PackageElementWalker.class.isAssignableFrom(nextClass = currentClass.getSuperclass())) {
                currentClass = nextClass;
                continue;
            }
            currentClass = null;
        }
    }

    protected BaseWalker constructWalker(String name) {
        try {
            Class<?> newClass = Class.forName(name);
            Constructor<?> con = newClass.getConstructor(new Class[0]);
            BaseWalker w = (BaseWalker)con.newInstance(new Object[0]);
            w.addToFactory(this.getFactory());
            return w;
        }
        catch (Throwable e) {
            this.log.warn((Object)("Cannot construct class: " + name), e);
            return null;
        }
    }

    protected BaseWalkerFactory getFactory() {
        return (BaseWalkerFactory)this.theFactory;
    }
}

