/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.UnLinkFinder;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFComChannel;
import org.cip4.jdflib.resource.process.JDFGeneralID;
import org.cip4.jdflib.util.StringUtil;

public class RemoveEmpty
extends BaseElementWalker {
    boolean zappElements = true;
    final JDFPart part = (JDFPart)new JDFDoc("Part").getRoot();

    public RemoveEmpty() {
        super(new BaseWalkerFactory());
        new BaseWalker(this.getFactory());
    }

    public void removEmpty(JDFNode n) {
        new UnLinkFinder().eraseUnlinked(n);
        this.removEmptyElement(n);
        new UnLinkFinder().eraseUnlinked(n);
    }

    public void removEmptyElement(KElement e) {
        this.walkTreeKidsFirst(e);
    }

    public void removEmptyAttributes(KElement e) {
        boolean keep = this.zappElements;
        this.zappElements = false;
        this.walkTreeKidsFirst(e);
        this.zappElements = keep;
    }

    @Override
    protected BaseWalkerFactory getFactory() {
        return (BaseWalkerFactory)this.theFactory;
    }

    public void setZappElements(boolean zappElements) {
        this.zappElements = zappElements;
    }

    public class WalkComChannel
    extends WalkResource {
        @Override
        protected VString getDummyAttributes() {
            VString v = super.getDummyAttributes();
            v.add("ChannelType");
            return v;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFComChannel;
        }
    }

    public class WalkResource
    extends WalkElement {
        @Override
        protected VString getDummyAttributes() {
            VString v = super.getDummyAttributes();
            v.add("Class");
            v.add("Status");
            v.add("PartIDKeys");
            v.add("PartUsage");
            v.appendUnique(RemoveEmpty.this.part.knownAttributes());
            return v;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFResource;
        }
    }

    public class WalkComment
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String text = StringUtil.getNonEmpty(e.getText());
            if (text == null) {
                e.deleteNode();
                return null;
            }
            return super.walk(e, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFComment;
        }
    }

    public class WalkGeneralID
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String idUsage = ((JDFGeneralID)e).getIDUsage();
            String idValue = ((JDFGeneralID)e).getIDValue();
            if (StringUtil.getNonEmpty(idUsage) == null || StringUtil.getNonEmpty(idValue) == null) {
                e.deleteNode();
                return null;
            }
            return super.walk(e, trackElem);
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFGeneralID;
        }
    }

    public class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(RemoveEmpty.this.getFactory());
        }

        @Override
        public KElement walk(KElement e1, KElement trackElem) {
            JDFAttributeMap map = e1.getAttributeMap();
            VString allKeys = map.getKeys();
            VString ok = new VString();
            VString dummy = RemoveEmpty.this.zappElements ? this.getDummyAttributes() : null;
            for (String key : allKeys) {
                if (StringUtil.getNonEmpty(map.get(key)) == null) {
                    e1.removeAttribute(key);
                    continue;
                }
                if (!RemoveEmpty.this.zappElements || dummy.contains(key)) continue;
                ok.add(key);
            }
            if (RemoveEmpty.this.zappElements && e1.numChildElements_KElement(null, null) == 0 && e1.getText() == null && ok.size() == 0) {
                e1.deleteNode();
                return null;
            }
            return e1;
        }

        protected VString getDummyAttributes() {
            VString dummy = new VString();
            dummy.add("ID");
            dummy.add("AgentName");
            dummy.add("AgentVersion");
            return dummy;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return true;
        }
    }
}

