/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker;

import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.ifaces.IElementConverter;
import org.cip4.jdflib.ifaces.IURLSetter;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlUtil;

public class URLMapper
extends BaseElementWalker
implements IElementConverter {
    private final String baseIn;
    private final String baseOut;

    public URLMapper(String baseIn, String baseOut) {
        super(new BaseWalkerFactory());
        this.baseIn = baseIn;
        this.baseOut = baseOut;
    }

    @Override
    protected BaseWalkerFactory getFactory() {
        return (BaseWalkerFactory)this.theFactory;
    }

    @Override
    public KElement convert(KElement e) {
        this.walkTree(e, null);
        return e;
    }

    @Override
    public String toString() {
        return super.toString() + " baseIn=" + this.baseIn + ", baseOut=" + this.baseOut + "]";
    }

    public class WalkURL
    extends WalkElement {
        @Override
        public KElement walk(KElement e, KElement trackElem) {
            IURLSetter u = (IURLSetter)((Object)e);
            String url = StringUtil.getNonEmpty(u.getURL());
            if (url == null) {
                return e;
            }
            String relativeURL = UrlUtil.getLocalURL(URLMapper.this.baseIn, url);
            if (relativeURL != null) {
                u.setURL(UrlUtil.getURLWithDirectory(URLMapper.this.baseOut, relativeURL));
            }
            return e;
        }

        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof IURLSetter;
        }
    }

    public class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(URLMapper.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            return e;
        }
    }
}

