/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker.fixversion;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.PackageElementWalker;
import org.cip4.jdflib.elementwalker.fixversion.WalkElement;
import org.cip4.jdflib.util.EnumUtil;

public class FixVersionImpl
extends PackageElementWalker {
    protected boolean bFixIDs;
    protected boolean bZappInvalid;
    protected final JDFElement.EnumVersion version;
    protected boolean bOK;
    protected boolean fixICSVersions;
    protected boolean bLayoutPrepToStripping;

    public boolean isFixICSVersions() {
        return this.fixICSVersions;
    }

    public void setFixICSVersions(boolean pFixICSVersions) {
        this.fixICSVersions = pFixICSVersions;
    }

    public boolean isFixVersionIDFix() {
        return this.bFixIDs;
    }

    public boolean isOK() {
        return this.bOK;
    }

    public void setFixVersionIDFix(boolean fixVersionIDFix) {
        this.bFixIDs = fixVersionIDFix;
    }

    public FixVersionImpl(JDFElement.EnumVersion _version) {
        super(new BaseWalkerFactory());
        new BaseWalker(this.getFactory());
        this.bFixIDs = true;
        this.bZappInvalid = false;
        this.version = _version;
        this.bOK = true;
        this.fixICSVersions = false;
        this.bLayoutPrepToStripping = false;
    }

    public FixVersionImpl(FixVersionImpl fixVersion) {
        super(new BaseWalkerFactory());
        this.version = fixVersion.version;
        this.bZappInvalid = fixVersion.bZappInvalid;
        this.bFixIDs = fixVersion.bFixIDs;
        this.fixICSVersions = fixVersion.fixICSVersions;
        this.bLayoutPrepToStripping = fixVersion.bLayoutPrepToStripping;
    }

    @Override
    protected BaseWalkerFactory getFactory() {
        return (BaseWalkerFactory)this.theFactory;
    }

    public void setLayoutPrepToStripping(boolean layoutPrepToStripping) {
        this.bLayoutPrepToStripping = layoutPrepToStripping;
    }

    public boolean convert(KElement e) {
        this.walkTree(e, null);
        return this.isOK();
    }

    protected void updateAssemblyIDS(JDFElement e) {
        if (this.version != null) {
            if (this.lessThanVersion(JDFElement.EnumVersion.Version_1_3)) {
                e.renameAttribute("AssemblyIDs", "AssemblyID", null, null);
            } else {
                e.renameAttribute("AssemblyID", "AssemblyIDs", null, null);
            }
        }
    }

    protected boolean lessThanVersion(JDFElement.EnumVersion v) {
        return EnumUtil.aLessThanB(this.version, v);
    }

    @Override
    public String toString() {
        return "[FixVersion : version=" + (this.version == null ? "null" : this.version.getName()) + " LO->Strip" + this.bLayoutPrepToStripping;
    }

    public void setBZappInvalid(boolean zappInvalid) {
        this.bZappInvalid = zappInvalid;
    }

    @Override
    protected BaseWalker constructWalker(String name) {
        WalkElement constructWalker = (WalkElement)super.constructWalker(name);
        if (constructWalker != null) {
            constructWalker.setParent(this);
        }
        return constructWalker;
    }
}

