/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.elementwalker.fixversion;

import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.elementwalker.fixversion.WalkElement;
import org.cip4.jdflib.util.StringUtil;

public class WalkAudit
extends WalkElement {
    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFAudit;
    }

    @Override
    public KElement walk(KElement e1, KElement trackElem) {
        JDFAudit audit = (JDFAudit)e1;
        if (this.fixVersion.version != null) {
            this.fixID(audit);
            String author = audit.getAuthor();
            if (this.fixVersion.lessThanVersion(JDFElement.EnumVersion.Version_1_2)) {
                this.mergeAuthor(audit, author);
            } else if (author.length() > 0) {
                this.splitAuthor(audit, author);
            }
            this.authorToEmployee(audit);
        }
        return super.walk(e1, trackElem);
    }

    private void fixID(JDFAudit audit) {
        if (this.fixVersion.lessThanVersion(JDFElement.EnumVersion.Version_1_3)) {
            audit.removeAttribute("ID");
        } else {
            audit.appendAnchor(null);
        }
    }

    private void mergeAuthor(JDFAudit audit, String author) {
        String tmp = audit.getAgentName();
        boolean b = false;
        if (tmp.length() != 0) {
            author = author + "_|_" + tmp;
            b = true;
        }
        if ((tmp = audit.getAgentVersion()).length() != 0) {
            if (!b) {
                author = author + "_|_ ";
            }
            author = author + "_|_" + tmp;
            b = true;
        }
        audit.removeAttribute("AgentName");
        audit.removeAttribute("AgentVersion");
        if (b) {
            audit.setAuthor(author);
        }
    }

    private void splitAuthor(JDFAudit audit, String author) {
        VString tokens = StringUtil.tokenize(author, "_|_", false);
        if (tokens.size() == 3) {
            String tmp = tokens.stringAt(0);
            if (!tmp.equals("") && !tmp.equals(" ")) {
                audit.setAuthor(tmp);
            }
            if (!(tmp = tokens.stringAt(1)).equals("") && !tmp.equals(" ")) {
                audit.setAgentName(tmp);
            }
            if (!(tmp = tokens.stringAt(2)).equals("") && !tmp.equals(" ")) {
                audit.setAgentVersion(tmp);
            }
        }
    }

    private void authorToEmployee(JDFAudit audit) {
        if (!this.fixVersion.lessThanVersion(JDFElement.EnumVersion.Version_1_4)) {
            String finalAuthor = StringUtil.getNonEmpty(audit.getAuthor());
            if (finalAuthor != null && !audit.hasChildElement("Employee", null)) {
                audit.appendEmployee().setDescriptiveName(finalAuthor);
            }
            audit.removeAttribute("Author");
        }
    }
}

