/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFPartAmount;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.FixVersion;
import org.cip4.jdflib.elementwalker.PackageElementWalker;
import org.cip4.jdflib.extensions.PostXJDFWalker;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkElement;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.StringUtil;

public class JDFToXJDF
extends PackageElementWalker {
    public static final String rootName = "XJDF";
    public static final String rootJMF = "JMF";
    final String m_spawnInfo = "SpawnInfo";
    private boolean trackAudits;
    protected VString resAttribs;
    protected KElement newRoot = null;
    protected JDFNode oldRoot = null;
    protected boolean walkingProduct = false;
    protected Set<String> first = new HashSet<String>();
    private boolean bMergeLayout = true;
    private boolean bMergeLayoutPrep = true;
    private boolean bMergeRunList = true;
    boolean bRetainSpawnInfo = false;
    private boolean bSingleNode = true;
    private boolean bUpdateVersion = true;
    boolean bTypeSafeMessage = true;
    boolean bAbstractMessage = true;
    private boolean bSpanAsAttribute = true;
    boolean bIntentPartition = false;
    boolean bHTMLColor = false;
    private boolean bConvertTilde = false;

    public JDFToXJDF() {
        super(new BaseWalkerFactory());
        KElement.uniqueID(-1000);
        this.trackAudits = true;
        this.init();
    }

    @Override
    protected BaseWalker constructWalker(String name) {
        WalkElement constructWalker = (WalkElement)super.constructWalker(name);
        if (constructWalker != null) {
            constructWalker.setParent(this);
        }
        return constructWalker;
    }

    public void setTrackAudits(boolean trackAudits) {
        this.trackAudits = trackAudits;
    }

    public static String getSchemaURL() {
        return JDFElement.getSchemaURL(2, 0);
    }

    public KElement convert(KElement root) {
        if (root instanceof JDFJMF) {
            return this.makeNewJMF((JDFJMF)root);
        }
        if (root instanceof JDFNode) {
            return this.makeNewJDF((JDFNode)root, null);
        }
        return null;
    }

    public KElement makeNewJMF(JDFJMF jmf) {
        JDFJMF root = (JDFJMF)jmf.cloneNewDoc();
        this.prepareNewDoc(true);
        this.walkTree(root, this.newRoot);
        this.newRoot.eraseEmptyNodes(true);
        this.postWalk();
        return this.newRoot;
    }

    public KElement makeNewJDF(JDFNode node, VJDFAttributeMap vMap) {
        JDFNode root = (JDFNode)node.getJDFRoot().cloneNewDoc();
        if (this.trackAudits) {
            root.getCreateAuditPool().addCreated("XJDF Converter", null);
        }
        FixVersion vers = new FixVersion(JDFElement.EnumVersion.Version_1_4);
        vers.setLayoutPrepToStripping(this.bMergeLayoutPrep);
        vers.walkTree(root, null);
        String id = StringUtil.getNonEmpty(node.getID());
        JDFNode jDFNode = this.oldRoot = id == null ? root : (JDFNode)root.getChildWithAttribute(null, "ID", null, id, 0, false);
        if (this.oldRoot == null) {
            this.oldRoot = root;
        }
        this.walkingProduct = false;
        this.prepareNewDoc(false);
        this.loopNodes(this.oldRoot);
        this.walkingProduct = true;
        KElement productList = this.newRoot.appendElement("ProductList");
        this.prepareRoot(root);
        this.walkTree(root, productList);
        if (productList.getElement("Product") == null) {
            productList.deleteNode();
        }
        this.walkingProduct = false;
        this.postWalk();
        this.newRoot.getOwnerDocument_KElement().copyMeta(node.getOwnerDocument_KElement());
        return this.newRoot;
    }

    private void postWalk() {
        PostXJDFWalker pw = new PostXJDFWalker((JDFElement)this.newRoot);
        pw.mergeLayout = this.bMergeLayout;
        pw.bIntentPartition = this.bIntentPartition;
        pw.walkTreeKidsFirst(this.newRoot);
        this.newRoot.eraseEmptyNodes(true);
    }

    private void prepareRoot(JDFNode node) {
        if (node != null) {
            node.ensureLink(node.getInheritedCustomerInfo(null), JDFResourceLink.EnumUsage.Input, null);
            node.ensureLink(node.getInheritedNodeInfo(null), JDFResourceLink.EnumUsage.Input, null);
        }
    }

    private void loopNodes(JDFNode node) {
        this.walkTree(node, this.newRoot);
    }

    private void prepareNewDoc(boolean bJMF) {
        JDFDoc newDoc = new JDFDoc(bJMF ? rootJMF : rootName);
        newDoc.setInitOnCreate(false);
        this.newRoot = newDoc.getRoot();
        this.newRoot.setNamespaceURI(JDFToXJDF.getSchemaURL());
        this.first = new HashSet<String>();
    }

    private void init() {
        this.resAttribs = this.generateResourceAttributes();
    }

    protected VString generateResourceAttributes() {
        VString resAttribs = new VString();
        JDFResourcePool dummyResPool = (JDFResourcePool)new JDFDoc("ResourcePool").getRoot();
        JDFResource intRes = dummyResPool.appendResource("intent", JDFResource.EnumResourceClass.Intent, null);
        JDFResource physRes = dummyResPool.appendResource("physical", JDFResource.EnumResourceClass.Consumable, null);
        JDFResource paramRes = dummyResPool.appendResource("param", JDFResource.EnumResourceClass.Parameter, null);
        JDFPart part = (JDFPart)dummyResPool.appendElement("Part");
        resAttribs = paramRes.knownAttributes();
        resAttribs.appendUnique(physRes.knownAttributes());
        resAttribs.appendUnique(intRes.knownAttributes());
        resAttribs.appendUnique(part.knownAttributes());
        return resAttribs;
    }

    public String getClassName(String name) {
        if (name == null) {
            return null;
        }
        KElement e = new JDFDoc(name).getRoot();
        String className = e instanceof JDFResource ? this.getClassName((JDFResource)e) : null;
        return className;
    }

    String getClassName(JDFResource r) {
        KElement r2;
        if (r == null) {
            return null;
        }
        JDFResource.EnumResourceClass resourceClass = r.getResourceClass();
        if (resourceClass == null && (r2 = new JDFDoc(r.getLocalName()).getRoot()) instanceof JDFResource) {
            r2.init();
            resourceClass = ((JDFResource)r2).getResourceClass();
        }
        if (resourceClass == null) {
            return "Parameter";
        }
        String className = "Resource";
        if (resourceClass.equals((Object)JDFResource.EnumResourceClass.Parameter) || resourceClass.equals((Object)JDFResource.EnumResourceClass.Intent)) {
            className = resourceClass.getName();
        }
        if (resourceClass.equals((Object)JDFResource.EnumResourceClass.PlaceHolder)) {
            return null;
        }
        return className;
    }

    public static String getExtension() {
        return rootName.toLowerCase();
    }

    public void saveZip(String fileName, JDFNode rootNode, boolean replace) {
        File file = new File(fileName);
        if (file.canRead()) {
            if (replace) {
                file.delete();
            } else {
                throw new JDFException("output file exists: " + file.getPath());
            }
        }
        try {
            VElement v = rootNode.getvJDFNode(null, null, false);
            FileOutputStream fos = new FileOutputStream(fileName);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (int i = 0; i < v.size(); ++i) {
                JDFNode n = (JDFNode)v.elementAt(i);
                String nam = n.getJobPartID(false);
                if (nam == "") {
                    nam = "Node" + i;
                }
                try {
                    nam = nam + ".XJDF";
                    ZipEntry ze = new ZipEntry(nam);
                    zos.putNextEntry(ze);
                    KElement newRootL = this.makeNewJDF(n, null);
                    newRootL.getOwnerDocument_KElement().write2Stream(zos, 2, true);
                    zos.closeEntry();
                    continue;
                }
                catch (ZipException x) {
                    this.log.error((Object)"oops: ", (Throwable)x);
                    continue;
                }
                catch (IOException x) {
                    this.log.error((Object)"oops: ", (Throwable)x);
                }
            }
            zos.close();
        }
        catch (IOException x) {
            this.log.error((Object)"oops: ", (Throwable)x);
        }
    }

    void setAmountPool(JDFElement rl, KElement newLeaf, JDFAttributeMap partMap) {
        if (rl == null) {
            return;
        }
        JDFAmountPool ap = (JDFAmountPool)rl.getElement("AmountPool");
        if (ap == null) {
            if (rl.hasAttribute("Amount") || rl.hasAttribute("ActualAmount") || rl.hasAttribute("MaxAmount")) {
                newLeaf.setAttribute("AmountGood", rl.getAttribute("Amount", null, null));
                newLeaf.setAttribute("ActualAmountGood", rl.getAttribute("ActualAmount", null, null));
                newLeaf.setAttribute("MaxAmountGood", rl.getAttribute("MaxAmount", null, null));
            }
        } else {
            VElement vPartAmounts = ap.getMatchingPartAmountVector(partMap);
            if (vPartAmounts != null) {
                for (int i = 0; i < vPartAmounts.size(); ++i) {
                    JDFPartAmount pa = (JDFPartAmount)vPartAmounts.item(i);
                    JDFAttributeMap map = pa.getPartMap();
                    if (partMap != null) {
                        map.removeKeys(partMap.keySet());
                    }
                    if (map.isEmpty()) {
                        newLeaf.setAttribute("AmountGood", pa.getAttribute("Amount", null, null));
                        newLeaf.setAttribute("ActualAmountGood", pa.getAttribute("ActualAmount", null, null));
                        newLeaf.setAttribute("MaxAmountGood", pa.getAttribute("MaxAmount", null, null));
                        continue;
                    }
                    if (map.size() == 1 && map.containsKey("Condition")) {
                        JDFAttributeMap attMap = pa.getAttributeMap();
                        Iterator<String> it = attMap.getKeyIterator();
                        String condition = map.get("Condition");
                        while (it.hasNext()) {
                            String key = it.next();
                            if (key.indexOf("Amount") >= 0) {
                                newLeaf.setAttribute(key + condition, attMap.get(key));
                                continue;
                            }
                            newLeaf.setAttribute(key, attMap.get(key));
                        }
                        continue;
                    }
                    KElement amountPool = newLeaf.getCreateElement("AmountPool");
                    pa = (JDFPartAmount)amountPool.copyElement(pa, null);
                    pa.setPartMap(map);
                }
            }
        }
    }

    private KElement setBaseResource(JDFElement rl, JDFResource r, KElement xjdfSet) {
        JDFAttributeMap map = r.getPartMap();
        SetHelper sh = new SetHelper(xjdfSet);
        KElement newLeaf = sh.getCreatePartition(map, false).getPartition();
        this.setLeafAttributes(r, rl, newLeaf);
        return newLeaf;
    }

    private void setLeafAttributes(JDFResource leaf, JDFElement rl, KElement newLeaf) {
        JDFAttributeMap partMap = leaf.getPartMap();
        this.setAmountPool(rl, newLeaf, partMap);
        if (this.bRetainSpawnInfo && leaf.hasAttribute("SpawnIDs")) {
            KElement spawnInfo = newLeaf.getDocRoot().getCreateElement("SpawnInfo", null, 0);
            KElement spawnID = spawnInfo.appendElement("SpawnID");
            spawnID.moveAttribute("SpawnIDs", newLeaf, null, null, null);
            spawnID.moveAttribute("SpawnStatus", newLeaf, null, null, null);
            spawnID.copyAttribute("ResourceID", newLeaf, "ID", null, null);
        }
    }

    private void setSetAttributes(KElement resourceSet, KElement rl, JDFResource linkRoot) {
        resourceSet.setAttribute("Name", linkRoot.getNodeName());
        resourceSet.setAttributes(rl);
        resourceSet.removeAttribute("rRef");
        resourceSet.removeAttribute("rSubRef");
        resourceSet.removeAttribute("Amount");
        resourceSet.removeAttribute("AmountProduced");
        resourceSet.removeAttribute("MaxAmount");
        resourceSet.removeAttribute("ActualAmount");
        if (rl instanceof JDFResourceLink) {
            VElement vCreators;
            JDFResource resInRoot;
            JDFResourceLink resLink = (JDFResourceLink)rl;
            JDFNode rootIn = resLink.getJDFRoot();
            JDFResource jDFResource = resInRoot = rootIn == null ? linkRoot : (JDFResource)rootIn.getChildWithAttribute(null, "ID", null, resLink.getrRef(), 0, false);
            if (resInRoot != null && (vCreators = resInRoot.getCreator(JDFResourceLink.EnumUsage.Input.equals((Object)resLink.getUsage()))) != null) {
                int size = vCreators.size();
                for (int i = 0; i < size; ++i) {
                    JDFNode depNode = (JDFNode)vCreators.elementAt(i);
                    KElement dependent = resourceSet.appendElement("Dependent");
                    dependent.setAttribute("JobID", depNode.getJobID(true));
                    dependent.copyAttribute("JMFURL", depNode, null, null, null);
                    dependent.copyAttribute("JobPartID", depNode, null, null, null);
                }
            }
        }
    }

    protected VElement setResource(JDFElement rl, JDFResource linkTarget, KElement xRoot) {
        VElement v = new VElement();
        String className = this.getClassName(linkTarget);
        if (className == null) {
            return null;
        }
        linkTarget.expand(false);
        String resID = linkTarget.getAttribute("ID");
        KElement resourceSet = xRoot.getChildWithAttribute(className + "Set", "ID", null, resID, 0, true);
        if (resourceSet == null) {
            resourceSet = xRoot.appendElement(className + "Set");
            resourceSet.setAttribute("ID", linkTarget.getID());
        }
        this.setSetAttributes(resourceSet, rl, linkTarget);
        int nLeaves = resourceSet.numChildElements(className, null);
        VElement vRes = rl instanceof JDFResourceLink ? ((JDFResourceLink)rl).getTargetVector(0) : linkTarget.getLeaves(false);
        for (int j = 0; j < vRes.size(); ++j) {
            JDFResource r = (JDFResource)vRes.elementAt(j);
            VElement vLeaves = r.getLeaves(false);
            for (int k = 0; k < vLeaves.size(); ++k) {
                JDFResource leaf = (JDFResource)vLeaves.elementAt(k);
                KElement newBaseRes = this.setBaseResource(rl, leaf, resourceSet);
                int nn = resourceSet.numChildElements(className, null);
                if (nn > nLeaves) {
                    nLeaves = nn;
                    this.walkTree(leaf, newBaseRes);
                }
                v.add(newBaseRes);
            }
        }
        return v;
    }

    protected static VJDFAttributeMap getPartMapVector(KElement res) {
        VJDFAttributeMap omaMaps = null;
        VElement parts = res.getChildElementVector("Part", null, null, true, 0, false);
        if (parts != null && parts.size() > 0) {
            omaMaps = new VJDFAttributeMap();
            for (int i = 0; i < parts.size(); ++i) {
                omaMaps.add(((JDFPart)parts.get(i)).getPartMap());
            }
        }
        return omaMaps;
    }

    public void retainAll() {
        this.bUpdateVersion = false;
        this.bHTMLColor = false;
        this.bMergeLayout = false;
        this.bIntentPartition = false;
        this.bSpanAsAttribute = false;
        this.bMergeLayoutPrep = false;
        this.bMergeRunList = false;
        this.bTypeSafeMessage = false;
        this.bRetainSpawnInfo = true;
    }

    public void setUpdateVersion(boolean bUpdateVersion) {
        this.bUpdateVersion = bUpdateVersion;
    }

    public boolean isMergeLayout() {
        return this.bMergeLayout;
    }

    public void setMergeLayout(boolean bMergeLayout) {
        this.bMergeLayout = bMergeLayout;
    }

    public boolean isMergeLayoutPrep() {
        return this.bMergeLayoutPrep;
    }

    public void setMergeLayoutPrep(boolean bMergeLayoutPrep) {
        this.bMergeLayoutPrep = bMergeLayoutPrep;
    }

    public boolean isMergeRunList() {
        return this.bMergeRunList;
    }

    public void setMergeRunList(boolean bMergeRunList) {
        this.bMergeRunList = bMergeRunList;
    }

    public boolean isRetainSpawnInfo() {
        return this.bRetainSpawnInfo;
    }

    public void setRetainSpawnInfo(boolean bRetainSpawnInfo) {
        this.bRetainSpawnInfo = bRetainSpawnInfo;
    }

    public boolean isSingleNode() {
        return this.bSingleNode;
    }

    public void setSingleNode(boolean bSingleNode) {
        this.bSingleNode = bSingleNode;
    }

    public boolean isUpdateVersion() {
        return this.bUpdateVersion;
    }

    public boolean isTypeSafeMessage() {
        return this.bTypeSafeMessage;
    }

    public void setTypeSafeMessage(boolean bTypeSafeMessage) {
        this.bTypeSafeMessage = bTypeSafeMessage;
    }

    public boolean isAbstractMessage() {
        return this.bAbstractMessage;
    }

    public void setAbstractMessage(boolean bAbstractMessage) {
        this.bAbstractMessage = bAbstractMessage;
    }

    public boolean isSpanAsAttribute() {
        return this.bSpanAsAttribute;
    }

    public void setSpanAsAttribute(boolean bSpanAsAttribute) {
        this.bSpanAsAttribute = bSpanAsAttribute;
    }

    public boolean isIntentPartition() {
        return this.bIntentPartition;
    }

    public void setIntentPartition(boolean bIntentPartition) {
        this.bIntentPartition = bIntentPartition;
    }

    public boolean isHTMLColor() {
        return this.bHTMLColor;
    }

    public void setHTMLColor(boolean bHTMLColor) {
        this.bHTMLColor = bHTMLColor;
    }

    public boolean isConvertTilde() {
        return this.bConvertTilde;
    }

    public void setConvertTilde(boolean bConvertTilde) {
        this.bConvertTilde = bConvertTilde;
    }
}

