/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFResource;

public class WalkJDFElement
extends WalkElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFElement je = (JDFElement)jdf;
        this.makeRefElements(je);
        return super.walk(jdf, xjdf);
    }

    private void makeRefElements(JDFElement je) {
        VElement v = je.getChildElementVector_KElement(null, null, null, true, 0);
        for (int i = 0; i < v.size(); ++i) {
            JDFResource r;
            KElement e = v.get(i);
            if (!(e instanceof JDFResource) || this.mustInline((r = (JDFResource)e).getLocalName())) continue;
            this.cleanRefs(je, r);
        }
    }

    private void cleanRefs(JDFElement je, JDFResource r) {
        JDFNode parentJDF = je.getParentJDF();
        if (parentJDF != null) {
            r = r.makeRootResource(null, parentJDF, false);
            r.setResStatus(JDFResource.EnumResStatus.Available, true);
            JDFResourcePool prevPool = parentJDF.getResourcePool();
            if (prevPool != null) {
                r = this.removeDuplicateRefs(r, prevPool);
            }
            je.refElement(r);
        } else if (je.getJMFRoot() != null) {
            JDFResource resourceRoot = r.getResourceRoot();
            JDFElement parent = (JDFElement)(resourceRoot == null ? null : resourceRoot.getParentNode_KElement());
            r = r.makeRootResource(null, parent, false);
            r.setResStatus(JDFResource.EnumResStatus.Available, true);
            je.refElement(r);
        }
    }

    private JDFResource removeDuplicateRefs(JDFResource r, JDFResourcePool prevPool) {
        JDFAttributeMap m = r.getAttributeMap();
        m.remove("ID");
        VElement prevs = prevPool.getChildrenByTagName(r.getNodeName(), null, m, true, true, 0);
        if (prevs != null) {
            for (int j = 0; j < prevs.size(); ++j) {
                JDFResource prev = (JDFResource)prevs.get(j);
                if (r == prev) continue;
                String pid = prev.getID();
                String rid = r.getID();
                prev.removeAttribute("ID");
                r.removeAttribute("ID");
                if (r.isEqual(prev)) {
                    r.deleteNode();
                    r = prev;
                    prev.setID(pid);
                    break;
                }
                r.setID(rid);
                prev.setID(pid);
            }
        }
        return r;
    }

    protected String getRefName(JDFRefElement re) {
        return re.getLocalName();
    }

    protected boolean mustInline(JDFRefElement re) {
        return this.mustInline(re.getRefLocalName());
    }

    protected boolean mustInline(String refLocalName) {
        return "ObjectResolution".equals(refLocalName) || "BarcodeCompParams".equals(refLocalName) || "BarcodeReproParams".equals(refLocalName) || "ComChannel".equals(refLocalName) || "InterpretedPDLData".equals(refLocalName) || "ByteMap".equals(refLocalName) || "Company".equals(refLocalName) || "CostCenter".equals(refLocalName) || "Address".equals(refLocalName) || "Person".equals(refLocalName) || "Device".equals(refLocalName) || "DeviceNSpace".equals(refLocalName) || "ColorantAlias".equals(refLocalName) || "GlueLine".equals(refLocalName) || "GlueApplication".equals(refLocalName) || "CIELABMeasuringField".equals(refLocalName) || "RegisterMark".equals(refLocalName) || "FitPolicy".equals(refLocalName) || "CutBlock".equals(refLocalName) || "Employee".equals(refLocalName) || "ElementColorParams".equals(refLocalName) || "Cut".equals(refLocalName) || "PDLResourceAlias".equals(refLocalName) || "HoleList".equals(refLocalName) || "Hole".equals(refLocalName) || "MISDetails".equals(refLocalName) || "HoleLine".equals(refLocalName) || "JobField".equals(refLocalName) || "ObjectResolution".equals(refLocalName) || "AutomatedOverPrintParams".equals(refLocalName) || "ExternalImpositionTemplate".equals(refLocalName) || "ProductionPath".equals(refLocalName) || "Shape".equals(refLocalName) || "ScavengerArea".equals(refLocalName) || "ScavengerArea".equals(refLocalName) || "TrapRegion".equals(refLocalName) || "TransferCurve".equals(refLocalName) || "ColorControlStrip".equals(refLocalName) || "LayerList".equals(refLocalName) || "PageCondition".equals(refLocalName) || "ContentObject".equals(refLocalName) || "MarkObject".equals(refLocalName) || "FileSpec".equals(refLocalName) || "LayerDetails".equals(refLocalName) || "BinderySignature".equals(refLocalName);
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFElement;
    }

    @Override
    protected void removeUnused(KElement newRootP) {
        newRootP.removeAttribute("SpawnID");
        super.removeUnused(newRootP);
    }
}

