/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.process.JDFComponent;

public class WalkProduct
extends WalkJDFElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        KElement pList = "Product".equals(xjdf.getLocalName()) ? xjdf.getParentNode_KElement() : xjdf;
        JDFNode node = (JDFNode)jdf;
        if (!JDFNode.EnumType.Product.equals((Object)node.getEnumType())) {
            return null;
        }
        KElement prod = pList.appendElement("Product");
        prod.setAttributes(jdf);
        prod.removeAttribute("Type");
        prod.removeAttribute("Activation");
        prod.removeAttribute("Version");
        prod.removeAttribute("MaxVersion");
        prod.removeAttribute("ICSVersions");
        prod.removeAttribute("Status");
        prod.removeAttribute("StatusDetails");
        prod.removeAttribute("xmlns");
        prod.removeAttribute("xsi:type");
        prod.removeAttribute("JobID");
        prod.renameAttribute("JobPartID", "ProductID", null, null);
        prod.removeAttribute("xmlns:xsi");
        this.calcChildren(node, prod);
        this.readComponent(node, prod);
        return prod;
    }

    private void readComponent(JDFNode node, KElement prod) {
        JDFResourceLink cOut = node.getLink(0, "ComponentLink", new JDFAttributeMap("Usage", "Output"), null);
        if (cOut == null) {
            return;
        }
        this.jdfToXJDF.setAmountPool(cOut, prod, null);
        prod.renameAttribute("AmountGood", "Amount", null, null);
        prod.removeAttribute("AmountWaste");
        JDFComponent component = (JDFComponent)cOut.getTarget();
        prod.copyAttribute("ProductType", component);
        prod.copyAttribute("ProductTypeDetails", component);
    }

    private void calcChildren(JDFNode node, KElement prod) {
        VString kids = new VString();
        VElement vComp = node.getPredecessors(true, true);
        if (vComp != null) {
            int siz = vComp.size();
            for (int i = 0; i < siz; ++i) {
                JDFNode nPre = (JDFNode)vComp.get(i);
                if (!JDFNode.EnumType.Product.equals((Object)nPre.getEnumType())) continue;
                kids.add(nPre.getID());
            }
        }
        if (kids.size() > 0) {
            for (int i = 0; i < kids.size(); ++i) {
                KElement sub = prod.appendElement("ChildProduct");
                sub.setAttribute("ChildRef", kids.get(i), null);
            }
        } else {
            node.setAttribute("RootProduct", true, null);
        }
    }

    @Override
    public boolean matches(KElement toCheck) {
        return this.jdfToXJDF.walkingProduct && toCheck instanceof JDFNode;
    }
}

