/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.StringUtil;

public class WalkResLink
extends WalkJDFElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFResourceLink rl = (JDFResourceLink)jdf;
        JDFResource linkTarget = rl.getLinkRoot();
        if (linkTarget == null) {
            return null;
        }
        if (this.jdfToXJDF.walkingProduct) {
            if (!JDFResource.EnumResourceClass.Intent.equals((Object)linkTarget.getResourceClass())) {
                return null;
            }
            this.setResource(rl, linkTarget, xjdf);
        } else {
            if (JDFResource.EnumResourceClass.Intent.equals((Object)linkTarget.getResourceClass())) {
                return null;
            }
            this.setResource(rl, linkTarget, this.jdfToXJDF.newRoot);
            if (!this.jdfToXJDF.isSingleNode()) {
                this.setProcess(rl);
            }
        }
        return null;
    }

    VElement setResource(JDFResourceLink rl, JDFResource linkTarget, KElement xjdf) {
        return this.jdfToXJDF.setResource(rl, linkTarget, xjdf);
    }

    private void setProcess(JDFResourceLink rl) {
        if (rl == null) {
            return;
        }
        KElement process = this.getProcess(rl);
        this.setLink(process, rl);
    }

    private void setLink(KElement process, JDFResourceLink rl) {
        if (rl == null || process == null) {
            return;
        }
        JDFResourceLink.EnumUsage usage = rl.getUsage();
        if (usage == null) {
            return;
        }
        String attName = usage.getName();
        if (attName != null) {
            process.appendAttribute(attName, rl.getrRef(), null, " ", true);
        }
    }

    private KElement getProcess(JDFResourceLink rl) {
        JDFNode parent = rl.getParentJDF();
        if (parent == null || "Product".equals(parent.getType())) {
            return null;
        }
        String jobPartID = this.getJobPartID(parent);
        if (jobPartID == null) {
            return null;
        }
        KElement processList = this.jdfToXJDF.newRoot.getCreateElement("ProcessList", null, 0);
        KElement process = processList.getChildWithAttribute("Process", "JobPartID", null, jobPartID, 0, true);
        if (process == null) {
            process = processList.appendElement("Process");
            process.setAttribute("JobPartID", jobPartID);
            JDFNode grandparent = parent.getParentJDF();
            if (parent.hasAttribute("Types")) {
                process.copyAttribute("Types", parent);
            } else {
                process.copyAttribute("Types", parent, "Type", null, null);
            }
            if (grandparent != null) {
                process.setAttribute("Parent", this.getJobPartID(grandparent));
            }
        }
        return process;
    }

    private String getJobPartID(JDFNode parent) {
        String jobPartID = StringUtil.getNonEmpty(parent.getJobPartID(false));
        if (jobPartID == null) {
            jobPartID = StringUtil.getNonEmpty(parent.getID());
        }
        return jobPartID;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFResourceLink;
    }
}

