/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.Vector;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.elementwalker.EnsureNSUri;
import org.cip4.jdflib.elementwalker.UnLinkFinder;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.XJDFToJDFImpl;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFDependencies;
import org.cip4.jdflib.resource.process.JDFLayoutElement;
import org.cip4.jdflib.resource.process.JDFRunList;
import org.cip4.jdflib.util.StringUtil;

class PostConverter {
    private final XJDFToJDFImpl xjdfToJDFImpl;
    private final JDFNode theNode;

    public PostConverter(XJDFToJDFImpl xjdfToJDFImpl, JDFNode theNode) {
        this.xjdfToJDFImpl = xjdfToJDFImpl;
        this.theNode = theNode;
    }

    void postConvert() {
        JDFNode root = this.theNode.getJDFRoot();
        if ("Product".equals(root.getType())) {
            this.xjdfToJDFImpl.mergeProductLinks(this.theNode, root);
        }
        this.cleanResources();
        this.fixDependencies(root);
        new UnLinkFinder().eraseUnlinked(root);
        this.xjdfToJDFImpl.firstConvert = false;
        EnsureNSUri fixNS = new EnsureNSUri();
        fixNS.addNS(null, JDFElement.getSchemaURL());
        fixNS.walk(root);
    }

    private void cleanResources() {
        VElement vRes = this.collectResources();
        if (vRes != null) {
            for (KElement rr : vRes) {
                this.cleanResource(rr);
            }
        }
    }

    private VElement collectResources() {
        VElement vRes = new VElement();
        for (JDFNode n = this.theNode; n != null; n = n.getParentJDF()) {
            JDFResourcePool rp = n.getResourcePool();
            VElement v = rp == null ? null : rp.getPoolChildren(null, null, null);
            vRes.addAll(v);
        }
        return vRes;
    }

    private void cleanResource(KElement rr) {
        JDFResource r = (JDFResource)rr;
        if (r != null) {
            JDFResource.EnumResStatus s = r.getStatusFromLeaves(false);
            if (s != null) {
                r.setResStatus(s, false);
            }
            if ("ColorPool".equals(r.getLocalName())) {
                this.cleanColorPool(r);
            }
        }
    }

    private void cleanColorPool(JDFResource r) {
        VElement v;
        String id = r.getID();
        if (StringUtil.getNonEmpty(id) != null && (v = this.theNode.getRoot().getChildrenByTagName_KElement(null, null, new JDFAttributeMap("rRef", id), false, false, 0)) != null) {
            for (KElement e : v) {
                String name = e.getLocalName();
                if ("ColorRef".equals(name)) {
                    name = StringUtil.leftStr(e.getNodeName(), -3) + "PoolRef";
                    e.renameElement(name, null);
                    continue;
                }
                if (!"ColorLink".equals(name)) continue;
                name = StringUtil.leftStr(e.getNodeName(), -4) + "PoolLink";
                e.renameElement(name, null);
            }
        }
    }

    private void fixDependencies(JDFNode root) {
        Vector<JDFDependencies> vDep = root.getChildrenByClass(JDFDependencies.class, true, 0);
        if (vDep == null) {
            return;
        }
        for (JDFDependencies dep : vDep) {
            this.fixOneDependencies(dep);
        }
    }

    private void fixOneDependencies(JDFDependencies dep) {
        if (dep == null) {
            return;
        }
        VElement v = dep.getChildElementVector_KElement("RunListRef", null, null, true, 0);
        if (v == null) {
            return;
        }
        for (KElement e : v) {
            JDFRefElement rl = (JDFRefElement)e;
            rl.renameElement("LayoutElementRef", null);
            JDFResource root = rl.getTargetRoot();
            if (root == null) continue;
            VElement vR = root.getLeaves(true);
            VElement v2 = root.getLinksAndRefs(true, false);
            if (v2 != null) {
                for (KElement rl2 : v2) {
                    rl2.renameElement("LayoutElementLink", null);
                }
            }
            if ((v2 = root.getLinksAndRefs(false, true)) != null) {
                for (KElement rl2 : v2) {
                    rl2.renameElement("LayoutElementRef", null);
                }
            }
            for (KElement r : vR) {
                JDFLayoutElement loe;
                JDFLayoutElement jDFLayoutElement = loe = r instanceof JDFRunList ? ((JDFRunList)r).getLayoutElement() : null;
                if (loe != null) {
                    r.moveElements(loe.getChildElementVector_KElement(null, null, null, true, 0), null);
                    r.setAttributes(loe);
                    loe.deleteNode();
                }
                r.renameElement("LayoutElement", null);
            }
        }
    }
}

