/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFSeparationList;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkIntentResource;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.intent.JDFColorIntent;

public class WalkColorIntent
extends WalkIntentResource {
    final VString backAtts = new VString("Coatings ColorStandard Coverage", null);

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        this.evaluateColorsUsed(e);
        if (e.hasAttribute("NumColors")) {
            this.evaluateNumColors(e, trackElem);
        }
        for (String att : this.backAtts) {
            this.evaluateBackAttribute(e, att);
        }
        KElement ret = super.walk(e, trackElem);
        this.repartitionSide(e, trackElem);
        return ret;
    }

    private void repartitionSide(KElement e, KElement trackElem) {
        KElement cuBack = e.getElement("ColorsUsedBack");
        KElement cuFront = e.getElement("ColorsUsed");
        if (cuBack != null && cuFront != null) {
            VElement sepsBack;
            VElement sepsFront = cuFront.getChildElementVector("SeparationSpec", null);
            if (!sepsFront.isEqual(sepsBack = cuBack.getChildElementVector("SeparationSpec", null))) {
                if (cuFront.getElement("SeparationSpec") != null) {
                    JDFResource ciFront = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Front", null);
                    ciFront.moveElement(cuFront, null);
                } else {
                    cuFront.deleteNode();
                }
                if (cuBack.getElement("SeparationSpec") != null) {
                    JDFResource ciBack = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Back", null);
                    cuBack.renameElement("ColorsUsed", null);
                    ciBack.moveElement(cuBack, null);
                } else {
                    cuBack.deleteNode();
                }
            } else {
                cuBack.deleteNode();
            }
        } else if (cuBack == null && cuFront != null) {
            if (cuFront.getElement("SeparationSpec") != null) {
                JDFResource ciFront = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Front", null);
                ciFront.moveElement(cuFront, null);
            } else {
                cuFront.deleteNode();
            }
        } else if (cuBack != null && cuFront == null) {
            if (cuBack.getElement("SeparationSpec") != null) {
                JDFResource ciBack = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Back", null);
                ciBack.moveElement(cuBack, null);
            } else {
                cuBack.deleteNode();
            }
        }
        for (String att : this.backAtts) {
            String back = att + "Back";
            KElement coatBack = e.getElement(back);
            if (coatBack != null) {
                KElement coatings = e.getElement(att);
                if (coatings != null) {
                    JDFResource ciFront = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Front", null);
                    ciFront.moveElement(coatings, null);
                }
                JDFResource ciBack = ((JDFResource)trackElem).getCreatePartition(JDFResource.EnumPartIDKey.Side, "Back", null);
                ciBack.moveElement(e.getElement(back), null).renameElement(att, null);
            }
            this.evaluateBackAttribute(e, att);
        }
    }

    private void evaluateColorsUsed(KElement e) {
        JDFSeparationList sl = this.parent.createSeparationList(e, "ColorsUsed");
        if (e.hasAttribute("ColorsUsedBack")) {
            if (sl != null) {
                sl = (JDFSeparationList)sl.deleteNode();
            }
            e.renameAttribute("ColorsUsedBack", "ColorsUsed", null, null);
            JDFSeparationList slBack = this.parent.createSeparationList(e, "ColorsUsed");
            slBack.renameElement("ColorsUsedBack", null);
            if (sl != null) {
                e.moveElement(sl, slBack);
            }
        }
    }

    private void evaluateBackAttribute(KElement e, String front) {
        String back = front + "Back";
        if (e.hasAttribute(back)) {
            String frontVal = e.getAttribute(front, null, null);
            e.renameAttribute(back, front, null, null);
            KElement span = this.parent.attributeToSpan(e, front);
            span.renameElement(back, null);
            e.setAttribute(front, frontVal);
        }
    }

    private void evaluateNumColors(KElement e, KElement trackElem) {
        JDFXYPair xyp = JDFXYPair.createXYPair(e.getAttribute("NumColors", null, null));
        if (xyp != null) {
            double[] list = xyp.getDoubleList();
            e.removeAttribute("NumColors");
            for (int i = list.length - 1; i >= 0; --i) {
                int n = (int)(list[i] + 0.5);
                VString v = this.getDefaultSeparations(n);
                KElement cuf = null;
                if (i == 1) {
                    KElement cub;
                    cuf = e.getElement("ColorsUsed");
                    if (cuf != null) {
                        cuf.renameElement("ColorsUsedFront", null);
                    }
                    if ((cub = e.getElement("ColorsUsedBack")) != null) {
                        cub.renameElement("ColorsUsed", null);
                    }
                }
                JDFSeparationList newElem = (JDFSeparationList)e.getCreateElement("ColorsUsed");
                newElem.appendSeparations(v);
                newElem.unify();
                if (i != 1) continue;
                newElem.renameElement("ColorsUsedBack", null);
                if (cuf == null) continue;
                cuf.renameElement("ColorsUsed", null);
            }
        }
    }

    private VString getDefaultSeparations(int n) {
        VString v = new VString("Black Cyan Magenta Yellow Spot1 Spot2 Spot3 Spot4", null);
        while (v.size() > n) {
            v.remove(n);
        }
        return v;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && toCheck instanceof JDFColorIntent;
    }
}

