/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFComponent;

public class WalkProduct
extends WalkXElement {
    @Override
    public KElement walk(KElement e, KElement trackElem) {
        JDFNode theNode = (JDFNode)trackElem;
        if ("Product".equals(theNode.getType())) {
            JDFNode tmp = theNode.getRoot().getChildJDFNode(e.getAttribute("ID"), false);
            if (tmp != null) {
                theNode = tmp;
            } else if (theNode != this.parent.currentJDFNode && !this.parent.firstproductInList) {
                theNode = theNode.addProduct();
            }
        } else {
            theNode = this.parent.createProductRoot();
        }
        this.parent.firstproductInList = false;
        this.copyToNode(e, theNode);
        this.fixComponent(theNode, e);
        return theNode;
    }

    private void copyToNode(KElement e, JDFNode theNode) {
        VString ignore = new VString("IsRoot", null);
        theNode.setAttributes(e, ignore);
    }

    private void fixComponent(JDFNode theNode, KElement xjdfProduct) {
        JDFComponent c = (JDFComponent)theNode.getResource("Component", JDFResourceLink.EnumUsage.Output, 0);
        if (c == null) {
            c = (JDFComponent)theNode.addResource("Component", JDFResourceLink.EnumUsage.Output);
            JDFAutoComponent.EnumComponentType partialFinal = new ProductHelper(xjdfProduct).isRootProduct() ? JDFAutoComponent.EnumComponentType.FinalProduct : JDFAutoComponent.EnumComponentType.PartialProduct;
            c.setComponentType(partialFinal, null);
        }
        AttributeInfo info = c.getAttributeInfo();
        VString cKnown = info.knownAttribs();
        AttributeInfo infoNode = theNode.getAttributeInfo();
        cKnown.removeAll(infoNode.knownAttribs());
        cKnown.remove("Amount");
        cKnown.remove("ActualAmount");
        for (String known : cKnown) {
            if (!theNode.hasAttribute(known)) continue;
            c.moveAttribute(known, theNode);
        }
        JDFResourceLink rl = theNode.getLink((JDFResource)c, JDFResourceLink.EnumUsage.Output);
        if (rl != null) {
            rl.moveAttribute("Amount", theNode);
        }
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && toCheck.getLocalName().equals("Product");
    }
}

