/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.extensions.xjdfwalker.IDFinder;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.XJDFToJDFImpl;
import org.cip4.jdflib.util.StringUtil;

public class WalkXElement
extends BaseWalker {
    protected XJDFToJDFImpl parent = null;

    public void setParent(XJDFToJDFImpl xjdftojdf) {
        this.parent = xjdftojdf;
    }

    @Override
    public KElement walk(KElement e, KElement trackElem) {
        VElement v = trackElem.getChildElementVector(null, null);
        for (int i = 0; i < v.size(); ++i) {
            KElement kk = v.get(i);
            if (!e.isEqual(kk)) continue;
            return null;
        }
        this.cleanRefs(e, trackElem);
        if (this.parent.isXResourceElement(e)) {
            trackElem.setAttributes(e);
        } else {
            KElement e2 = trackElem.copyElement(e, null);
            this.parent.convertUnits(e2);
            this.parent.convertTilde(e2);
            this.fixNamespace(e2);
            e2.removeChildren(null, null, null);
            trackElem = e2;
        }
        this.parent.convertUnits(trackElem);
        this.parent.convertTilde(trackElem);
        return trackElem;
    }

    private void fixNamespace(KElement e2) {
        String namespace = e2.getNamespaceURI();
        if (JDFElement.getSchemaURL(2, 0).equals(StringUtil.leftStr(namespace, -1) + 0)) {
            e2.setNamespaceURI(JDFElement.getSchemaURL(1, 1));
        }
    }

    protected String getRefName(String val) {
        String refName = val.endsWith("Refs") ? StringUtil.leftStr(val, -1) : val;
        return refName;
    }

    protected void cleanRefs(KElement e, KElement trackElem) {
        JDFAttributeMap map = e.getAttributeMap();
        if (map == null) {
            return;
        }
        VString keys = map.getKeys();
        if (keys != null) {
            int keySize = keys.size();
            for (int i = 0; i < keySize; ++i) {
                String val = keys.get(i);
                if (!val.endsWith("Ref") && !val.endsWith("Refs") || val.equals("rRef")) continue;
                String values = map.get(val);
                this.cleanRef(e, trackElem, val, values);
            }
        }
    }

    protected void cleanRef(KElement e, KElement trackElem, String val, String values) {
        VString vValues = StringUtil.tokenize(values, null, false);
        for (String value : vValues) {
            IDFinder.IDPart p = this.parent.idMap.get(value);
            if (p == null) continue;
            String refName = this.getRefName(val);
            if (refName != null) {
                KElement refOld = trackElem != null ? trackElem.getElement(refName) : null;
                KElement ref = e.appendElement(refName);
                ref.setAttribute("rRef", p.getID());
                VJDFAttributeMap vpartmap = p.getPartMap();
                if (vpartmap != null) {
                    for (int j = 0; j < vpartmap.size(); ++j) {
                        ref.appendElement("Part").setAttributes(vpartmap.get(j));
                    }
                }
                if (ref.isEqual(refOld)) {
                    ref.deleteNode();
                }
            }
            e.removeAttribute(val);
        }
    }
}

