/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.StringUtil;

public class WalkXJDF
extends WalkXElement {
    @Override
    public KElement walk(KElement e, KElement trackElem) {
        this.parent.currentJDFNode = (JDFNode)trackElem;
        this.parent.currentJDFNode.setAttributes(e);
        this.parent.currentJDFNode.setVersion(this.parent.getVersion());
        this.parent.currentJDFNode.setStatus(JDFElement.EnumNodeStatus.Part);
        this.removeInheritedJobID();
        this.setTypes();
        return this.parent.currentJDFNode;
    }

    private void setTypes() {
        String t = this.parent.currentJDFNode.getAttribute("Types", null, null);
        if ("Product".equals(t)) {
            this.parent.currentJDFNode.setType(JDFNode.EnumType.Product);
            this.parent.currentJDFNode.removeAttribute("Types");
            this.parent.createProduct = true;
            this.parent.foundProduct = true;
        } else if (StringUtil.tokenize(t, null, false).size() == 1) {
            this.parent.currentJDFNode.setType(t.trim(), false);
        } else {
            this.parent.currentJDFNode.setType(JDFNode.EnumType.ProcessGroup);
        }
    }

    private void removeInheritedJobID() {
        JDFNode parentNode = this.parent.currentJDFNode.getParentJDF();
        if (parentNode != null) {
            String jobID = StringUtil.getNonEmpty(parentNode.getJobID(true));
            String myJobID = StringUtil.getNonEmpty(this.parent.currentJDFNode.getJobID(false));
            if (myJobID != null && myJobID.equals(jobID)) {
                this.parent.currentJDFNode.removeAttribute("JobID");
            }
        }
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && "XJDF".equals(toCheck.getLocalName());
    }
}

