/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import java.util.Iterator;
import java.util.Map;
import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.DocumentJDFImpl;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.JDFSeparationList;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFNameRange;
import org.cip4.jdflib.datatypes.JDFNameRangeList;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.PackageElementWalker;
import org.cip4.jdflib.extensions.xjdfwalker.IDFinder;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.PostConverter;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UnitParser;

public class XJDFToJDFImpl
extends PackageElementWalker {
    JDFDoc jdfDoc;
    Map<String, IDFinder.IDPart> idMap;
    boolean firstConvert = true;
    boolean firstproductInList = true;
    boolean foundProduct;
    boolean foundProductList = false;
    JDFNode currentJDFNode = null;
    boolean createProduct = true;
    boolean convertUnits;
    private JDFElement.EnumVersion version = JDFElement.EnumVersion.Version_1_4;
    private boolean bConvertTilde;
    private boolean heuristicLink;

    @Override
    protected BaseWalker constructWalker(String name) {
        WalkXElement constructWalker = (WalkXElement)super.constructWalker(name);
        if (constructWalker != null) {
            constructWalker.setParent(this);
        }
        return constructWalker;
    }

    public boolean isCreateProduct() {
        return this.createProduct;
    }

    public void setCreateProduct(boolean createProduct) {
        this.createProduct = createProduct;
    }

    public boolean isConvertUnits() {
        return this.convertUnits;
    }

    public void setConvertUnits(boolean convertUnits) {
        this.convertUnits = convertUnits;
    }

    public boolean isbConvertTilde() {
        return this.bConvertTilde;
    }

    public void setbConvertTilde(boolean bConvertTilde) {
        this.bConvertTilde = bConvertTilde;
    }

    public XJDFToJDFImpl(JDFDoc template) {
        super(new BaseWalkerFactory());
        this.jdfDoc = template == null ? null : template.clone();
        this.idMap = null;
        this.foundProduct = false;
        this.bConvertTilde = false;
        this.convertUnits = false;
        this.heuristicLink = true;
    }

    public void resetProduct() {
        this.foundProduct = false;
        this.foundProductList = false;
    }

    public JDFDoc convert(KElement xjdf) {
        if (xjdf == null) {
            return null;
        }
        if (this.jdfDoc == null) {
            this.jdfDoc = new JDFDoc("JDF");
            this.jdfDoc.copyMeta(xjdf.getOwnerDocument_KElement());
        }
        this.prepareRoot();
        xjdf = this.reparse(xjdf);
        xjdf.setAttribute("Version", this.version.getName());
        JDFNode theNode = this.findNode(xjdf, true);
        if (theNode == null) {
            return null;
        }
        this.idMap = new IDFinder().getMap(xjdf);
        this.walkTree(xjdf, theNode);
        new PostConverter(this, theNode).postConvert();
        return this.jdfDoc;
    }

    protected KElement reparse(KElement xjdf) {
        if (xjdf != null && !(xjdf.getOwnerDocument() instanceof DocumentJDFImpl)) {
            JDFDoc doc = new JDFDoc(xjdf.getOwnerDocument());
            doc.setInitOnCreate(false);
            KElement xjdf2 = doc.getRoot();
            if (!xjdf2.getLocalName().equals(xjdf.getLocalName())) {
                xjdf2 = xjdf2.getChildByTagName(xjdf.getNodeName(), xjdf.getNamespaceURI(), 0, xjdf.getAttributeMap(), false, true);
            }
            int i = 0;
            while (xjdf2 != null) {
                if (xjdf.isEqual(xjdf2)) {
                    xjdf = xjdf2;
                    break;
                }
                xjdf2 = xjdf2.getChildByTagName(xjdf.getNodeName(), xjdf.getNamespaceURI(), ++i, xjdf.getAttributeMap(), false, true);
            }
            if (xjdf2 == null) {
                this.log.error((Object)"SNAFU converting xjdf - retaining old");
            }
        }
        return xjdf;
    }

    private JDFNode prepareRoot() {
        JDFNode root = this.jdfDoc.getJDFRoot();
        if (this.firstConvert) {
            root.getCreateAuditPool().addModified(null, null);
        } else if (!"Product".equals(root.getType())) {
            root = this.createProductRoot();
        }
        return root;
    }

    public boolean canConvert(KElement xjdf) {
        return xjdf == null ? false : "XJDF".equals(xjdf.getLocalName());
    }

    private JDFNode findNode(KElement xjdf, boolean create) {
        JDFNode n;
        JDFNode root = this.jdfDoc.getJDFRoot();
        String jpID = xjdf.getAttribute("JobPartID", null, null);
        JDFNode jDFNode = n = jpID == null ? null : root.getJobPart(jpID, null);
        if (n == null) {
            if (!root.hasAttribute("Type")) {
                return root;
            }
            if (jpID == null) {
                VElement nodes = root.getvJDFNode(null, null, false);
                VString xTypes = StringUtil.tokenize(xjdf.getAttribute("Types"), null, false);
                for (int i = 0; i < nodes.size(); ++i) {
                    JDFNode n2 = (JDFNode)nodes.get(i);
                    VString vtypes = n2.getAllTypes();
                    if (!vtypes.containsAll(xTypes)) continue;
                    return n2;
                }
            }
        }
        if (n == null && create) {
            n = root.addProcessGroup(new VString(xjdf.getAttribute("Types"), null));
        }
        return n;
    }

    boolean isXResourceElement(KElement toCheck) {
        boolean bReturn = false;
        if (toCheck != null) {
            KElement parent = toCheck.getParentNode_KElement();
            if (parent == null) {
                return bReturn;
            }
            KElement parent2 = parent.getParentNode_KElement();
            if (parent2 == null) {
                return bReturn;
            }
            String parentName = parent2.getLocalName();
            boolean bL1 = parentName.endsWith("Set") && toCheck.getLocalName().equals(KElement.xmlnsLocalName(parent2.getAttribute("Name")));
            bReturn = bL1 = bL1 || parentName.equals("Product") && toCheck.getLocalName().equals(KElement.xmlnsLocalName(parent.getAttribute("Name")));
        }
        return bReturn;
    }

    boolean isXResource(KElement toCheck) {
        KElement parent = toCheck.getParentNode_KElement();
        if (parent == null) {
            return false;
        }
        String localName = parent.getLocalName();
        boolean b = localName.endsWith("Set");
        b = b && toCheck.getLocalName().equals(StringUtil.leftStr(localName, -3));
        return b && parent.hasAttribute("Name");
    }

    protected JDFSeparationList createSeparationList(KElement rPart, String elem) {
        String c = rPart.getAttribute(elem, null, null);
        JDFSeparationList sepList = null;
        if (c != null) {
            sepList = (JDFSeparationList)rPart.getCreateElement(elem);
            sepList.setSeparations(new VString(c, null));
            rPart.removeAttribute(elem);
        }
        return sepList;
    }

    protected JDFNode createProductRoot() {
        JDFNode parent = (JDFNode)this.jdfDoc.createElement("JDF");
        parent.setType(JDFNode.EnumType.Product);
        JDFNode oldParent = this.jdfDoc.getJDFRoot();
        oldParent = (JDFNode)parent.moveElement(oldParent, null);
        this.jdfDoc.appendChild(parent);
        parent.moveAttribute("JobID", oldParent);
        parent.moveAttribute("Version", oldParent);
        parent.setJobPartID("rootPart");
        parent.moveElement(oldParent.getResourcePool(), null);
        JDFComponent c = (JDFComponent)parent.addResource("Component", JDFResourceLink.EnumUsage.Output);
        c.setDescriptiveName("dummy output");
        c.setComponentType(JDFAutoComponent.EnumComponentType.FinalProduct, null);
        this.mergeProductLinks(oldParent, parent);
        this.firstConvert = true;
        return parent;
    }

    protected void convertUnits(KElement e2) {
        if (this.convertUnits) {
            JDFAttributeMap map = e2.getAttributeMap();
            Iterator<String> keyIt = map.getKeyIterator();
            UnitParser up = new UnitParser();
            while (keyIt.hasNext()) {
                JDFDate d;
                String newVal;
                String key = keyIt.next();
                String val = map.get(key);
                if (!val.equals(newVal = up.extractUnits(val))) {
                    e2.setAttribute(key, newVal);
                }
                if (!(e2 instanceof JDFElement) || !AttributeInfo.EnumAttributeType.dateTime.equals((Object)((JDFElement)e2).getAttributeInfo().getAttributeType(key)) || (d = JDFDate.createDate(val)) == null || val.equals(d.getDateTimeISO())) continue;
                e2.setAttribute(key, d.getDateTimeISO());
            }
        }
    }

    protected void convertTilde(KElement e2) {
        if (this.bConvertTilde) {
            JDFAttributeMap map = e2.getAttributeMap();
            Iterator<String> keyIt = map.getKeyIterator();
            while (keyIt.hasNext()) {
                VString v;
                String key = keyIt.next();
                String val = map.get(key);
                if (!(e2 instanceof JDFElement) || !AttributeInfo.EnumAttributeType.isRange(((JDFElement)e2).getAttributeInfo().getAttributeType(key)) || (v = new VString(val, null)).size() % 2 != 0) continue;
                JDFNameRangeList nrl = new JDFNameRangeList();
                for (int i = 0; i < v.size(); i += 2) {
                    nrl.append(new JDFNameRange(v.get(i), v.get(i + 1)));
                }
                String newVal = nrl.getString(0);
                if (val.equals(newVal)) continue;
                e2.setAttribute(key, newVal);
            }
        }
    }

    void mergeProductLinks(JDFNode theNode, JDFNode parent) {
        JDFResource rNode;
        this.mergeProductLink(theNode, parent, "CustomerInfo", JDFResourceLink.EnumUsage.Input);
        this.mergeProductLink(theNode, parent, "NodeInfo", JDFResourceLink.EnumUsage.Input);
        JDFResource r = parent.getResource("Component", JDFResourceLink.EnumUsage.Output, 0);
        if (r != null && "dummy outout".equals(r.getDescriptiveName()) && (rNode = theNode.getResource("Component", JDFResourceLink.EnumUsage.Output, 0)) != null) {
            parent.getLink(r, JDFResourceLink.EnumUsage.Output).deleteNode();
            r.deleteNode();
        }
        this.mergeProductLink(theNode, parent, "Component", JDFResourceLink.EnumUsage.Output);
    }

    private void mergeProductLink(JDFNode theNode, JDFNode parent, String resName, JDFResourceLink.EnumUsage enumUsage) {
        JDFResourceLink link;
        JDFResource r = parent.getResource(resName, enumUsage, 0);
        if (r == null && (link = theNode.getLink(0, resName, new JDFAttributeMap("Usage", enumUsage), null)) != null) {
            parent.ensureLink(link.getLinkRoot(), enumUsage, null);
        }
    }

    public void setVersion(JDFElement.EnumVersion version) {
        this.version = version;
    }

    public JDFElement.EnumVersion getVersion() {
        return this.version;
    }

    protected void attributesToSpan(KElement e) {
        JDFAttributeMap map = e.getAttributeMap();
        JDFElement ir = (JDFElement)e;
        VString keys = map.getKeys();
        VString knownElements = ir.knownElements();
        for (String name : keys) {
            if (!knownElements.contains(name)) continue;
            this.attributeToSpan(e, name);
        }
    }

    protected KElement attributeToSpan(KElement e, String name) {
        KElement subElem = e.appendElement(name);
        subElem.init();
        subElem.setAttribute("Actual", e.getAttribute(name));
        this.convertUnits(subElem);
        this.convertTilde(subElem);
        e.removeAttribute(name);
        return subElem;
    }

    protected void moveToLink(JDFResourceLink rl, JDFAttributeMap partmap, JDFAttributeMap map, String a) {
        if (map == null || map.isEmpty()) {
            return;
        }
        VString vGW = new VString("Good Waste", null);
        for (String gw : vGW) {
            JDFAttributeMap pm = new JDFAttributeMap(partmap);
            pm.put("Condition", gw);
            if (map.get(a + gw) == null) continue;
            if (rl != null) {
                rl.setAmountPoolAttribute(a, map.get(a + gw), null, pm);
            }
            map.remove(a + gw);
        }
    }

    protected void moveAmountsToLink(JDFAttributeMap partmap, JDFAttributeMap map, JDFResourceLink rl) {
        this.moveToLink(rl, partmap, map, "Amount");
        this.moveToLink(rl, partmap, map, "ActualAmount");
        this.moveToLink(rl, partmap, map, "MaxAmount");
    }

    public void setConvertTilde(boolean b) {
        this.bConvertTilde = b;
    }

    public void setHeuristicLink(boolean heuristicLink) {
        this.heuristicLink = heuristicLink;
    }

    public boolean isHeuristicLink() {
        return this.heuristicLink;
    }
}

