/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.goldenticket;

import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.auto.JDFAutoStitchingParams;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.goldenticket.MISGoldenTicket;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFCollectingParams;
import org.cip4.jdflib.resource.process.JDFComponent;
import org.cip4.jdflib.resource.process.JDFMedia;
import org.cip4.jdflib.resource.process.postpress.JDFFoldingParams;
import org.cip4.jdflib.resource.process.postpress.JDFStitchingParams;
import org.cip4.jdflib.resource.process.postpress.JDFTrimmingParams;

public class MISFinGoldenTicket
extends MISGoldenTicket {
    public static final String MISFIN_SHEETFIN = "MISFin.SheetFin";
    public static final String MISFIN_BOXMAKING = "MISFin.BoxMaking";
    public static final String MISFIN_INSERTFIN = "MISFIN.InsertFin";
    public static final String MISFIN_STITCHFIN = "MISFin.StitchFin";
    public static final String MISFIN_SOFTCOVERFIN = "MISFin.SoftcoverFin";
    public static final String MISFIN_HARDCOVERFIN = "MISFin.HardcoverFin";
    public String foldCatalog = "F8-2";

    public MISFinGoldenTicket(int _icsLevel, JDFElement.EnumVersion jdfVersion, int _jmfLevel, int _misLevel, VJDFAttributeMap vPartMap) {
        super(_misLevel, jdfVersion, _jmfLevel);
        this.partIDKeys = new VString("SignatureName,SheetName", ",");
        this.vParts = vPartMap;
        this.icsLevel = _icsLevel;
        this.grayBox = true;
    }

    @Override
    protected void fillCatMaps() {
        super.fillCatMaps();
        this.catMap.put(MISFIN_BOXMAKING, new VString(JDFNode.EnumType.BoxFolding.getName(), null));
        this.catMap.put(MISFIN_HARDCOVERFIN, new VString("BlockPreparation CaseMaking CasingIn", null));
        this.catMap.put(MISFIN_INSERTFIN, new VString("Inserting Trimming", null));
        this.catMap.put(MISFIN_SHEETFIN, new VString("Folding", null));
        this.catMap.put(MISFIN_SOFTCOVERFIN, new VString("Gathering CoverApplication Trimming", null));
        this.catMap.put(MISFIN_STITCHFIN, new VString("Stitching Collecting Trimming", null));
    }

    public MISFinGoldenTicket(MISFinGoldenTicket parent) {
        super(parent);
    }

    @Override
    public void init() {
        super.init();
        this.initFolding();
        this.initTrimming();
        this.initCollecting();
        this.initStitching();
        this.initInputComponent();
        this.initOutputComponent();
    }

    @Override
    public VString getICSVersions() {
        VString v = super.getICSVersions();
        String icsTag = "MISFin_L" + this.icsLevel + "-" + this.theVersion.getName();
        v.appendUnique(icsTag);
        return v;
    }

    private void initStitching() {
        if (this.theNode.getTypes().contains("Stitching")) {
            JDFStitchingParams sp = (JDFStitchingParams)this.theNode.getCreateResource("StitchingParams", JDFResourceLink.EnumUsage.Input, 0);
            sp.setStapleShape(JDFAutoStitchingParams.EnumStapleShape.Butted);
            sp.setStitchWidth(36.0);
        }
    }

    private JDFCollectingParams initCollecting() {
        JDFCollectingParams cp = null;
        if (this.theNode.getTypes().contains("Collecting")) {
            cp = (JDFCollectingParams)this.theNode.getCreateResource("CollectingParams", JDFResourceLink.EnumUsage.Input, 0);
        }
        return cp;
    }

    private void initFolding() {
        if (this.theNode.getTypes().contains("Folding")) {
            JDFFoldingParams fp = (JDFFoldingParams)this.theNode.getCreateResource("FoldingParams", JDFResourceLink.EnumUsage.Input, 0);
            fp.setFoldCatalog(this.foldCatalog);
        }
    }

    private void initTrimming() {
        if (this.theNode.getTypes().contains("Trimming")) {
            JDFTrimmingParams tp = (JDFTrimmingParams)this.theNode.getCreateResource("TrimmingParams", JDFResourceLink.EnumUsage.Input, 0);
            tp.setHeight(864.0);
            tp.setWidth(432.0);
        }
    }

    @Override
    public void setActivePart(VJDFAttributeMap vp, boolean bFirst) {
        this.amountLinks = null;
        if (bFirst) {
            this.addAmountLink("Component:Input");
        }
        this.addAmountLink("Component:Output");
        super.setActivePart(vp, bFirst);
    }

    @Override
    protected JDFComponent initOutputComponent() {
        JDFComponent outComp;
        JDFResource parentOutComp;
        if (this.thePreviousNode != null && (parentOutComp = this.thePreviousNode.getResource("Component", JDFResourceLink.EnumUsage.Output, 0)) != null) {
            this.theNode.linkResource(parentOutComp, JDFResourceLink.EnumUsage.Input, null);
        }
        if ((outComp = (JDFComponent)(this.theParentNode != null ? this.theParentNode.getResource("Component", JDFResourceLink.EnumUsage.Output, 0) : null)) == null) {
            outComp = (JDFComponent)this.theNode.getCreateResource("Component", JDFResourceLink.EnumUsage.Output, 0);
            outComp.setComponentType(JDFAutoComponent.EnumComponentType.FinalProduct, JDFAutoComponent.EnumComponentType.Sheet);
            outComp.setProductType("Unknown");
        } else {
            this.theNode.linkResource((JDFResource)outComp, JDFResourceLink.EnumUsage.Output, null);
        }
        JDFResourceLink rl = this.theNode.getLink((JDFResource)outComp, JDFResourceLink.EnumUsage.Output);
        if (this.vParts != null && MISFIN_SHEETFIN.equals(this.category)) {
            VJDFAttributeMap reducedMap = this.getReducedMap(new VString("Side Separation", " "));
            if (reducedMap != null) {
                int size = reducedMap.size();
                for (int i = 0; i < size; ++i) {
                    JDFAttributeMap part = reducedMap.elementAt(i);
                    JDFResource partComp = outComp.getCreatePartition(part, this.partIDKeys);
                    partComp.setDescriptiveName("Description for Component part# " + i);
                    JDFAttributeMap newMap = new JDFAttributeMap(part);
                    newMap.put("Condition", "Good");
                    rl.setAmount(this.good, newMap);
                }
            }
        } else {
            outComp.setDescriptiveName("MIS-Fin output Component");
        }
        JDFMedia inMedia = (JDFMedia)this.theNode.getResource("Media", JDFResourceLink.EnumUsage.Input, 0);
        if (inMedia != null) {
            outComp.setDimensions(inMedia.getDimension());
        }
        return outComp;
    }

    protected JDFComponent initInputComponent() {
        JDFComponent comp = (JDFComponent)(this.theParentNode != null ? this.theParentNode.getResource("Component", JDFResourceLink.EnumUsage.Input, 0) : null);
        if (comp == null) {
            comp = (JDFComponent)this.theNode.getCreateResource("Component", JDFResourceLink.EnumUsage.Input, 0);
            comp.setComponentType(JDFAutoComponent.EnumComponentType.PartialProduct, JDFAutoComponent.EnumComponentType.Sheet);
            comp.setProductType("Unknown");
        } else {
            this.theNode.linkResource((JDFResource)comp, JDFResourceLink.EnumUsage.Input, null);
        }
        this.theNode.getLink((JDFResource)comp, JDFResourceLink.EnumUsage.Input);
        comp.setResStatus(JDFResource.EnumResStatus.Available, true);
        return comp;
    }

    @Override
    protected void runphases(int pgood, int pwaste, boolean bOutAvail, boolean bFirst) {
        this.theStatusCounter.setPhase(JDFElement.EnumNodeStatus.InProgress, "Good", JDFAutoDeviceInfo.EnumDeviceStatus.Running, "Printing");
        this.runSinglePhase(pgood, pwaste, bOutAvail, bFirst);
        this.finalize();
        this.theStatusCounter.setPhase(JDFElement.EnumNodeStatus.Completed, "Done", JDFAutoDeviceInfo.EnumDeviceStatus.Idle, "Waiting");
    }

    @Override
    public void assign(JDFNode node) {
        super.assign(node);
        this.theNode.getCreateNodeInfo().setPartIDKeys(this.partIDKeys);
    }
}

