/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.jmf;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoDeviceInfo;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.jmf.JDFJobPhase;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFDevice;
import org.cip4.jdflib.resource.JDFModulePhase;
import org.cip4.jdflib.resource.JDFPhaseTime;
import org.cip4.jdflib.resource.process.JDFEmployee;
import org.cip4.jdflib.resource.process.JDFMISDetails;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class JDFDeviceInfo
extends JDFAutoDeviceInfo {
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[1];
    private static final long serialVersionUID = 1L;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    public JDFDeviceInfo(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFDeviceInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFDeviceInfo(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFDeviceInfo[  --> " + super.toString() + " ]";
    }

    @Deprecated
    public int getJobCount() {
        return this.getChildrenByTagName("JobPhase", null, null, false, true, 0).size();
    }

    @Override
    public void setIdleStartTime(JDFDate value) {
        JDFDate valueLocal = value;
        if (valueLocal == null) {
            valueLocal = new JDFDate();
        }
        this.setAttribute("IdleStartTime", valueLocal.getDateTimeISO(), null);
    }

    @Override
    public JDFDate getIdleStartTime() {
        String str = this.getAttribute("IdleStartTime", null, null);
        if (str != null) {
            try {
                return new JDFDate(str);
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public JDFJobPhase createJobPhaseFromPhaseTime(JDFPhaseTime pt) {
        JDFJobPhase jp = this.appendJobPhase();
        JDFNode node = pt.getParentJDF();
        jp.setJobID(node.getJobID(true));
        jp.setJobPartID(StringUtil.getNonEmpty(node.getJobPartID(true)));
        VJDFAttributeMap partMapVector = pt.getPartMapVector();
        jp.setPartMapVector(partMapVector);
        jp.copyAttribute("Status", pt);
        jp.copyAttribute("StatusDetails", pt);
        jp.setPhaseStartTime(pt.getStart());
        JDFResourceLink rl = pt.getLink(0);
        if (rl != null && rl.getAmountPoolAttribute("ActualAmount", null, null, 0) != null) {
            jp.setPhaseAmount(rl.getActualAmount(null));
        }
        JDFMISDetails md = pt.getMISDetails();
        jp.copyElement(md, null);
        VElement modules = pt.getChildElementVector("ModulePhase", null);
        if (modules != null) {
            int mLen = modules.size();
            for (int i = 0; i < mLen; ++i) {
                jp.createModuleStatusFromModulePhase((JDFModulePhase)modules.elementAt(i));
            }
        }
        jp.eraseEmptyAttributes(true);
        return jp;
    }

    @Override
    public String getDeviceID() {
        KElement km;
        String ret;
        if (this.hasAttribute("DeviceID")) {
            return super.getDeviceID();
        }
        JDFDevice d = this.getDevice();
        String string = ret = d == null ? null : d.getDeviceID();
        if (ret == null && (km = this.getParentNode_KElement()) instanceof JDFMessage) {
            ret = ((JDFMessage)km).getSenderID();
        }
        return ret;
    }

    @Override
    public String getDescriptiveName() {
        if (this.hasAttribute("DescriptiveName")) {
            return super.getDescriptiveName();
        }
        JDFDevice d = this.getDevice();
        return d == null ? "" : d.getDescriptiveName();
    }

    public boolean isSamePhase(JDFDeviceInfo lastInfo, boolean bExact) {
        if (lastInfo == null) {
            return false;
        }
        if (!ContainerUtil.equals(this.getDeviceID(), lastInfo.getDeviceID())) {
            return false;
        }
        if (!ContainerUtil.equals((Object)this.getDeviceOperationMode(), (Object)lastInfo.getDeviceOperationMode())) {
            return false;
        }
        if (!ContainerUtil.equals((Object)this.getDeviceStatus(), (Object)lastInfo.getDeviceStatus())) {
            return false;
        }
        if (!ContainerUtil.equals(this.getStatusDetails(), lastInfo.getStatusDetails())) {
            return false;
        }
        int numEmployees = this.numChildElements("Employee", null);
        if (numEmployees != lastInfo.numChildElements("Employee", null)) {
            return false;
        }
        boolean bGood = true;
        for (int i = 0; i < numEmployees && bGood; ++i) {
            JDFEmployee employee = lastInfo.getEmployee(i);
            if (employee == null) continue;
            bGood = bGood && this.getEmployee(i).matches(employee);
        }
        if (!bGood) {
            return false;
        }
        int numJobPhases = this.numChildElements("JobPhase", null);
        if (numJobPhases != lastInfo.numChildElements("JobPhase", null)) {
            return false;
        }
        bGood = numJobPhases == 0;
        for (int i = 0; i < numJobPhases; ++i) {
            bGood = bGood || this.getJobPhase(i).isSamePhase(lastInfo.getJobPhase(i), bExact);
        }
        if (bGood) {
            VString ignore = new VString(new String[]{"Part", "Employee", "JobPhase"});
            VElement childrenIgnoreList = this.getChildrenIgnoreList(ignore, true, null);
            VElement lastchildrenIgnoreList = lastInfo.getChildrenIgnoreList(ignore, true, null);
            if (childrenIgnoreList.size() > 0 || lastchildrenIgnoreList.size() > 0) {
                if (childrenIgnoreList.size() != lastchildrenIgnoreList.size()) {
                    return false;
                }
                for (int i = 0; i < childrenIgnoreList.size(); ++i) {
                    if (childrenIgnoreList.get(i).isEqual(lastchildrenIgnoreList.get(i))) continue;
                    return false;
                }
            }
        }
        return bGood;
    }

    public boolean mergeLastPhase(JDFDeviceInfo lastInfo) {
        if (!this.isSamePhase(lastInfo, false)) {
            return false;
        }
        int numJobPhases = this.numChildElements("JobPhase", null);
        boolean bGood = true;
        for (int i = 0; i < numJobPhases; ++i) {
            bGood = this.getJobPhase(i).mergeLastPhase(lastInfo.getJobPhase(i)) || bGood;
        }
        return bGood;
    }

    public void setDevice(JDFDevice device, boolean bCopy) {
        if (device == null) {
            return;
        }
        this.copyAttribute("DeviceID", device);
        if (bCopy && this.getDevice() == null) {
            this.copyElement(device, null);
        }
    }

    static {
        JDFDeviceInfo.atrInfoTable[0] = new AtrInfoTable("IdleStartTime", 0x33333000L, AttributeInfo.EnumAttributeType.dateTime, null, null);
    }
}

