/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.resource.JDFValue;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;
import org.cip4.jdflib.util.StringUtil;
import org.w3c.dom.DOMException;

public class JDFStringEvaluation
extends JDFEvaluation {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[2];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    public JDFStringEvaluation(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFStringEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFStringEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFStringEvaluation[ --> " + super.toString() + " ]";
    }

    public void setLength(JDFIntegerRange value) {
        this.setAttribute("Length", value.toString());
    }

    public JDFIntegerRange getLengthRange() {
        try {
            return new JDFIntegerRange(this.getAttribute("Length"));
        }
        catch (DataFormatException dfe) {
            throw new JDFException("JDFStringEvaluation.getLengthRange: Attribute LENGTH is not capable to create JDFIntegerRange");
        }
    }

    public void setRegExp(String value) {
        this.setAttribute("RegExp", value);
    }

    public String getRegExp() {
        return this.getAttribute("RegExp");
    }

    public JDFValue getValue(int iSkip) {
        return (JDFValue)this.getElement("Value", "", iSkip);
    }

    public JDFValue appendValue() {
        return (JDFValue)this.appendElement("Value", null);
    }

    public JDFValue appendValueValue(String value) {
        JDFValue v = (JDFValue)this.appendElement("Value", null);
        v.setValue(value);
        return v;
    }

    public void setValueValue(int iSkip, String value) {
        JDFValue e = (JDFValue)this.getCreateElement("Value", null, iSkip);
        e.setValue(value);
    }

    public final String getValueValue(int iSkip) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        if (e == null) {
            return null;
        }
        return e.getValue();
    }

    @Override
    public final boolean fitsValue(String value) {
        return this.fitsLength(value) && this.fitsRegExp(value) && this.fitsValueElem(value);
    }

    private final boolean fitsLength(String str) {
        if (!this.hasAttribute("Length")) {
            int len = str.length();
            return this.getLengthRange().inRange(len);
        }
        return true;
    }

    private final boolean fitsRegExp(String str) {
        if (!this.hasAttribute("RegExp")) {
            return true;
        }
        return StringUtil.matches(str, this.getRegExp());
    }

    private final boolean fitsValueElem(String str) {
        VElement v = this.getChildElementVector("Value", null, null, true, 0, false);
        int siz = v.size();
        if (siz == 0) {
            return true;
        }
        for (int i = 0; i < siz; ++i) {
            String value = this.getValueValue(i);
            if (value.compareTo(str) != 0) continue;
            return true;
        }
        return false;
    }

    static {
        JDFStringEvaluation.atrInfoTable[0] = new AtrInfoTable("Length", 0x33333333L, AttributeInfo.EnumAttributeType.IntegerRange, null, null);
        JDFStringEvaluation.atrInfoTable[1] = new AtrInfoTable("RegExp", 0x33333333L, AttributeInfo.EnumAttributeType.RegExp, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFStringEvaluation.elemInfoTable[0] = new ElemInfoTable("Value", 0x33333333L);
    }
}

