/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.lang.reflect.Array;

public class FastFiFo<x> {
    private final Object[] theArray;
    private int first;
    private int fill;

    public FastFiFo(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("fifo must have positive # elements");
        }
        this.theArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            this.theArray[i] = null;
        }
        this.first = 0;
        this.fill = 0;
    }

    public synchronized x push(x back) {
        int s = this.theArray.length;
        x ret = null;
        if (this.fill == s) {
            ret = this.pop();
        }
        this.theArray[(this.first + this.fill++) % s] = back;
        return ret;
    }

    public synchronized x pop() {
        if (this.fill == 0) {
            return null;
        }
        Object ret = this.theArray[this.first];
        ++this.first;
        this.first %= this.theArray.length;
        --this.fill;
        return (x)ret;
    }

    public x peek(int i) {
        if (i >= this.fill) {
            return null;
        }
        return (x)this.theArray[(this.first + i) % this.theArray.length];
    }

    public synchronized x[] peekArray() {
        if (this.fill == 0) {
            return null;
        }
        Object[] ret = (Object[])Array.newInstance(this.peek(0).getClass(), this.fill);
        for (int i = 0; i < this.fill; ++i) {
            ret[i] = this.peek(i);
        }
        return ret;
    }

    public String toString() {
        return "FastFiFo : fill=" + this.fill + " first=" + this.first + "\n" + this.theArray.toString();
    }

    public int getFill() {
        return this.fill;
    }
}

