/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.core.XMLParser;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.net.IPollDetails;

public class UrlPart
implements IPollDetails {
    private final int rc;
    private InputStream inStream;
    private final String contentType;
    private ByteArrayIOStream bufferStream;
    public long contentLength;
    private final HttpURLConnection connection;

    @Override
    public int getResponseCode() {
        return this.rc;
    }

    public UrlPart(HttpURLConnection connection) throws IOException {
        this.rc = connection.getResponseCode();
        this.connection = connection;
        this.contentType = connection.getContentType();
        this.contentLength = connection.getContentLength();
        try {
            this.inStream = connection.getInputStream();
        }
        catch (IOException x) {
            this.inStream = null;
        }
        if (this.inStream == null) {
            this.inStream = connection.getErrorStream();
        }
        this.bufferStream = null;
    }

    public UrlPart(BodyPart part) throws MessagingException, IOException {
        this.inStream = part.getInputStream();
        this.contentLength = part.getSize();
        this.contentType = part.getContentType();
        this.connection = null;
        this.bufferStream = null;
        this.rc = 200;
    }

    public UrlPart(File f) throws IOException {
        this.inStream = FileUtil.getBufferedInputStream(f);
        if (f == null) {
            this.contentLength = 0L;
            this.contentType = null;
        } else {
            this.contentLength = f.length();
            this.contentType = UrlUtil.getMimeTypeFromURL(f.getName());
        }
        this.connection = null;
        this.rc = f == null ? 500 : 200;
        this.bufferStream = null;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setInStream(InputStream inStream) {
        this.inStream = inStream;
        this.bufferStream = null;
    }

    @Override
    public InputStream getResponseStream() {
        return this.bufferStream == null ? this.inStream : this.bufferStream.getInputStream();
    }

    public XMLDoc getXMLDoc() {
        XMLParser p = new XMLParser();
        XMLDoc d = p.parseStream(this.getResponseStream());
        return d;
    }

    public void buffer() {
        if (this.bufferStream == null) {
            this.bufferStream = new ByteArrayIOStream(this.inStream);
        }
    }

    public String toString() {
        return "URLPart: " + this.contentType + " length=" + this.contentLength + " rc=" + this.rc + "\n" + (this.bufferStream == null ? " <not buffered>" : this.bufferStream);
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }
}

