/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.net;

import java.io.InputStream;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.thread.WaitTimeout;

public class UrlCheck {
    private String method;
    private final String url;
    private UrlWait wait;
    private InputStream stream;

    public UrlCheck(String url) {
        this(url, "HEAD");
    }

    public UrlCheck(String url, String method) {
        this.url = url;
        this.wait = null;
        this.method = method;
        this.stream = null;
    }

    public UrlPart ping(int waitMillis) {
        this.startPing(waitMillis);
        UrlPart p = this.getPing();
        return p;
    }

    public UrlPart getPing() {
        UrlPart p = this.wait == null ? null : (UrlPart)this.wait.getWaitedObject();
        return p;
    }

    public void startPing(int waitMillis) {
        this.wait = new UrlWait(waitMillis);
    }

    public int pingRC(int waitMillis) {
        UrlPart p = this.ping(waitMillis);
        return p == null ? -1 : p.getResponseCode();
    }

    public int getPingRC() {
        UrlPart p = this.getPing();
        return p == null ? -1 : p.getResponseCode();
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
        if (stream != null) {
            this.method = "POST";
        }
    }

    public String toString() {
        return "UrlCheck [method=" + this.method + ", url=" + this.url + ", wait=" + this.wait + "]";
    }

    private class UrlWait
    extends WaitTimeout<UrlPart> {
        UrlWait(int millis) {
            super(millis);
            this.start();
        }

        @Override
        protected UrlPart handle() {
            UrlPart p = UrlUtil.writeToURL(UrlCheck.this.url, UrlCheck.this.stream, UrlCheck.this.method, null, null);
            if (p != null) {
                p.buffer();
            }
            return p;
        }
    }
}

