/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.datatypes.JDFLabColor;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.resource.JDFColorMeasurementConditions;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFColor;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.resource.process.JDFIdentificationField;
import org.cip4.jdflib.resource.process.JDFMediaLayers;
import org.cip4.jdflib.resource.process.JDFTabDimensions;
import org.cip4.jdflib.resource.process.postpress.JDFHoleList;

public abstract class JDFAutoMedia
extends JDFResource {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[50];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoMedia(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoMedia(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoMedia(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return " JDFAutoMedia[  --> " + super.toString() + " ]";
    }

    @Override
    public boolean init() {
        boolean bRet = super.init();
        this.setResourceClass(JDFResource.EnumResourceClass.Consumable);
        return bRet;
    }

    @Override
    public JDFResource.EnumResourceClass getValidClass() {
        return JDFResource.EnumResourceClass.Consumable;
    }

    public void setHoleType(Vector<? extends ValuedEnum> v) {
        this.setEnumerationsAttribute("HoleType", v, null);
    }

    public Vector<? extends ValuedEnum> getHoleType() {
        return this.getEnumerationsAttribute("HoleType", null, EnumHoleType.None, false);
    }

    public void setMediaUnit(EnumMediaUnit enumVar) {
        this.setAttribute("MediaUnit", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumMediaUnit getMediaUnit() {
        return EnumMediaUnit.getEnum(this.getAttribute("MediaUnit", null, "Sheet"));
    }

    public void setPrePrinted(boolean value) {
        this.setAttribute("PrePrinted", value, null);
    }

    public boolean getPrePrinted() {
        return this.getBoolAttribute("PrePrinted", null, false);
    }

    public void setBackBrightness(double value) {
        this.setAttribute("BackBrightness", value, null);
    }

    public double getBackBrightness() {
        return this.getRealAttribute("BackBrightness", null, 0.0);
    }

    public void setBackCoatingDetail(String value) {
        this.setAttribute("BackCoatingDetail", value, null);
    }

    public String getBackCoatingDetail() {
        return this.getAttribute("BackCoatingDetail", null, "");
    }

    public void setBackCoatings(EnumBackCoatings enumVar) {
        this.setAttribute("BackCoatings", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumBackCoatings getBackCoatings() {
        return EnumBackCoatings.getEnum(this.getAttribute("BackCoatings", null, null));
    }

    public void setBackGlossValue(double value) {
        this.setAttribute("BackGlossValue", value, null);
    }

    public double getBackGlossValue() {
        return this.getRealAttribute("BackGlossValue", null, 0.0);
    }

    public void setBrightness(double value) {
        this.setAttribute("Brightness", value, null);
    }

    public double getBrightness() {
        return this.getRealAttribute("Brightness", null, 0.0);
    }

    public void setCIETint(double value) {
        this.setAttribute("CIETint", value, null);
    }

    public double getCIETint() {
        return this.getRealAttribute("CIETint", null, 0.0);
    }

    public void setCIEWhiteness(double value) {
        this.setAttribute("CIEWhiteness", value, null);
    }

    public double getCIEWhiteness() {
        return this.getRealAttribute("CIEWhiteness", null, 0.0);
    }

    public void setColorName(String value) {
        this.setAttribute("ColorName", value, null);
    }

    public String getColorName() {
        return this.getAttribute("ColorName", null, "");
    }

    public void setCoreWeight(double value) {
        this.setAttribute("CoreWeight", value, null);
    }

    public double getCoreWeight() {
        return this.getRealAttribute("CoreWeight", null, 0.0);
    }

    public void setDimension(JDFXYPair value) {
        this.setAttribute("Dimension", value, null);
    }

    public JDFXYPair getDimension() {
        String strAttrName = this.getAttribute("Dimension", null, null);
        JDFXYPair nPlaceHolder = JDFXYPair.createXYPair(strAttrName);
        return nPlaceHolder;
    }

    public void setFlute(String value) {
        this.setAttribute("Flute", value, null);
    }

    public String getFlute() {
        return this.getAttribute("Flute", null, "");
    }

    public void setFluteDirection(EnumFluteDirection enumVar) {
        this.setAttribute("FluteDirection", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumFluteDirection getFluteDirection() {
        return EnumFluteDirection.getEnum(this.getAttribute("FluteDirection", null, null));
    }

    public void setFrontCoatingDetail(String value) {
        this.setAttribute("FrontCoatingDetail", value, null);
    }

    public String getFrontCoatingDetail() {
        return this.getAttribute("FrontCoatingDetail", null, "");
    }

    public void setFrontCoatings(EnumFrontCoatings enumVar) {
        this.setAttribute("FrontCoatings", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumFrontCoatings getFrontCoatings() {
        return EnumFrontCoatings.getEnum(this.getAttribute("FrontCoatings", null, null));
    }

    public void setFrontGlossValue(double value) {
        this.setAttribute("FrontGlossValue", value, null);
    }

    public double getFrontGlossValue() {
        return this.getRealAttribute("FrontGlossValue", null, 0.0);
    }

    public void setGrade(int value) {
        this.setAttribute("Grade", value, (String)null);
    }

    public int getGrade() {
        return this.getIntAttribute("Grade", null, 0);
    }

    public void setGrainDirection(EnumGrainDirection enumVar) {
        this.setAttribute("GrainDirection", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumGrainDirection getGrainDirection() {
        return EnumGrainDirection.getEnum(this.getAttribute("GrainDirection", null, null));
    }

    public void setHoleCount(int value) {
        this.setAttribute("HoleCount", value, (String)null);
    }

    public int getHoleCount() {
        return this.getIntAttribute("HoleCount", null, 0);
    }

    public void setImagableSide(EnumImagableSide enumVar) {
        this.setAttribute("ImagableSide", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumImagableSide getImagableSide() {
        return EnumImagableSide.getEnum(this.getAttribute("ImagableSide", null, null));
    }

    public void setInsideLoss(double value) {
        this.setAttribute("InsideLoss", value, null);
    }

    public double getInsideLoss() {
        return this.getRealAttribute("InsideLoss", null, 0.0);
    }

    public void setISOPaperSubstrate(EnumISOPaperSubstrate enumVar) {
        this.setAttribute("ISOPaperSubstrate", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumISOPaperSubstrate getISOPaperSubstrate() {
        return EnumISOPaperSubstrate.getEnum(this.getAttribute("ISOPaperSubstrate", null, null));
    }

    public void setLabColorValue(JDFLabColor value) {
        this.setAttribute("LabColorValue", value, null);
    }

    public JDFLabColor getLabColorValue() {
        String strAttrName = this.getAttribute("LabColorValue", null, null);
        JDFLabColor nPlaceHolder = JDFLabColor.createLabColor(strAttrName);
        return nPlaceHolder;
    }

    public void setMediaColorName(JDFElement.EnumNamedColor value) {
        this.setAttribute("MediaColorName", value == null ? null : value.getName(), null);
    }

    public JDFElement.EnumNamedColor getMediaColorName() {
        String strAttrName = "";
        JDFElement.EnumNamedColor nPlaceHolder = null;
        strAttrName = this.getAttribute("MediaColorName", null, "");
        nPlaceHolder = JDFElement.EnumNamedColor.getEnum(strAttrName);
        return nPlaceHolder;
    }

    public void setMediaColorNameDetails(String value) {
        this.setAttribute("MediaColorNameDetails", value, null);
    }

    public String getMediaColorNameDetails() {
        return this.getAttribute("MediaColorNameDetails", null, "");
    }

    public void setMediaQuality(String value) {
        this.setAttribute("MediaQuality", value, null);
    }

    public String getMediaQuality() {
        return this.getAttribute("MediaQuality", null, "");
    }

    public void setMediaSetCount(int value) {
        this.setAttribute("MediaSetCount", value, (String)null);
    }

    public int getMediaSetCount() {
        return this.getIntAttribute("MediaSetCount", null, 0);
    }

    public void setMediaType(EnumMediaType enumVar) {
        this.setAttribute("MediaType", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumMediaType getMediaType() {
        return EnumMediaType.getEnum(this.getAttribute("MediaType", null, null));
    }

    public void setMediaTypeDetails(String value) {
        this.setAttribute("MediaTypeDetails", value, null);
    }

    public String getMediaTypeDetails() {
        return this.getAttribute("MediaTypeDetails", null, "");
    }

    public void setOpacity(EnumOpacity enumVar) {
        this.setAttribute("Opacity", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumOpacity getOpacity() {
        return EnumOpacity.getEnum(this.getAttribute("Opacity", null, null));
    }

    public void setOpacityLevel(double value) {
        this.setAttribute("OpacityLevel", value, null);
    }

    public double getOpacityLevel() {
        return this.getRealAttribute("OpacityLevel", null, 0.0);
    }

    public void setOuterCoreDiameter(double value) {
        this.setAttribute("OuterCoreDiameter", value, null);
    }

    public double getOuterCoreDiameter() {
        return this.getRealAttribute("OuterCoreDiameter", null, 0.0);
    }

    public void setOutsideGain(double value) {
        this.setAttribute("OutsideGain", value, null);
    }

    public double getOutsideGain() {
        return this.getRealAttribute("OutsideGain", null, 0.0);
    }

    public void setPlateTechnology(EnumPlateTechnology enumVar) {
        this.setAttribute("PlateTechnology", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumPlateTechnology getPlateTechnology() {
        return EnumPlateTechnology.getEnum(this.getAttribute("PlateTechnology", null, null));
    }

    public void setPolarity(EnumPolarity enumVar) {
        this.setAttribute("Polarity", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumPolarity getPolarity() {
        return EnumPolarity.getEnum(this.getAttribute("Polarity", null, null));
    }

    public void setPrintingTechnology(String value) {
        this.setAttribute("PrintingTechnology", value, null);
    }

    public String getPrintingTechnology() {
        return this.getAttribute("PrintingTechnology", null, "");
    }

    public void setRecycled(boolean value) {
        this.setAttribute("Recycled", value, null);
    }

    public boolean getRecycled() {
        return this.getBoolAttribute("Recycled", null, false);
    }

    public void setRecycledPercentage(double value) {
        this.setAttribute("RecycledPercentage", value, null);
    }

    public double getRecycledPercentage() {
        return this.getRealAttribute("RecycledPercentage", null, 0.0);
    }

    public void setReliefThickness(double value) {
        this.setAttribute("ReliefThickness", value, null);
    }

    public double getReliefThickness() {
        return this.getRealAttribute("ReliefThickness", null, 0.0);
    }

    public void setRollDiameter(double value) {
        this.setAttribute("RollDiameter", value, null);
    }

    public double getRollDiameter() {
        return this.getRealAttribute("RollDiameter", null, 0.0);
    }

    public void setShrinkIndex(JDFXYPair value) {
        this.setAttribute("ShrinkIndex", value, null);
    }

    public JDFXYPair getShrinkIndex() {
        String strAttrName = this.getAttribute("ShrinkIndex", null, null);
        JDFXYPair nPlaceHolder = JDFXYPair.createXYPair(strAttrName);
        return nPlaceHolder;
    }

    public void setSleeveInterlock(String value) {
        this.setAttribute("SleeveInterlock", value, null);
    }

    public String getSleeveInterlock() {
        return this.getAttribute("SleeveInterlock", null, "");
    }

    public void setStockType(String value) {
        this.setAttribute("StockType", value, null);
    }

    public String getStockType() {
        return this.getAttribute("StockType", null, "");
    }

    public void setTexture(String value) {
        this.setAttribute("Texture", value, null);
    }

    public String getTexture() {
        return this.getAttribute("Texture", null, "");
    }

    public void setThickness(double value) {
        this.setAttribute("Thickness", value, null);
    }

    public double getThickness() {
        return this.getRealAttribute("Thickness", null, 0.0);
    }

    public void setUserMediaType(String value) {
        this.setAttribute("UserMediaType", value, null);
    }

    public String getUserMediaType() {
        return this.getAttribute("UserMediaType", null, "");
    }

    public void setWeight(double value) {
        this.setAttribute("Weight", value, null);
    }

    public double getWeight() {
        return this.getRealAttribute("Weight", null, 0.0);
    }

    public void setWrapperWeight(double value) {
        this.setAttribute("WrapperWeight", value, null);
    }

    public double getWrapperWeight() {
        return this.getRealAttribute("WrapperWeight", null, 0.0);
    }

    public JDFColor getColor() {
        return (JDFColor)this.getElement("Color", null, 0);
    }

    public JDFColor getCreateColor() {
        return (JDFColor)this.getCreateElement_KElement("Color", null, 0);
    }

    public JDFColor appendColor() throws JDFException {
        return (JDFColor)this.appendElementN("Color", 1, null);
    }

    public void refColor(JDFColor refTarget) {
        this.refElement(refTarget);
    }

    public JDFColorMeasurementConditions getColorMeasurementConditions() {
        return (JDFColorMeasurementConditions)this.getElement("ColorMeasurementConditions", null, 0);
    }

    public JDFColorMeasurementConditions getCreateColorMeasurementConditions() {
        return (JDFColorMeasurementConditions)this.getCreateElement_KElement("ColorMeasurementConditions", null, 0);
    }

    public JDFColorMeasurementConditions appendColorMeasurementConditions() throws JDFException {
        return (JDFColorMeasurementConditions)this.appendElementN("ColorMeasurementConditions", 1, null);
    }

    public void refColorMeasurementConditions(JDFColorMeasurementConditions refTarget) {
        this.refElement(refTarget);
    }

    public JDFMediaLayers getMediaLayers() {
        return (JDFMediaLayers)this.getElement("MediaLayers", null, 0);
    }

    public JDFMediaLayers getCreateMediaLayers() {
        return (JDFMediaLayers)this.getCreateElement_KElement("MediaLayers", null, 0);
    }

    public JDFMediaLayers appendMediaLayers() throws JDFException {
        return (JDFMediaLayers)this.appendElementN("MediaLayers", 1, null);
    }

    public JDFHoleList getHoleList() {
        return (JDFHoleList)this.getElement("HoleList", null, 0);
    }

    public JDFHoleList getCreateHoleList() {
        return (JDFHoleList)this.getCreateElement_KElement("HoleList", null, 0);
    }

    public JDFHoleList appendHoleList() throws JDFException {
        return (JDFHoleList)this.appendElementN("HoleList", 1, null);
    }

    public JDFTabDimensions getCreateTabDimensions(int iSkip) {
        return (JDFTabDimensions)this.getCreateElement_KElement("TabDimensions", null, iSkip);
    }

    public JDFTabDimensions getTabDimensions(int iSkip) {
        return (JDFTabDimensions)this.getElement("TabDimensions", null, iSkip);
    }

    public Collection<JDFTabDimensions> getAllTabDimensions() {
        return this.getChildrenByClass(JDFTabDimensions.class, false, 0);
    }

    public JDFTabDimensions appendTabDimensions() {
        return (JDFTabDimensions)this.appendElement("TabDimensions", null);
    }

    public JDFContact getCreateContact(int iSkip) {
        return (JDFContact)this.getCreateElement_KElement("Contact", null, iSkip);
    }

    public JDFContact getContact(int iSkip) {
        return (JDFContact)this.getElement("Contact", null, iSkip);
    }

    public Collection<JDFContact> getAllContact() {
        return this.getChildrenByClass(JDFContact.class, false, 0);
    }

    @Override
    public JDFContact appendContact() {
        return (JDFContact)this.appendElement("Contact", null);
    }

    public void refContact(JDFContact refTarget) {
        this.refElement(refTarget);
    }

    @Override
    public JDFIdentificationField getCreateIdentificationField(int iSkip) {
        return (JDFIdentificationField)this.getCreateElement_KElement("IdentificationField", null, iSkip);
    }

    @Override
    public JDFIdentificationField getIdentificationField(int iSkip) {
        return (JDFIdentificationField)this.getElement("IdentificationField", null, iSkip);
    }

    public Collection<JDFIdentificationField> getAllIdentificationField() {
        return this.getChildrenByClass(JDFIdentificationField.class, false, 0);
    }

    @Override
    public JDFIdentificationField appendIdentificationField() {
        return (JDFIdentificationField)this.appendElement("IdentificationField", null);
    }

    public void refIdentificationField(JDFIdentificationField refTarget) {
        this.refElement(refTarget);
    }

    static {
        JDFAutoMedia.atrInfoTable[0] = new AtrInfoTable("HoleType", 0x33333331L, AttributeInfo.EnumAttributeType.enumerations, EnumHoleType.getEnum(0), "None");
        JDFAutoMedia.atrInfoTable[1] = new AtrInfoTable("MediaUnit", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumMediaUnit.getEnum(0), "Sheet");
        JDFAutoMedia.atrInfoTable[2] = new AtrInfoTable("PrePrinted", 0x33333333L, AttributeInfo.EnumAttributeType.boolean_, null, "false");
        JDFAutoMedia.atrInfoTable[3] = new AtrInfoTable("BackBrightness", 0x33311111L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[4] = new AtrInfoTable("BackCoatingDetail", 0x33331111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoMedia.atrInfoTable[5] = new AtrInfoTable("BackCoatings", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumBackCoatings.getEnum(0), null);
        JDFAutoMedia.atrInfoTable[6] = new AtrInfoTable("BackGlossValue", 0x33333311L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[7] = new AtrInfoTable("Brightness", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[8] = new AtrInfoTable("CIETint", 0x33333311L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[9] = new AtrInfoTable("CIEWhiteness", 0x33333311L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[10] = new AtrInfoTable("ColorName", 0x44444431L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoMedia.atrInfoTable[11] = new AtrInfoTable("CoreWeight", 0x33333111L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[12] = new AtrInfoTable("Dimension", 0x33333333L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFAutoMedia.atrInfoTable[13] = new AtrInfoTable("Flute", 0x33333111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoMedia.atrInfoTable[14] = new AtrInfoTable("FluteDirection", 0x33333111L, AttributeInfo.EnumAttributeType.enumeration, EnumFluteDirection.getEnum(0), null);
        JDFAutoMedia.atrInfoTable[15] = new AtrInfoTable("FrontCoatingDetail", 0x33331111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoMedia.atrInfoTable[16] = new AtrInfoTable("FrontCoatings", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumFrontCoatings.getEnum(0), null);
        JDFAutoMedia.atrInfoTable[17] = new AtrInfoTable("FrontGlossValue", 0x33333311L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[18] = new AtrInfoTable("Grade", 0x33333333L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoMedia.atrInfoTable[19] = new AtrInfoTable("GrainDirection", 0x33333331L, AttributeInfo.EnumAttributeType.enumeration, EnumGrainDirection.getEnum(0), null);
        JDFAutoMedia.atrInfoTable[20] = new AtrInfoTable("HoleCount", 0x44444443L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoMedia.atrInfoTable[21] = new AtrInfoTable("ImagableSide", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumImagableSide.getEnum(0), null);
        JDFAutoMedia.atrInfoTable[22] = new AtrInfoTable("InsideLoss", 0x33333111L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[23] = new AtrInfoTable("ISOPaperSubstrate", 0x33311111L, AttributeInfo.EnumAttributeType.enumeration, EnumISOPaperSubstrate.getEnum(0), null);
        JDFAutoMedia.atrInfoTable[24] = new AtrInfoTable("LabColorValue", 0x33333311L, AttributeInfo.EnumAttributeType.LabColor, null, null);
        JDFAutoMedia.atrInfoTable[25] = new AtrInfoTable("MediaColorName", 0x33333333L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoMedia.atrInfoTable[26] = new AtrInfoTable("MediaColorNameDetails", 0x33333311L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoMedia.atrInfoTable[27] = new AtrInfoTable("MediaQuality", 0x33331111L, AttributeInfo.EnumAttributeType.string, null, null);
        JDFAutoMedia.atrInfoTable[28] = new AtrInfoTable("MediaSetCount", 0x33333333L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoMedia.atrInfoTable[29] = new AtrInfoTable("MediaType", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumMediaType.getEnum(0), null);
        JDFAutoMedia.atrInfoTable[30] = new AtrInfoTable("MediaTypeDetails", 0x33333333L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoMedia.atrInfoTable[31] = new AtrInfoTable("Opacity", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumOpacity.getEnum(0), null);
        JDFAutoMedia.atrInfoTable[32] = new AtrInfoTable("OpacityLevel", 0x33333311L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[33] = new AtrInfoTable("OuterCoreDiameter", 0x33333111L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[34] = new AtrInfoTable("OutsideGain", 0x33333111L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[35] = new AtrInfoTable("PlateTechnology", 0x33333111L, AttributeInfo.EnumAttributeType.enumeration, EnumPlateTechnology.getEnum(0), null);
        JDFAutoMedia.atrInfoTable[36] = new AtrInfoTable("Polarity", 0x33333333L, AttributeInfo.EnumAttributeType.enumeration, EnumPolarity.getEnum(0), null);
        JDFAutoMedia.atrInfoTable[37] = new AtrInfoTable("PrintingTechnology", 0x33331111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoMedia.atrInfoTable[38] = new AtrInfoTable("Recycled", 0x44444433L, AttributeInfo.EnumAttributeType.boolean_, null, null);
        JDFAutoMedia.atrInfoTable[39] = new AtrInfoTable("RecycledPercentage", 0x33333311L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[40] = new AtrInfoTable("ReliefThickness", 0x33331111L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[41] = new AtrInfoTable("RollDiameter", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[42] = new AtrInfoTable("ShrinkIndex", 0x33333331L, AttributeInfo.EnumAttributeType.XYPair, null, null);
        JDFAutoMedia.atrInfoTable[43] = new AtrInfoTable("SleeveInterlock", 0x33331111L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoMedia.atrInfoTable[44] = new AtrInfoTable("StockType", 0x33333331L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoMedia.atrInfoTable[45] = new AtrInfoTable("Texture", 0x33333331L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoMedia.atrInfoTable[46] = new AtrInfoTable("Thickness", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[47] = new AtrInfoTable("UserMediaType", 0x44444443L, AttributeInfo.EnumAttributeType.NMTOKEN, null, null);
        JDFAutoMedia.atrInfoTable[48] = new AtrInfoTable("Weight", 0x33333333L, AttributeInfo.EnumAttributeType.double_, null, null);
        JDFAutoMedia.atrInfoTable[49] = new AtrInfoTable("WrapperWeight", 0x33333111L, AttributeInfo.EnumAttributeType.double_, null, null);
        elemInfoTable = new ElemInfoTable[7];
        JDFAutoMedia.elemInfoTable[0] = new ElemInfoTable("Color", 0x77777776L);
        JDFAutoMedia.elemInfoTable[1] = new ElemInfoTable("ColorMeasurementConditions", 0x66666611L);
        JDFAutoMedia.elemInfoTable[2] = new ElemInfoTable("MediaLayers", 0x66666111L);
        JDFAutoMedia.elemInfoTable[3] = new ElemInfoTable("HoleList", 0x66666611L);
        JDFAutoMedia.elemInfoTable[4] = new ElemInfoTable("TabDimensions", 0x33333333L);
        JDFAutoMedia.elemInfoTable[5] = new ElemInfoTable("Contact", 0x33333333L);
        JDFAutoMedia.elemInfoTable[6] = new ElemInfoTable("IdentificationField", 0x33333333L);
    }

    public static class EnumPolarity
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumPolarity Positive = new EnumPolarity("Positive");
        public static final EnumPolarity Negative = new EnumPolarity("Negative");

        private EnumPolarity(String name) {
            super(name, m_startValue++);
        }

        public static EnumPolarity getEnum(String enumName) {
            return (EnumPolarity)EnumPolarity.getEnum(EnumPolarity.class, (String)enumName);
        }

        public static EnumPolarity getEnum(int enumValue) {
            return (EnumPolarity)EnumPolarity.getEnum(EnumPolarity.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumPolarity.getEnumMap(EnumPolarity.class);
        }

        public static List getEnumList() {
            return EnumPolarity.getEnumList(EnumPolarity.class);
        }

        public static Iterator iterator() {
            return EnumPolarity.iterator(EnumPolarity.class);
        }
    }

    public static class EnumPlateTechnology
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumPlateTechnology FlexoAnalogSolvent = new EnumPlateTechnology("FlexoAnalogSolvent");
        public static final EnumPlateTechnology FlexoAnalogThermal = new EnumPlateTechnology("FlexoAnalogThermal");
        public static final EnumPlateTechnology FlexoDigitalSolvent = new EnumPlateTechnology("FlexoDigitalSolvent");
        public static final EnumPlateTechnology FlexoDigitalThermal = new EnumPlateTechnology("FlexoDigitalThermal");
        public static final EnumPlateTechnology FlexoDirectEngraving = new EnumPlateTechnology("FlexoDirectEngraving");
        public static final EnumPlateTechnology InkJet = new EnumPlateTechnology("InkJet");
        public static final EnumPlateTechnology Thermal = new EnumPlateTechnology("Thermal");
        public static final EnumPlateTechnology UV = new EnumPlateTechnology("UV");
        public static final EnumPlateTechnology Visible = new EnumPlateTechnology("Visible");

        private EnumPlateTechnology(String name) {
            super(name, m_startValue++);
        }

        public static EnumPlateTechnology getEnum(String enumName) {
            return (EnumPlateTechnology)EnumPlateTechnology.getEnum(EnumPlateTechnology.class, (String)enumName);
        }

        public static EnumPlateTechnology getEnum(int enumValue) {
            return (EnumPlateTechnology)EnumPlateTechnology.getEnum(EnumPlateTechnology.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumPlateTechnology.getEnumMap(EnumPlateTechnology.class);
        }

        public static List getEnumList() {
            return EnumPlateTechnology.getEnumList(EnumPlateTechnology.class);
        }

        public static Iterator iterator() {
            return EnumPlateTechnology.iterator(EnumPlateTechnology.class);
        }
    }

    public static class EnumOpacity
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumOpacity Opaque = new EnumOpacity("Opaque");
        public static final EnumOpacity Translucent = new EnumOpacity("Translucent");
        public static final EnumOpacity Transparent = new EnumOpacity("Transparent");

        private EnumOpacity(String name) {
            super(name, m_startValue++);
        }

        public static EnumOpacity getEnum(String enumName) {
            return (EnumOpacity)EnumOpacity.getEnum(EnumOpacity.class, (String)enumName);
        }

        public static EnumOpacity getEnum(int enumValue) {
            return (EnumOpacity)EnumOpacity.getEnum(EnumOpacity.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumOpacity.getEnumMap(EnumOpacity.class);
        }

        public static List getEnumList() {
            return EnumOpacity.getEnumList(EnumOpacity.class);
        }

        public static Iterator iterator() {
            return EnumOpacity.iterator(EnumOpacity.class);
        }
    }

    public static class EnumMediaType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumMediaType CorrugatedBoard = new EnumMediaType("CorrugatedBoard");
        public static final EnumMediaType Disc = new EnumMediaType("Disc");
        public static final EnumMediaType EndBoard = new EnumMediaType("EndBoard");
        public static final EnumMediaType EmbossingFoil = new EnumMediaType("EmbossingFoil");
        public static final EnumMediaType Film = new EnumMediaType("Film");
        public static final EnumMediaType Foil = new EnumMediaType("Foil");
        public static final EnumMediaType GravureCylinder = new EnumMediaType("GravureCylinder");
        public static final EnumMediaType ImagingCylinder = new EnumMediaType("ImagingCylinder");
        public static final EnumMediaType LaminatingFoil = new EnumMediaType("LaminatingFoil");
        public static final EnumMediaType MountingTape = new EnumMediaType("MountingTape");
        public static final EnumMediaType Other = new EnumMediaType("Other");
        public static final EnumMediaType Paper = new EnumMediaType("Paper");
        public static final EnumMediaType Plate = new EnumMediaType("Plate");
        public static final EnumMediaType Screen = new EnumMediaType("Screen");
        public static final EnumMediaType SelfAdhesive = new EnumMediaType("SelfAdhesive");
        public static final EnumMediaType Sleeve = new EnumMediaType("Sleeve");
        public static final EnumMediaType ShrinkFoil = new EnumMediaType("ShrinkFoil");
        public static final EnumMediaType Textile = new EnumMediaType("Textile");
        public static final EnumMediaType Transparency = new EnumMediaType("Transparency");
        public static final EnumMediaType Unknown = new EnumMediaType("Unknown");
        public static final EnumMediaType Vinyl = new EnumMediaType("Vinyl");

        private EnumMediaType(String name) {
            super(name, m_startValue++);
        }

        public static EnumMediaType getEnum(String enumName) {
            return (EnumMediaType)EnumMediaType.getEnum(EnumMediaType.class, (String)enumName);
        }

        public static EnumMediaType getEnum(int enumValue) {
            return (EnumMediaType)EnumMediaType.getEnum(EnumMediaType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumMediaType.getEnumMap(EnumMediaType.class);
        }

        public static List getEnumList() {
            return EnumMediaType.getEnumList(EnumMediaType.class);
        }

        public static Iterator iterator() {
            return EnumMediaType.iterator(EnumMediaType.class);
        }
    }

    public static class EnumISOPaperSubstrate
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumISOPaperSubstrate PS1 = new EnumISOPaperSubstrate("PS1");
        public static final EnumISOPaperSubstrate PS2 = new EnumISOPaperSubstrate("PS2");
        public static final EnumISOPaperSubstrate PS3 = new EnumISOPaperSubstrate("PS3");
        public static final EnumISOPaperSubstrate PS4 = new EnumISOPaperSubstrate("PS4");
        public static final EnumISOPaperSubstrate PS5 = new EnumISOPaperSubstrate("PS5");
        public static final EnumISOPaperSubstrate PS6 = new EnumISOPaperSubstrate("PS6");
        public static final EnumISOPaperSubstrate PS7 = new EnumISOPaperSubstrate("PS7");
        public static final EnumISOPaperSubstrate PS8 = new EnumISOPaperSubstrate("PS8");

        private EnumISOPaperSubstrate(String name) {
            super(name, m_startValue++);
        }

        public static EnumISOPaperSubstrate getEnum(String enumName) {
            return (EnumISOPaperSubstrate)EnumISOPaperSubstrate.getEnum(EnumISOPaperSubstrate.class, (String)enumName);
        }

        public static EnumISOPaperSubstrate getEnum(int enumValue) {
            return (EnumISOPaperSubstrate)EnumISOPaperSubstrate.getEnum(EnumISOPaperSubstrate.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumISOPaperSubstrate.getEnumMap(EnumISOPaperSubstrate.class);
        }

        public static List getEnumList() {
            return EnumISOPaperSubstrate.getEnumList(EnumISOPaperSubstrate.class);
        }

        public static Iterator iterator() {
            return EnumISOPaperSubstrate.iterator(EnumISOPaperSubstrate.class);
        }
    }

    public static class EnumImagableSide
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumImagableSide Front = new EnumImagableSide("Front");
        public static final EnumImagableSide Back = new EnumImagableSide("Back");
        public static final EnumImagableSide Both = new EnumImagableSide("Both");
        public static final EnumImagableSide Neither = new EnumImagableSide("Neither");

        private EnumImagableSide(String name) {
            super(name, m_startValue++);
        }

        public static EnumImagableSide getEnum(String enumName) {
            return (EnumImagableSide)EnumImagableSide.getEnum(EnumImagableSide.class, (String)enumName);
        }

        public static EnumImagableSide getEnum(int enumValue) {
            return (EnumImagableSide)EnumImagableSide.getEnum(EnumImagableSide.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumImagableSide.getEnumMap(EnumImagableSide.class);
        }

        public static List getEnumList() {
            return EnumImagableSide.getEnumList(EnumImagableSide.class);
        }

        public static Iterator iterator() {
            return EnumImagableSide.iterator(EnumImagableSide.class);
        }
    }

    public static class EnumGrainDirection
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumGrainDirection LongEdge = new EnumGrainDirection("LongEdge");
        public static final EnumGrainDirection ShortEdge = new EnumGrainDirection("ShortEdge");
        public static final EnumGrainDirection XDirection = new EnumGrainDirection("XDirection");
        public static final EnumGrainDirection YDirection = new EnumGrainDirection("YDirection");

        private EnumGrainDirection(String name) {
            super(name, m_startValue++);
        }

        public static EnumGrainDirection getEnum(String enumName) {
            return (EnumGrainDirection)EnumGrainDirection.getEnum(EnumGrainDirection.class, (String)enumName);
        }

        public static EnumGrainDirection getEnum(int enumValue) {
            return (EnumGrainDirection)EnumGrainDirection.getEnum(EnumGrainDirection.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumGrainDirection.getEnumMap(EnumGrainDirection.class);
        }

        public static List getEnumList() {
            return EnumGrainDirection.getEnumList(EnumGrainDirection.class);
        }

        public static Iterator iterator() {
            return EnumGrainDirection.iterator(EnumGrainDirection.class);
        }
    }

    public static class EnumFrontCoatings
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumFrontCoatings None = new EnumFrontCoatings("None");
        public static final EnumFrontCoatings Coated = new EnumFrontCoatings("Coated");
        public static final EnumFrontCoatings Glossy = new EnumFrontCoatings("Glossy");
        public static final EnumFrontCoatings HighGloss = new EnumFrontCoatings("HighGloss");
        public static final EnumFrontCoatings InkJet = new EnumFrontCoatings("InkJet");
        public static final EnumFrontCoatings Matte = new EnumFrontCoatings("Matte");
        public static final EnumFrontCoatings Polymer = new EnumFrontCoatings("Polymer");
        public static final EnumFrontCoatings Silver = new EnumFrontCoatings("Silver");
        public static final EnumFrontCoatings Satin = new EnumFrontCoatings("Satin");
        public static final EnumFrontCoatings Semigloss = new EnumFrontCoatings("Semigloss");

        private EnumFrontCoatings(String name) {
            super(name, m_startValue++);
        }

        public static EnumFrontCoatings getEnum(String enumName) {
            return (EnumFrontCoatings)EnumFrontCoatings.getEnum(EnumFrontCoatings.class, (String)enumName);
        }

        public static EnumFrontCoatings getEnum(int enumValue) {
            return (EnumFrontCoatings)EnumFrontCoatings.getEnum(EnumFrontCoatings.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumFrontCoatings.getEnumMap(EnumFrontCoatings.class);
        }

        public static List getEnumList() {
            return EnumFrontCoatings.getEnumList(EnumFrontCoatings.class);
        }

        public static Iterator iterator() {
            return EnumFrontCoatings.iterator(EnumFrontCoatings.class);
        }
    }

    public static class EnumFluteDirection
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumFluteDirection LongEdge = new EnumFluteDirection("LongEdge");
        public static final EnumFluteDirection ShortEdge = new EnumFluteDirection("ShortEdge");
        public static final EnumFluteDirection XDirection = new EnumFluteDirection("XDirection");
        public static final EnumFluteDirection YDirection = new EnumFluteDirection("YDirection");

        private EnumFluteDirection(String name) {
            super(name, m_startValue++);
        }

        public static EnumFluteDirection getEnum(String enumName) {
            return (EnumFluteDirection)EnumFluteDirection.getEnum(EnumFluteDirection.class, (String)enumName);
        }

        public static EnumFluteDirection getEnum(int enumValue) {
            return (EnumFluteDirection)EnumFluteDirection.getEnum(EnumFluteDirection.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumFluteDirection.getEnumMap(EnumFluteDirection.class);
        }

        public static List getEnumList() {
            return EnumFluteDirection.getEnumList(EnumFluteDirection.class);
        }

        public static Iterator iterator() {
            return EnumFluteDirection.iterator(EnumFluteDirection.class);
        }
    }

    public static class EnumBackCoatings
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumBackCoatings None = new EnumBackCoatings("None");
        public static final EnumBackCoatings Coated = new EnumBackCoatings("Coated");
        public static final EnumBackCoatings Glossy = new EnumBackCoatings("Glossy");
        public static final EnumBackCoatings HighGloss = new EnumBackCoatings("HighGloss");
        public static final EnumBackCoatings InkJet = new EnumBackCoatings("InkJet");
        public static final EnumBackCoatings Matte = new EnumBackCoatings("Matte");
        public static final EnumBackCoatings Polymer = new EnumBackCoatings("Polymer");
        public static final EnumBackCoatings Silver = new EnumBackCoatings("Silver");
        public static final EnumBackCoatings Satin = new EnumBackCoatings("Satin");
        public static final EnumBackCoatings Semigloss = new EnumBackCoatings("Semigloss");

        private EnumBackCoatings(String name) {
            super(name, m_startValue++);
        }

        public static EnumBackCoatings getEnum(String enumName) {
            return (EnumBackCoatings)EnumBackCoatings.getEnum(EnumBackCoatings.class, (String)enumName);
        }

        public static EnumBackCoatings getEnum(int enumValue) {
            return (EnumBackCoatings)EnumBackCoatings.getEnum(EnumBackCoatings.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumBackCoatings.getEnumMap(EnumBackCoatings.class);
        }

        public static List getEnumList() {
            return EnumBackCoatings.getEnumList(EnumBackCoatings.class);
        }

        public static Iterator iterator() {
            return EnumBackCoatings.iterator(EnumBackCoatings.class);
        }
    }

    public static class EnumMediaUnit
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumMediaUnit Continuous = new EnumMediaUnit("Continuous");
        public static final EnumMediaUnit Roll = new EnumMediaUnit("Roll");
        public static final EnumMediaUnit Sheet = new EnumMediaUnit("Sheet");

        private EnumMediaUnit(String name) {
            super(name, m_startValue++);
        }

        public static EnumMediaUnit getEnum(String enumName) {
            return (EnumMediaUnit)EnumMediaUnit.getEnum(EnumMediaUnit.class, (String)enumName);
        }

        public static EnumMediaUnit getEnum(int enumValue) {
            return (EnumMediaUnit)EnumMediaUnit.getEnum(EnumMediaUnit.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumMediaUnit.getEnumMap(EnumMediaUnit.class);
        }

        public static List getEnumList() {
            return EnumMediaUnit.getEnumList(EnumMediaUnit.class);
        }

        public static Iterator iterator() {
            return EnumMediaUnit.iterator(EnumMediaUnit.class);
        }
    }

    public static class EnumHoleType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumHoleType None = new EnumHoleType("None");
        public static final EnumHoleType S1_generic = new EnumHoleType("S1-generic");
        public static final EnumHoleType S_generic = new EnumHoleType("S-generic");
        public static final EnumHoleType R2_generic = new EnumHoleType("R2-generic");
        public static final EnumHoleType R2m_DIN = new EnumHoleType("R2m-DIN");
        public static final EnumHoleType R2m_ISO = new EnumHoleType("R2m-ISO");
        public static final EnumHoleType R2m_MIB = new EnumHoleType("R2m-MIB");
        public static final EnumHoleType R2i_US_a = new EnumHoleType("R2i-US-a");
        public static final EnumHoleType R2i_US_b = new EnumHoleType("R2i-US-b");
        public static final EnumHoleType R3_generic = new EnumHoleType("R3-generic");
        public static final EnumHoleType R3i_US = new EnumHoleType("R3i-US");
        public static final EnumHoleType R4_generic = new EnumHoleType("R4-generic");
        public static final EnumHoleType R4m_DIN_A4 = new EnumHoleType("R4m-DIN-A4");
        public static final EnumHoleType R4m_DIN_A5 = new EnumHoleType("R4m-DIN-A5");
        public static final EnumHoleType R4m_swedish = new EnumHoleType("R4m-swedish");
        public static final EnumHoleType R4i_US = new EnumHoleType("R4i-US");
        public static final EnumHoleType R5_generic = new EnumHoleType("R5-generic");
        public static final EnumHoleType R5i_US_a = new EnumHoleType("R5i-US-a");
        public static final EnumHoleType R5i_US_b = new EnumHoleType("R5i-US-b");
        public static final EnumHoleType R5i_US_c = new EnumHoleType("R5i-US-c");
        public static final EnumHoleType R6_generic = new EnumHoleType("R6-generic");
        public static final EnumHoleType R6m_4h2s = new EnumHoleType("R6m-4h2s");
        public static final EnumHoleType R6m_DIN_A5 = new EnumHoleType("R6m-DIN-A5");
        public static final EnumHoleType R7_generic = new EnumHoleType("R7-generic");
        public static final EnumHoleType R7i_US_a = new EnumHoleType("R7i-US-a");
        public static final EnumHoleType R7i_US_b = new EnumHoleType("R7i-US-b");
        public static final EnumHoleType R7i_US_c = new EnumHoleType("R7i-US-c");
        public static final EnumHoleType R11m_7h4s = new EnumHoleType("R11m-7h4s");
        public static final EnumHoleType P16_9i_rect_0t = new EnumHoleType("P16_9i-rect-0t");
        public static final EnumHoleType P12m_rect_0t = new EnumHoleType("P12m-rect-0t");
        public static final EnumHoleType W2_1i_round_0t = new EnumHoleType("W2_1i-round-0t");
        public static final EnumHoleType W2_1i_square_0t = new EnumHoleType("W2_1i-square-0t");
        public static final EnumHoleType W3_1i_square_0t = new EnumHoleType("W3_1i-square-0t");
        public static final EnumHoleType C9_5m_round_0t = new EnumHoleType("C9.5m-round-0t");
        public static final EnumHoleType Explicit = new EnumHoleType("Explicit");

        private EnumHoleType(String name) {
            super(name, m_startValue++);
        }

        public static EnumHoleType getEnum(String enumName) {
            return (EnumHoleType)EnumHoleType.getEnum(EnumHoleType.class, (String)enumName);
        }

        public static EnumHoleType getEnum(int enumValue) {
            return (EnumHoleType)EnumHoleType.getEnum(EnumHoleType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumHoleType.getEnumMap(EnumHoleType.class);
        }

        public static List getEnumList() {
            return EnumHoleType.getEnumList(EnumHoleType.class);
        }

        public static Iterator iterator() {
            return EnumHoleType.iterator(EnumHoleType.class);
        }
    }
}

