/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.io.File;
import java.io.InputStream;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.cip4.jdflib.core.DocumentJDFImpl;
import org.cip4.jdflib.core.DocumentXMLImpl;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.core.XMLErrorHandler;
import org.cip4.jdflib.core.XMLParser;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.UrlUtil;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class JDFParser
extends XMLParser {
    public boolean bKElementOnly = false;
    public boolean ignoreNSDefault = false;

    public JDFParser() {
    }

    @Deprecated
    public JDFParser(String strDocType) {
        this();
    }

    public JDFParser(JDFParser parser) {
        this();
        this.bKElementOnly = parser.bKElementOnly;
        this.m_eraseEmpty = parser.m_eraseEmpty;
        this.initParser(this.m_SchemaLocation, (XMLErrorHandler)parser.getErrorHandler());
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.bKElementOnly = false;
    }

    @Override
    public JDFDoc parseFile(String strFile) {
        return (JDFDoc)super.parseFile(strFile);
    }

    @Override
    public JDFDoc parseFile(File file) {
        return (JDFDoc)super.parseFile(file);
    }

    @Deprecated
    public JDFDoc parseFile(String strFile, String schemaLocation) {
        this.m_SchemaLocation = schemaLocation;
        return this.parseFile(strFile);
    }

    @Override
    public JDFDoc parseString(String stringInput) {
        return (JDFDoc)super.parseString(stringInput);
    }

    @Override
    public JDFDoc parseStream(InputStream inStream) {
        return (JDFDoc)super.parseStream(inStream);
    }

    @Deprecated
    public JDFDoc parseInputSource(InputSource inSource, String schemaLocation, String documentClassName, ErrorHandler errorHandler, boolean bEraseEmpty, boolean bDoNamespaces) {
        JDFDoc doc = null;
        if (errorHandler instanceof XMLErrorHandler) {
            this.initParser(schemaLocation, (XMLErrorHandler)errorHandler);
        } else {
            this.initParser(schemaLocation, null);
        }
        doc = (JDFDoc)this.runParser(inSource, bEraseEmpty);
        if (doc == null && !bDoNamespaces) {
            this.setIgnoreNamespace(false);
            doc = (JDFDoc)this.runParser(inSource, bEraseEmpty);
        }
        return doc;
    }

    @Override
    public String getDocumentClass() {
        return DocumentJDFImpl.class.getName();
    }

    public Element createElementNode(QName element) {
        if (this.fCurrentNode.getLocalName() != null) {
            ((DocumentJDFImpl)((Object)this.fDocument)).setParentNode(this.fCurrentNode);
        }
        Element e = super.createElementNode(element);
        ((DocumentJDFImpl)((Object)this.fDocument)).setParentNode(null);
        return e;
    }

    @Override
    protected XMLDoc getXMLDoc() {
        JDFDoc doc = new JDFDoc();
        return doc;
    }

    private void setIgnoreNamespace(boolean toSet) {
        try {
            this.setFeature("http://xml.org/sax/features/namespaces", toSet);
            this.setFeature("http://xml.org/sax/features/validation", toSet);
        }
        catch (SAXNotRecognizedException e) {
            this.m_lastExcept = e;
        }
        catch (SAXNotSupportedException e) {
            this.m_lastExcept = e;
        }
    }

    public void setJDFSchemaLocation(File _schemaLocation) {
        if (_schemaLocation != null && _schemaLocation.length() != 0L) {
            String fileToUrl = UrlUtil.fileToUrl(_schemaLocation, false);
            this.m_SchemaLocation = "http://www.CIP4.org/JDFSchema_1_1 " + fileToUrl;
        }
    }

    @Override
    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, namespaceContext, augs);
        DocumentJDFImpl memberDocument = (DocumentJDFImpl)((Object)this.getDocument());
        memberDocument.bKElementOnly = this.bKElementOnly;
        memberDocument.bInitOnCreate = false;
    }

    @Override
    protected void setDocumentProperties(KElement root, DocumentXMLImpl memberDocument, String namespaceURI) {
        boolean bJDFRoot;
        boolean isXJDF = "XJDF".equals(root.getLocalName()) || JDFElement.getSchemaURL(2, 0).equals(root.getNamespaceURI());
        boolean bl = bJDFRoot = root instanceof JDFNode || root instanceof JDFJMF;
        if (bJDFRoot && !"http://www.CIP4.org/JDFSchema_1_1".equals(namespaceURI) && !isXJDF) {
            root.setAttribute("xmlns", "http://www.CIP4.org/JDFSchema_1_1");
        }
        if (!(bJDFRoot || namespaceURI != null && namespaceURI.toLowerCase().contains(".cip4.org"))) {
            ((DocumentJDFImpl)memberDocument).bKElementOnly = true;
        }
    }

    @Override
    protected final XMLDoc runParser(InputSource inSource, boolean bEraseEmpty) {
        XMLDoc doc = super.runParser(inSource, bEraseEmpty);
        if (doc != null) {
            ((JDFDoc)doc).setInitOnCreate(true);
        }
        return doc;
    }
}

