/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.Iterator;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.util.StringUtil;

class XPathHelper {
    private final KElement theElement;

    XPathHelper(KElement kElement) {
        this.theElement = kElement;
    }

    String copyXPathValue(String dstXPath, KElement src, String srcXPath) {
        if (src == null) {
            src = this.theElement;
        }
        if (srcXPath == null) {
            srcXPath = dstXPath;
        }
        String s = src.getXPathAttribute(srcXPath, null);
        this.setXPathValue(dstXPath, s);
        return s;
    }

    KElement getCreateXPathElement(String path) {
        return new XPathElementCreator().getCreateXPathElement(path);
    }

    String buildXPath(String relativeTo, int methCountSiblings) {
        int iB;
        String path = this.theElement.getNodeName();
        KElement parent = this.theElement.getParentNode_KElement();
        if (methCountSiblings > 0) {
            if (methCountSiblings == 3 && this.theElement.hasAttribute_KElement("ID", null, false)) {
                path = path + "[@ID=\"" + this.theElement.getAttribute("ID") + "\"]";
            } else {
                KElement e = parent != null ? parent.getElement_KElement(path, null, 0) : null;
                int i = 1;
                while (e != null) {
                    if (e == this.theElement) {
                        path = path + "[" + Integer.toString(i) + "]";
                        break;
                    }
                    while ((e = e.getNextSiblingElement()) != null && !e.fitsName_KElement(path, null)) {
                    }
                    ++i;
                }
            }
        }
        path = "/" + path;
        if (parent != null) {
            path = new XPathHelper(parent).buildXPath(relativeTo, methCountSiblings) + path;
        }
        if (relativeTo != null && path.startsWith(relativeTo) && (path = "." + path.substring(relativeTo.length())).startsWith(".[") && (iB = path.indexOf("]")) > 0) {
            path = "." + path.substring(iB + 1);
        }
        return path;
    }

    void setXPathValue(String path, String value) {
        int pos = path.lastIndexOf("@");
        int pos2 = path.lastIndexOf("/");
        if (pos >= 0 && pos > pos2) {
            this.setXPathAttribute(path, value);
        } else {
            VElement vEle = this.getXPathElementVectorInternal(path, -1, true);
            if (vEle == null) {
                vEle = new VElement();
            }
            if (vEle.size() == 0) {
                KElement kEle = this.getCreateXPathElement(path);
                vEle.add(kEle);
            }
            for (int i = 0; i < vEle.size(); ++i) {
                vEle.get(i).setText(value);
            }
        }
    }

    void setXPathValues(JDFAttributeMap map) {
        String xpath;
        if (map == null) {
            return;
        }
        Iterator<String> it = map.getKeyIterator();
        while (it.hasNext()) {
            xpath = it.next();
            if (xpath.indexOf("xmlns") < 0) continue;
            this.setXPathValue(xpath, map.get(xpath));
        }
        it = map.getKeyIterator();
        while (it.hasNext()) {
            xpath = it.next();
            if (xpath.indexOf("xmlns") >= 0) continue;
            this.setXPathValue(xpath, map.get(xpath));
        }
    }

    void setXPathAttribute(String path, String value) {
        int pos = path.lastIndexOf("@");
        if (pos == -1) {
            throw new JDFException("SetXPathAttribute - bad attribute path: " + path);
        }
        String att = path.substring(pos + 1);
        String strAttrPath = path.substring(0, pos);
        VElement vEle = this.getXPathElementVectorInternal(strAttrPath, -1, true);
        if (vEle == null) {
            vEle = new VElement();
        }
        if (vEle.size() == 0) {
            KElement kEle = this.getCreateXPathElement(strAttrPath);
            vEle.add(kEle);
        }
        for (int i = 0; i < vEle.size(); ++i) {
            vEle.get(i).setAttribute(att, value, null);
        }
    }

    boolean hasXPathNode(String path) {
        String path2 = StringUtil.replaceString(path, "[@", "");
        int pos = path2.indexOf("@");
        if (pos >= 0) {
            return this.getXPathAttribute(path, null) != null;
        }
        return this.getXPathElement(path) != null;
    }

    String getXPathAttribute(String path, String def) {
        String elemPath;
        int pos = path.lastIndexOf("@");
        if (pos == -1 || pos > 0 && path.charAt(pos - 1) == '[') {
            elemPath = path;
            pos = -1;
        } else {
            elemPath = path.substring(0, pos);
        }
        KElement kEle = this.getXPathElement(elemPath);
        if (kEle == null) {
            return def;
        }
        if (pos >= 0) {
            return kEle.getAttribute_KElement(path.substring(pos + 1), null, def);
        }
        String s = kEle.getText();
        return s == null ? def : s;
    }

    String getInheritedXPathAttribute(String path, String def) {
        int pos = path.lastIndexOf("@");
        if (pos == -1 || pos > 0 && path.charAt(pos - 1) == '[') {
            throw new JDFException("GetXPathAttribute - bad attribute path: " + path);
        }
        KElement kEle = this.getXPathElement(path.substring(0, pos));
        return kEle == null ? def : kEle.getAttribute(path.substring(pos + 1), null, def);
    }

    void removeXPathElement(String path) {
        int pos = path.lastIndexOf("@");
        if (pos == -1) {
            KElement kEle = this.getXPathElement(path);
            if (kEle != null) {
                kEle.deleteNode();
            }
        } else {
            this.removeXPathAttribute(path);
        }
    }

    JDFAttributeMap getXPathAttributeMap(String path, boolean bWantText) {
        int pos = path == null ? -1 : path.lastIndexOf("@");
        String attName = path == null ? null : path.substring(pos + 1);
        String subele = path == null ? ".//*" : path.substring(0, pos);
        VElement vEle = this.theElement.getXPathElementVector(subele, 0);
        if (vEle == null) {
            return null;
        }
        String base = path == null ? null : this.buildXPath(null, 1);
        JDFAttributeMap map = new JDFAttributeMap();
        for (KElement e : vEle) {
            String text;
            VString vKeys = e.getAttributeVector_KElement();
            String baseXPath = new XPathHelper(e).buildXPath(base, 1);
            String nodeName = e.getNodeName();
            String prefix = KElement.xmlnsPrefix(nodeName);
            if (prefix != null) {
                String uri = e.getNamespaceURI();
                map.put("/" + StringUtil.token(baseXPath, 0, "/") + "/@xmlns:" + prefix, uri);
            }
            if (vKeys != null) {
                for (String key : vKeys) {
                    if (!StringUtil.matches(key, attName)) continue;
                    map.put(baseXPath + "/@" + key, e.getAttributeRaw(key));
                    prefix = KElement.xmlnsPrefix(key);
                    if (prefix == null) continue;
                    String uri = e.getNamespaceURIFromPrefix(prefix);
                    map.put("/" + StringUtil.token(baseXPath, 0, "/") + "/@xmlns:" + prefix, uri);
                }
            }
            if (!bWantText || (text = e.getText()) == null && vKeys != null && vKeys.size() != 0) continue;
            if (text == null) {
                text = "";
            }
            map.put(baseXPath, text);
        }
        return map.size() > 0 ? map : null;
    }

    KElement getXPathElement(String path) {
        VElement v = this.getXPathElementVectorInternal(path, 1, true);
        if (v == null || v.size() < 1) {
            return null;
        }
        return v.item(0);
    }

    void removeXPathAttribute(String path) {
        int pos = path.lastIndexOf("@");
        if (pos == -1) {
            KElement kEle = this.theElement.getXPathElement(path);
            if (kEle != null) {
                kEle.removeAllText();
            }
        } else {
            KElement kEle = this.theElement.getXPathElement(path.substring(0, pos));
            if (kEle != null) {
                kEle.removeAttribute(path.substring(pos + 1), null);
            }
        }
    }

    VElement getXPathElementVectorInternal(String path, int maxSize, boolean bLocal) {
        return new ElementVectorGetter().getXPathElementVectorInternal(path, maxSize, bLocal);
    }

    VElement getPathVector(String newPath, JDFAttributeMap map, boolean create) {
        VElement v = this.theElement.getChildElementVector_KElement(newPath, null, null, true, 0);
        VElement vRet = new VElement();
        if (v != null && v.size() > 0) {
            if (map != null && map.size() > 0) {
                VString keys = map.getKeys();
                for (String key : keys) {
                    for (KElement e : v) {
                        if (!e.getXPathAttribute(key, "").equals(map.get(key))) continue;
                        vRet.add(e);
                    }
                }
            } else {
                vRet = v;
            }
        } else if (map != null && create) {
            VString keys = map.getKeys();
            KElement e = this.theElement.appendElement(newPath);
            for (String key : keys) {
                new XPathHelper(e).setXPathValue(key, map.get(key));
            }
            vRet.add(e);
        }
        return vRet;
    }

    JDFAttributeMap getXPathAtMap(String path, int posBAt, int posB1) {
        JDFAttributeMap map = new JDFAttributeMap();
        String attEqVal = path.substring(posBAt + 1, posB1);
        String attName = StringUtil.token(attEqVal, 0, "=");
        String attVal = attEqVal.substring(attName.length() + 2, attEqVal.length() - 1);
        map.put(attName, attVal);
        return map;
    }

    public String toString() {
        return "XPathHelper [theElement=" + this.theElement + "]";
    }

    private class ElementVectorGetter {
        private ElementVectorGetter() {
        }

        VElement getXPathElementVectorInternal(String path, int maxSize, boolean bLocal) {
            int posB1;
            int posB0;
            if (path == null) {
                return null;
            }
            VElement vRet = new VElement();
            if ("".equals(path)) {
                return this.completeEmpty(bLocal, vRet);
            }
            if (path.startsWith("/")) {
                return this.evaluateSlash(path, maxSize);
            }
            if (path.startsWith(".")) {
                return this.evaluateDot(path, maxSize, vRet);
            }
            int posBAt = posB0 = path.indexOf("[");
            if (posB0 >= 0) {
                char next = path.charAt(posB0 + 1);
                if (next < '0' || next > '9') {
                    posB0 = -1;
                } else {
                    posBAt = -1;
                }
            }
            int iSkip = -1;
            String newPath = path;
            int pos = newPath.indexOf("/");
            JDFAttributeMap map = null;
            boolean bExplicitSkip = false;
            if (posB0 != -1 && (posB0 < pos || pos == -1)) {
                posB1 = path.indexOf("]");
                String n = path.substring(posB0 + 1, posB1);
                if (posB1 - posB0 == 2) {
                    iSkip = '\u0001' + n.charAt(0) - 49;
                }
                if (iSkip <= 0 || iSkip > 9) {
                    iSkip = StringUtil.parseInt(n, 0);
                }
                if (iSkip <= 0) {
                    throw new IllegalArgumentException("getXPathVector: bad index:" + iSkip);
                }
                --iSkip;
                bExplicitSkip = true;
                String childName = path.substring(0, posB0);
                newPath = childName + path.substring(posB1 + 1);
                pos = newPath.indexOf("/");
            } else if (posBAt != -1 && (posBAt < pos || pos == -1)) {
                posB1 = path.indexOf("]");
                map = XPathHelper.this.getXPathAtMap(path, posBAt, posB1);
                newPath = path.substring(0, posBAt) + path.substring(posB1 + 1);
                pos = newPath.indexOf("/");
            }
            if (pos != -1) {
                String elmName = newPath.substring(0, pos);
                VElement ve = this.getLocalElements(bLocal, newPath, map, elmName, iSkip);
                if (ve == null || ve.size() == 0) {
                    return null;
                }
                boolean iFirst = false;
                int iLast = ve.size();
                for (int i = 0; i < iLast; ++i) {
                    KElement ee = ve.item(i);
                    VElement eRet = new XPathHelper(ee).getXPathElementVectorInternal(newPath.substring(pos + 1), maxSize, true);
                    if (eRet == null) continue;
                    vRet.addAll(eRet);
                }
                return vRet.size() > 0 ? vRet : null;
            }
            if (bExplicitSkip) {
                return this.doExplicitSkip(vRet, iSkip, newPath);
            }
            if (bLocal) {
                vRet.addAll(XPathHelper.this.getPathVector(newPath, map, false));
            } else {
                vRet = XPathHelper.this.theElement.getElementsByTagName_KElement(newPath, null);
                if (XPathHelper.this.theElement.getLocalName().equals(newPath) || KElement.isWildCard(newPath)) {
                    vRet.add(XPathHelper.this.theElement);
                }
            }
            return vRet;
        }

        private VElement getLocalElements(boolean bLocal, String newPath, JDFAttributeMap map, String elmName, int iSkip) {
            VElement ve;
            if (bLocal) {
                if (iSkip < 0) {
                    ve = XPathHelper.this.getPathVector(elmName, map, false);
                } else {
                    KElement e = XPathHelper.this.theElement.getElement_KElement(elmName, null, iSkip);
                    if (e == null) {
                        ve = null;
                    } else {
                        ve = new VElement();
                        ve.add(e);
                    }
                }
            } else {
                ve = XPathHelper.this.theElement.getElementsByTagName_KElement(elmName, null);
                if (XPathHelper.this.theElement.getLocalName().equals(elmName) || KElement.isWildCard(newPath)) {
                    ve.add(XPathHelper.this.theElement);
                }
            }
            return ve;
        }

        private VElement doExplicitSkip(VElement vRet, int iSkip, String newPath) {
            KElement e = XPathHelper.this.theElement.getElement_KElement(newPath, null, iSkip);
            if (e == null) {
                return null;
            }
            vRet.add(e);
            return vRet;
        }

        private VElement evaluateDot(String path, int maxSize, VElement vRet) {
            if (path.startsWith(".//")) {
                VElement v = this.getXPathElementVectorInternal(path.substring(3), maxSize, false);
                if (v == null) {
                    v = new VElement();
                }
                v.add(XPathHelper.this.theElement);
                return v;
            }
            if (path.startsWith("./")) {
                return this.getXPathElementVectorInternal(path.substring("./".length()), maxSize, true);
            }
            if (path.startsWith("../")) {
                KElement parent = XPathHelper.this.theElement.getParentNode_KElement();
                if (parent == null) {
                    return null;
                }
                return new XPathHelper(parent).getXPathElementVectorInternal(path.substring("../".length()), maxSize, true);
            }
            if (path.equals(".")) {
                vRet.add(XPathHelper.this.theElement);
                return vRet;
            }
            if (path.equals("..")) {
                KElement parent = XPathHelper.this.theElement.getParentNode_KElement();
                if (parent == null) {
                    return null;
                }
                vRet.add(parent);
                return vRet;
            }
            throw new IllegalArgumentException("Invalid path name: " + path);
        }

        private VElement completeEmpty(boolean bLocal, VElement vRet) {
            if (bLocal) {
                vRet.add(XPathHelper.this.theElement);
            } else {
                vRet = XPathHelper.this.theElement.getChildrenByTagName(null, null, null, false, true, 0);
            }
            return vRet;
        }

        private VElement evaluateSlash(String path, int maxSize) {
            String nextPath;
            if (path.startsWith("//")) {
                return new XPathHelper(XPathHelper.this.theElement.getDocRoot()).getXPathElementVectorInternal(path.substring(2), maxSize, false);
            }
            KElement r = XPathHelper.this.theElement.getDocRoot();
            String rootNodeName = r.getLocalName();
            int nextPos = path.indexOf("/", 2);
            String rootPath = nextPos > 0 ? path.substring(1, nextPos) : path.substring(1);
            String string = nextPath = nextPos > 0 ? path.substring(nextPos + 1) : "";
            if (rootPath.equals(rootNodeName) || KElement.isWildCard(rootPath)) {
                return new XPathHelper(r).getXPathElementVectorInternal(nextPath, maxSize, true);
            }
            throw new IllegalArgumentException("Invalid root node name: " + path);
        }
    }

    class XPathElementCreator {
        XPathElementCreator() {
        }

        KElement getCreateXPathElement(String path) {
            if (path == null || path.length() == 0) {
                return XPathHelper.this.theElement;
            }
            KElement e = XPathHelper.this.getXPathElement(path);
            if (e != null) {
                return e;
            }
            if (path.startsWith("/")) {
                return this.evaluateSlash(path);
            }
            if (path.startsWith(".")) {
                return this.evaluateDot(path);
            }
            return this.evaluateNormal(path);
        }

        private KElement evaluateNormal(String path) {
            String next;
            KElement e;
            int posB0;
            int brack;
            int slash = path.indexOf("/");
            int endPos = this.findSlashBrack(slash, brack = (posB0 = path.indexOf("[")) < slash ? path.indexOf("]") : -1);
            if (endPos > 0 && (e = XPathHelper.this.getXPathElement(next = path.substring(0, endPos))) != null) {
                next = path.substring(endPos + 1);
                return new XPathHelper(e).getCreateXPathElement(next);
            }
            int iSkip = 0;
            String newPath = path;
            String attName = null;
            String attVal = null;
            if (posB0 != -1 && (posB0 < slash || slash == -1)) {
                int posB1 = path.indexOf("]");
                String siSkip = path.substring(posB0 + 1, posB1);
                newPath = path.substring(0, posB0) + path.substring(posB1 + 1);
                slash = newPath.indexOf("/");
                if (!StringUtil.isInteger(siSkip)) {
                    iSkip = -1;
                    VString v = StringUtil.tokenize(siSkip, "=", false);
                    if (v.size() == 2) {
                        attName = v.get(0);
                        attVal = v.get(1);
                        if (attName.length() > 1 && attVal.startsWith("\"") && attVal.endsWith("\"")) {
                            attVal = attVal.substring(1, attVal.length() - 1);
                            iSkip = this.calcSkipFromAtt(iSkip, newPath, slash, attName);
                        }
                    }
                    if (iSkip < 0) {
                        throw new IllegalArgumentException("GetCreateXPath: illegal path:" + path);
                    }
                } else {
                    iSkip = StringUtil.parseInt(siSkip, 1);
                    --iSkip;
                }
            }
            this.fillMissing(iSkip, newPath, slash);
            if (slash != -1) {
                KElement e2 = XPathHelper.this.theElement.getCreateElement_KElement(newPath.substring(0, slash), null, iSkip);
                if (attName != null && !e2.hasAttribute(attName)) {
                    e2.setXPathAttribute(attName, attVal);
                }
                return new XPathHelper(e2).getCreateXPathElement(newPath.substring(slash + 1));
            }
            KElement newElem = XPathHelper.this.theElement.getCreateElement_KElement(newPath, null, iSkip);
            if (attName != null) {
                new XPathHelper(newElem).setXPathAttribute(attName, attVal);
            }
            return newElem;
        }

        private KElement evaluateDot(String path) {
            if (path.startsWith("./")) {
                return this.getCreateXPathElement(path.substring(2));
            }
            if (path.startsWith("../")) {
                return XPathHelper.this.theElement.getParentNode_KElement().getCreateXPathElement(path.substring(3));
            }
            if (path.equals(".")) {
                return XPathHelper.this.theElement;
            }
            if (path.equals("..")) {
                return XPathHelper.this.theElement.getParentNode_KElement();
            }
            throw new JDFException("GetCreateXPathElement:: invalid path: " + path);
        }

        private KElement evaluateSlash(String path) {
            KElement r = XPathHelper.this.theElement.getDocRoot();
            int nextPos = path.indexOf("/", 2);
            if (!path.substring(1, nextPos).equals(r.getNodeName())) {
                throw new JDFException("GetCreateXPathElement:: invalid path: " + path);
            }
            if (nextPos == -1) {
                return XPathHelper.this.theElement;
            }
            return new XPathHelper(r).getCreateXPathElement(path.substring(nextPos + 1));
        }

        private int findSlashBrack(int slash, int brack) {
            int slashBrack = slash > 0 && brack > 0 ? Math.max(slash, brack + 1) : (brack > 0 ? brack + 1 : slash);
            return slashBrack;
        }

        private int calcSkipFromAtt(int iSkip, String newPath, int pos, String attName) {
            String kidName = pos >= 0 ? newPath.substring(0, pos) : newPath;
            VElement vNewChild = XPathHelper.this.theElement.getChildElementVector(kidName, null);
            for (int j = 0; j < vNewChild.size(); ++j) {
                KElement tryKid = vNewChild.get(j);
                if (!attName.equals(tryKid.getXPathAttribute(attName, null))) continue;
                iSkip = j + 1;
                break;
            }
            if (iSkip == -1) {
                iSkip = vNewChild.size();
            }
            return iSkip;
        }

        private void fillMissing(int iSkip, String newPath, int pos) {
            if (iSkip > 0) {
                int n;
                String elem = pos < 0 ? newPath : newPath.substring(0, pos);
                for (int i = n = XPathHelper.this.theElement.numChildElements_KElement(elem, null); i < iSkip; ++i) {
                    XPathHelper.this.theElement.appendElement(elem, null);
                }
            }
        }
    }
}

