/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.datatypes.JDFXYPair;
import org.cip4.jdflib.datatypes.JDFXYPairRange;
import org.cip4.jdflib.util.StringUtil;

public class JDFXYPairRangeList
extends JDFRangeList {
    public static JDFXYPairRangeList createXYPairRangeList(String s) {
        if (s != null && s.length() > 0) {
            try {
                return new JDFXYPairRangeList(s);
            }
            catch (DataFormatException x) {
                return null;
            }
        }
        return null;
    }

    public JDFXYPairRangeList() {
    }

    public JDFXYPairRangeList(JDFXYPairRangeList rl) {
        this.rangeList = new Vector(rl.rangeList);
    }

    public JDFXYPairRangeList(JDFXYPairRange r) {
        this.append(r);
    }

    public JDFXYPairRangeList(String s) throws DataFormatException {
        if (s != null && !s.equals("")) {
            this.setString(s);
        }
    }

    public boolean inRange(JDFXYPair x) {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            JDFXYPairRange r = (JDFXYPairRange)this.rangeList.elementAt(i);
            if (!r.inRange(x)) continue;
            return true;
        }
        return false;
    }

    public void setString(String s) throws DataFormatException {
        if (s.indexOf("~") == 0 || s.lastIndexOf("~") == s.length() - 1) {
            throw new DataFormatException("JDFXYPairRangeList::SetString: Illegal string " + s);
        }
        String zappedWS = StringUtil.zappTokenWS(s, "~");
        VString vs = new VString(zappedWS, " ");
        this.rangeList.clear();
        int size = vs.size();
        for (int i = 0; i < size; ++i) {
            if (size - i < 2) {
                throw new DataFormatException("JDFXYPairRangeList::SetString: Illegal string " + s);
            }
            String tok1 = vs.elementAt(i);
            String tok2 = vs.elementAt(++i);
            String str = tok1 + " " + tok2;
            if (tok2.indexOf("~") != -1) {
                str = tok1 + " " + tok2 + " " + vs.elementAt(++i);
            }
            try {
                JDFXYPairRange r = new JDFXYPairRange(str);
                this.rangeList.addElement(r);
                continue;
            }
            catch (DataFormatException dfe) {
                throw new DataFormatException("JDFXYPairRangeList::SetString: Illegal string " + s);
            }
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFXYPairRangeList(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public void append(JDFXYPairRange r) {
        this.rangeList.addElement(r);
    }

    public void append(JDFXYPair xMin, JDFXYPair xMax) {
        this.append(new JDFXYPairRange(xMin, xMax));
    }

    public void append(JDFXYPair x) {
        this.append(new JDFXYPairRange(x, x));
    }

    @Override
    public boolean isOrdered() {
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<JDFXYPair> v = new Vector<JDFXYPair>();
        for (int i = 0; i < siz; ++i) {
            JDFXYPairRange r = (JDFXYPairRange)this.rangeList.elementAt(i);
            v.addElement(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            v.addElement(r.getRight());
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFXYPair first = (JDFXYPair)v.elementAt(0);
        JDFXYPair last = (JDFXYPair)v.elementAt(n);
        for (int j = 0; j < n; ++j) {
            JDFXYPair value = (JDFXYPair)v.elementAt(j);
            JDFXYPair nextvalue = (JDFXYPair)v.elementAt(j + 1);
            if (first.equals(last) && value.equals(nextvalue) || first.isLess(last) && value.isLessOrEqual(nextvalue) || first.isGreater(last) && value.isGreaterOrEqual(nextvalue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUniqueOrdered() {
        JDFXYPair last;
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<JDFXYPair> v = new Vector<JDFXYPair>();
        for (int i = 0; i < siz; ++i) {
            JDFXYPairRange r = (JDFXYPairRange)this.rangeList.elementAt(i);
            v.addElement(r.getLeft());
            if (r.getLeft().equals(r.getRight())) continue;
            v.addElement(r.getRight());
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        JDFXYPair first = (JDFXYPair)v.elementAt(0);
        if (first.equals(last = (JDFXYPair)v.elementAt(n))) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            JDFXYPair value = (JDFXYPair)v.elementAt(j);
            JDFXYPair nextvalue = (JDFXYPair)v.elementAt(j + 1);
            if (first.isLess(last) && value.isLess(nextvalue) || first.isGreater(last) && value.isGreater(nextvalue)) continue;
            return false;
        }
        return true;
    }
}

