/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import org.cip4.jdflib.auto.JDFAutoValue;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.jmf.JDFDeviceInfo;
import org.cip4.jdflib.resource.devicecapability.JDFBooleanState;
import org.cip4.jdflib.resource.devicecapability.JDFDateTimeState;
import org.cip4.jdflib.resource.devicecapability.JDFDeviceCap;
import org.cip4.jdflib.resource.devicecapability.JDFNumberState;
import org.cip4.jdflib.resource.devicecapability.JDFStringState;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class CapabilitiesCreator
extends BaseElementWalker {
    static final String STATEPOOL = "StatePool";

    public CapabilitiesCreator() {
        super(new BaseWalkerFactory());
    }

    public JDFDeviceCap createCaps(KElement xjdf) {
        JDFDeviceCap dc = this.createDeviceCap();
        this.walkTree(xjdf, dc.getElement(STATEPOOL));
        return dc;
    }

    JDFDeviceCap createDeviceCap() {
        JDFDoc doc = new JDFDoc("DeviceInfo");
        doc.setInitOnCreate(false);
        JDFDeviceInfo di = (JDFDeviceInfo)doc.getRoot();
        di.appendDevice().setDeviceID("devID");
        JDFDeviceCap dc = (JDFDeviceCap)di.appendElement("DeviceCap");
        dc.appendTestPool();
        dc.appendElement(STATEPOOL);
        return dc;
    }

    public class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(CapabilitiesCreator.this.getFactory());
        }

        @Override
        public KElement walk(KElement e, KElement trackElem) {
            String xpath = e.buildXPath(null, 0);
            KElement elmState = trackElem.getCreateChildWithAttribute("ElementState", "XPath", null, xpath, 0);
            elmState.setAttribute("MinOccurs", "1");
            JDFAttributeMap map = e.getAttributeMap();
            if (map != null) {
                for (String key : map.keySet()) {
                    this.walkAttribute(key, e, trackElem);
                }
            }
            return trackElem;
        }

        private void walkAttribute(String key, KElement e, KElement trackElem) {
            String xpath = e.buildXPath(null, 0) + "/@" + key;
            String val = StringUtil.getNonEmpty(e.getAttribute(key));
            if (val == null) {
                return;
            }
            String elmType = this.getStateType(val);
            KElement elmState = trackElem.getCreateChildWithAttribute(elmType, "XPath", null, xpath, 0);
            this.updateValue(elmState, val);
        }

        private void updateValue(KElement elmState, String val) {
            if (elmState instanceof JDFStringState) {
                this.updateStringState((JDFStringState)elmState, val);
            } else if (elmState instanceof JDFNumberState) {
                this.updateNumberState((JDFNumberState)elmState, val);
            } else if (elmState instanceof JDFBooleanState) {
                this.updateBooleanState((JDFBooleanState)elmState, val);
            } else if (elmState instanceof JDFDateTimeState) {
                this.updateDateTimeState((JDFDateTimeState)elmState, val);
            }
        }

        private void updateStringState(JDFStringState elmState, String val) {
            boolean bList;
            String regexp = elmState.getAllowedRegExp();
            if (regexp.endsWith("+")) {
                regexp = regexp.substring(1);
                regexp = StringUtil.leftStr(regexp, -2);
            }
            VString vr = VString.getVString(regexp, "|");
            VString vVal = VString.getVString(val, " ");
            if (vr == null) {
                vr = new VString();
            }
            for (String val2 : vVal) {
                val2 = StringUtil.escape(val2, "{}()[].+*?^$\\|", "\\", 0, 0, -1, -1);
                vr.appendUnique("(" + val2 + ")");
            }
            boolean bl = bList = vr.size() > 1;
            if (bList) {
                vr.appendUnique("( )");
            }
            String newExp = StringUtil.setvString(vr, "|", bList ? "(" : null, bList ? ")+" : null);
            elmState.setAllowedRegExp(newExp);
        }

        private void updateBooleanState(JDFBooleanState elmState, String val) {
            elmState.setAttribute("AllowedValueList", "true false");
        }

        private void updateNumberState(JDFNumberState elmState, String val) {
            double dVal = StringUtil.parseDouble(val, Double.NaN);
            if (!Double.isNaN(dVal)) {
                double min = Double.NaN;
                if (elmState.hasAttribute("AllowedValueMin")) {
                    min = elmState.getAllowedValueMin();
                    min = Math.min(min, dVal);
                } else {
                    min = dVal;
                }
                elmState.setAllowedValueMin(min);
                double max = Double.NaN;
                if (elmState.hasAttribute("AllowedValueMax")) {
                    max = elmState.getAllowedValueMax();
                    max = Math.max(min, dVal);
                } else {
                    max = dVal;
                }
                elmState.setAllowedValueMax(max);
            }
        }

        private void updateDateTimeState(JDFDateTimeState elmState, String val) {
            JDFDate date = JDFDate.createDate(val);
            if (date != null) {
                KElement dtv = elmState.getCreateElement("DateTimeValue");
                dtv.setAttribute("ValueUsage", JDFAutoValue.EnumValueUsage.Allowed.getName());
                JDFDate min = date;
                if (dtv.hasAttribute("MinValue")) {
                    String minDate = dtv.getAttribute("MinValue");
                    min = JDFDate.createDate(minDate);
                    min = date.before(min) ? date : min;
                }
                dtv.setAttribute("MinValue", min.getDateTimeISO());
                JDFDate max = date;
                if (dtv.hasAttribute("MaxValue")) {
                    String maxDate = dtv.getAttribute("MaxValue");
                    max = JDFDate.createDate(maxDate);
                    max = date.after(min) ? date : max;
                }
                dtv.setAttribute("MaxValue", max.getDateTimeISO());
            }
        }

        private String getStateType(String val) {
            if (StringUtil.isNumber(val)) {
                return "NumberState";
            }
            if (StringUtil.isBoolean(val)) {
                return "BooleanState";
            }
            if (JDFDate.createDate(val) != null) {
                return "DateTimeState";
            }
            return "StringState";
        }
    }
}

