/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker;

import java.util.Collection;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.XJDFToJDFImpl;
import org.cip4.jdflib.ifaces.IXJDFSplit;

public class XJDFToJDFConverter
extends XJDFToJDFImpl {
    protected IXJDFSplit splitter = null;

    public XJDFToJDFConverter(JDFDoc template) {
        super(template);
    }

    @Override
    public JDFDoc convert(KElement xjdf) {
        JDFDoc d = null;
        if (this.needSplit(xjdf)) {
            Collection<XJDFHelper> vSplit = this.splitter.splitXJDF(new XJDFHelper(xjdf));
            if (vSplit == null || vSplit.size() == 0) {
                this.log.error((Object)"no xjdf elements returned by splitter");
            } else {
                for (XJDFHelper h : vSplit) {
                    d = super.convert(h.getRoot());
                    this.setCreateProduct(false);
                }
            }
        } else {
            d = super.convert(xjdf);
        }
        return d;
    }

    public JDFDoc convert(XJDFHelper helper) {
        KElement e = helper == null ? null : helper.getRoot();
        return this.convert(e);
    }

    protected boolean needSplit(KElement xjdf) {
        return this.splitter != null && xjdf != null && "XJDF".equals(xjdf.getLocalName());
    }

    public void setSplitter(IXJDFSplit splitter) {
        this.splitter = splitter;
    }
}

