/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDFElement;
import org.cip4.jdflib.jmf.JDFMessage;

public class WalkMessage
extends WalkJDFElement {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFMessage m = (JDFMessage)jdf;
        if (this.jdfToXJDF.bTypeSafeMessage) {
            this.makeTypesafe(m);
        }
        return super.walk(jdf, xjdf);
    }

    void makeTypesafe(JDFMessage m) {
        JDFMessage.EnumFamily family = this.getNewFamily(m);
        if (family == null) {
            this.log.error((Object)"cannot convert message with null family");
        } else {
            String type = this.getMessageType(m);
            m.renameElement(this.getFamilyName(family) + type, null);
        }
    }

    String getFamilyName(JDFMessage.EnumFamily family) {
        return family.getName();
    }

    String getMessageType(JDFMessage m) {
        String type = m.getType();
        return type;
    }

    private JDFMessage.EnumFamily getNewFamily(JDFMessage m) {
        JDFMessage.EnumFamily family = m.getFamily();
        if (this.jdfToXJDF.bAbstractMessage) {
            if (JDFMessage.EnumFamily.Command.equals((Object)family) || JDFMessage.EnumFamily.Registration.equals((Object)family)) {
                family = JDFMessage.EnumFamily.Query;
            }
            if (JDFMessage.EnumFamily.Acknowledge.equals((Object)family)) {
                family = JDFMessage.EnumFamily.Response;
            }
        }
        return family;
    }

    @Override
    protected void removeUnused(KElement newRootP) {
        super.removeUnused(newRootP);
        if (this.jdfToXJDF.bTypeSafeMessage) {
            newRootP.removeAttribute("Type");
        }
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFMessage;
    }
}

