/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkAudit;
import org.cip4.jdflib.pool.JDFAmountPool;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.JDFResourceAudit;
import org.cip4.jdflib.util.StringUtil;

public class WalkResourceAudit
extends WalkAudit {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        KElement raNew = super.walk(jdf, xjdf);
        JDFResourceAudit ra = (JDFResourceAudit)jdf;
        this.copyLinkValues(raNew, ra.getNewLink(), "NewRef");
        this.copyLinkValues(raNew, ra.getOldLink(), "OldRef");
        return raNew;
    }

    protected void copyLinkValues(KElement raNew, JDFResourceLink rl, String val) {
        JDFResource rlRoot;
        JDFResource jDFResource = rlRoot = rl == null ? null : rl.getLinkRoot();
        if (rlRoot != null && rl != null) {
            VElement v = this.setResource(null, rlRoot, this.jdfToXJDF.newRoot);
            if (v != null) {
                for (KElement kElem : v) {
                    KElement resAmount = raNew.appendElement("ResourceAmount");
                    resAmount.setAttribute("Type", val);
                    resAmount.setAttribute("rRef", kElem.getAttribute("ID"));
                    JDFAmountPool amountPool = rl.getAmountPool();
                    if (amountPool != null) {
                        this.jdfToXJDF.walkTree(amountPool, resAmount);
                        continue;
                    }
                    JDFAmountPool ap = (JDFAmountPool)resAmount.appendElement("AmountPool");
                    if (rl.getAmount() != 0.0) {
                        ap.setPartAttribute("Amount", StringUtil.formatDouble(rl.getAmount(), 0), null, (JDFAttributeMap)null);
                    }
                    if (rl.getActualAmount() == 0.0) continue;
                    ap.setPartAttribute("ActualAmount", StringUtil.formatDouble(rl.getActualAmount(), 0), null, (JDFAttributeMap)null);
                }
            }
            rl.deleteNode();
        }
    }

    @Override
    public boolean matches(KElement toCheck) {
        return toCheck instanceof JDFResourceAudit;
    }
}

