/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPageList;
import org.cip4.jdflib.datatypes.JDFIntegerRangeList;
import org.cip4.jdflib.resource.process.JDFPageData;
import org.w3c.dom.DOMException;

public class JDFPageList
extends JDFAutoPageList {
    private static final long serialVersionUID = 1L;

    public JDFPageList(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPageList(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPageList(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPageList[  --> " + super.toString() + " ]";
    }

    public int getNPage() {
        Vector<JDFPageData> vPages = this.getChildrenByClass(JDFPageData.class, false, 0);
        if (vPages.size() > 0) {
            JDFPageData pd0 = vPages.get(0);
            if (pd0.hasAttribute("PageIndex")) {
                int max = 0;
                for (JDFPageData pd : vPages) {
                    JDFIntegerRangeList rl = pd.getPageIndex();
                    rl.normalize(true);
                    int n = rl.getElement(-1);
                    if (n < max) continue;
                    max = n + 1;
                }
                return max;
            }
            return vPages.size();
        }
        return 0;
    }

    public JDFPageData getPageDataByIndex(int index) {
        if (index < 0) {
            index += this.getNPage();
        }
        if (index < 0) {
            return null;
        }
        Vector<JDFPageData> vPages = this.getChildrenByClass(JDFPageData.class, false, 0);
        if (vPages.size() > 0) {
            JDFPageData pd0 = vPages.get(0);
            if (pd0.hasAttribute("PageIndex")) {
                for (JDFPageData pd : vPages) {
                    JDFIntegerRangeList rl = pd.getPageIndex();
                    if (!rl.inRange(index)) continue;
                    return pd;
                }
                return null;
            }
            return index < vPages.size() ? vPages.get(index) : null;
        }
        return null;
    }
}

