/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource;

import java.util.Iterator;
import java.util.Set;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoPart;
import org.cip4.jdflib.core.AtrInfo;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.resource.JDFResource;

public class JDFPart
extends JDFAutoPart {
    private static final long serialVersionUID = 1L;

    public JDFPart(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPart(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPart(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPart[  --> " + super.toString() + " ]";
    }

    @Override
    public JDFAttributeMap getPartMap() {
        JDFAttributeMap am = this.getAttributeMap();
        Iterator<String> it = am.getKeyIterator();
        JDFAttributeMap retMap = new JDFAttributeMap();
        while (it.hasNext()) {
            String key = it.next();
            if (JDFResource.EnumPartIDKey.getEnum(key) == null) continue;
            retMap.put(key, am.get(key));
        }
        return retMap;
    }

    public VString guessPartIDKeys() {
        JDFAttributeMap map = this.getPartMap();
        if (map == null || map.size() == 0) {
            return null;
        }
        VString v = new VString();
        VString keys = map.getKeys();
        if (map.size() == 1) {
            return map.getKeys();
        }
        if (keys.contains("SignatureName")) {
            v.add("SignatureName");
            keys.remove("SignatureName");
        }
        if (keys.contains("SheetName")) {
            v.add("SheetName");
            keys.remove("SheetName");
        }
        if (keys.contains("Side")) {
            v.add("Side");
            keys.remove("Side");
        }
        if (keys.contains("Separation")) {
            v.add("Separation");
            keys.remove("Separation");
        }
        v.addAll(keys);
        return v;
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        this.removeAttributes(null);
        this.setAttributes(mPart);
    }

    @Deprecated
    public static boolean matchesPart(String key, String resourceValue, String linkValue) {
        return JDFPart.matchesPart(key, resourceValue, linkValue, false);
    }

    public static boolean matchesPart(String key, String resourceValue, VString linkValues, boolean strictPartVersion) {
        if (linkValues == null || linkValues.size() == 0) {
            return true;
        }
        for (String linkValue : linkValues) {
            if (!JDFPart.matchesPart(key, resourceValue, linkValue, strictPartVersion)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesPart(String key, String resourceValue, String linkValue, boolean strictPartVersion) {
        boolean b;
        if (resourceValue.equals(linkValue)) {
            return true;
        }
        if ("SignatureName".equals(key) || "SheetName".equals(key) || "Side".equals(key)) {
            return false;
        }
        if ("ItemNames".equals(key) || key.endsWith("Tags")) {
            boolean bl = AtrInfo.matchesAttribute(linkValue, resourceValue, AttributeInfo.EnumAttributeType.NMTOKENS);
        }
        if ("PageNumber".equals(key) || key.endsWith("Index") || "LayerIDs".equals(key) || "DocCopies".equals(key)) {
            b = AtrInfo.matchesAttribute(linkValue, resourceValue, AttributeInfo.EnumAttributeType.IntegerRangeList);
        } else if (!strictPartVersion && "PartVersion".equals(key)) {
            b = resourceValue.equals(linkValue);
            if (!b) {
                int iResPos = resourceValue.indexOf(32);
                int iLinkPos = linkValue.indexOf(32);
                if (iResPos < 0 && iLinkPos >= 0) {
                    b = AtrInfo.matchesAttribute(resourceValue, linkValue, AttributeInfo.EnumAttributeType.NMTOKENS);
                } else if (iLinkPos < 0 && iResPos >= 0) {
                    b = AtrInfo.matchesAttribute(linkValue, resourceValue, AttributeInfo.EnumAttributeType.NMTOKENS);
                }
            }
        } else {
            b = false;
        }
        return b;
    }

    @Deprecated
    public static boolean overlapPartMap(JDFAttributeMap resourceMap, JDFAttributeMap linkMap) {
        return JDFPart.overlapPartMap(resourceMap, linkMap, false);
    }

    public static boolean overlapPartMap(JDFAttributeMap resourceMap, JDFAttributeMap linkMap, boolean strictPartVersion) {
        if (resourceMap == null || linkMap == null) {
            return true;
        }
        Set subMapKeys = linkMap.keySet();
        for (String key : subMapKeys) {
            String linkVal;
            String resVal = resourceMap.get(key);
            if (resVal == null || JDFPart.matchesPart(key, resVal, linkVal = linkMap.get(key), strictPartVersion)) continue;
            return false;
        }
        return true;
    }

    public static boolean overlapPartMap(JDFAttributeMap resourceMap, VJDFAttributeMap vLinkMap, boolean strictPartVersion) {
        if (resourceMap == null || vLinkMap == null) {
            return true;
        }
        for (JDFAttributeMap linkMap : vLinkMap) {
            if (!JDFPart.overlapPartMap(resourceMap, linkMap, strictPartVersion)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        AttributeInfo ai = AttributeInfo.fixedMap.get("JDFPart");
        if (ai != null) {
            return ai;
        }
        ai = super.getTheAttributeInfo();
        AttributeInfo.fixedMap.put("JDFPart", ai);
        return ai;
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        ElementInfo ai = ElementInfo.fixedMap.get("JDFPart");
        if (ai != null) {
            return ai;
        }
        ai = super.getTheElementInfo();
        ElementInfo.fixedMap.put("JDFPart", ai);
        return ai;
    }

    public void setMetadata(int iMetaData, String value) {
        if (iMetaData < 0 || iMetaData > 9) {
            throw new IllegalArgumentException("iMetaData mut be between 0 and 9");
        }
        this.setAttribute("Metadata" + iMetaData, value, null);
    }
}

