/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.mime;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFParser;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.jmf.JDFCommand;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.jmf.JDFMessage;
import org.cip4.jdflib.jmf.JDFResponse;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.util.ByteArrayIOStream;
import org.cip4.jdflib.util.MimeUtil;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.UrlPart;
import org.cip4.jdflib.util.UrlUtil;
import org.cip4.jdflib.util.mime.BodyPartHelper;
import org.cip4.jdflib.util.mime.MimeHelper;
import org.cip4.jdflib.util.mime.MimeReader;

public class MimeWriter
extends MimeHelper {
    private final Log log = LogFactory.getLog(this.getClass());
    private MimeUtil.MIMEDetails md;

    public void setMIMEDetails(MimeUtil.MIMEDetails _md) {
        this.md = _md;
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        ByteArrayIOStream bis = new ByteArrayIOStream();
        this.writeToStream(bis);
        return bis.getInputStream();
    }

    public MimeWriter() {
        this.createMimePackage();
    }

    public MimeWriter(Multipart mp) {
        this.theMultipart = mp;
    }

    public void createMimePackage() {
        MimeMultipart multipart = new MimeMultipart("related");
        MimeMessage message = new MimeMessage((Session)null);
        try {
            message.setContent((Multipart)multipart);
        }
        catch (MessagingException x) {
            this.log.error((Object)"cannot create mime package", (Throwable)x);
            return;
        }
        this.theMultipart = multipart;
    }

    public BodyPartHelper updateMultipart(InputStream is, String cid, String contentType) {
        if (is == null || StringUtil.getNonEmpty(cid) == null) {
            return null;
        }
        BodyPart bp = this.getCreatePartByCID(cid);
        if (bp == null) {
            return null;
        }
        try {
            ByteArrayIOStream.ByteArrayIOInputStream inputStream = ByteArrayIOStream.getBufferedInputStream(is);
            ByteArrayDataSource ds = new ByteArrayDataSource((InputStream)inputStream, contentType);
            bp.setDataHandler(new DataHandler((DataSource)ds));
        }
        catch (MessagingException e) {
            this.log.error((Object)"cannot update mime package", (Throwable)e);
        }
        catch (IOException x) {
            this.log.error((Object)"cannot update mime package", (Throwable)x);
        }
        return new BodyPartHelper(bp);
    }

    public BodyPart updateXMLMultipart(XMLDoc xmlDoc, String cid) {
        if (xmlDoc == null) {
            return null;
        }
        String originalFileName = xmlDoc.getOriginalFileName();
        if (cid == null) {
            cid = originalFileName;
        }
        if (cid == null) {
            KElement root = xmlDoc.getRoot();
            cid = "CID_" + (root instanceof JDFNode && root.hasAttribute("ID") ? ((JDFNode)root).getID() : KElement.uniqueID(0));
        }
        BodyPart messageBodyPart = this.getCreatePartByCID(cid);
        BodyPartHelper bph = new BodyPartHelper(messageBodyPart);
        try {
            bph.setFileName(originalFileName);
            bph.setContent(xmlDoc);
            bph.setContentID(cid);
        }
        catch (MessagingException x) {
            this.log.error((Object)"cannot update mime package", (Throwable)x);
        }
        catch (IOException x) {
            this.log.error((Object)"cannot update mime package", (Throwable)x);
        }
        return messageBodyPart;
    }

    public File writeToFile(String fileName) {
        File file = new File(fileName);
        try {
            FileOutputStream fos = new FileOutputStream(file);
            this.writeToStream(fos);
            return file;
        }
        catch (FileNotFoundException e) {
            this.log.error((Object)"cannot write mime package", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            this.log.error((Object)"cannot write mime package", (Throwable)e);
            return null;
        }
        catch (MessagingException e) {
            this.log.error((Object)"cannot write mime package", (Throwable)e);
            return null;
        }
    }

    public void writeToDir(File directory) throws MessagingException, IOException {
        boolean exists = directory.exists();
        if (!exists) {
            exists = directory.mkdirs();
        }
        if (!exists) {
            this.log.error((Object)("cannot create directory: " + directory));
            throw new FileNotFoundException("cannot create directory: " + directory);
        }
        if (!directory.canWrite()) {
            this.log.error((Object)("cannot write to directory: " + directory));
            throw new IOException("cannot write to directory: " + directory);
        }
        int parts = this.getCount();
        for (int i = 0; i < parts; ++i) {
            BodyPartHelper bph = this.getBodyPartHelper(i);
            bph.writeToDir(directory);
        }
    }

    public void writeToStream(OutputStream outStream) throws IOException, MessagingException {
        BodyPart[] bp;
        if (this.theMultipart == null) {
            throw new MessagingException("Multipart must be non null");
        }
        MimeMessage mm = new MimeMessage((Session)null);
        mm.setContent(this.theMultipart);
        if (!(outStream instanceof BufferedOutputStream) && !(outStream instanceof ByteArrayIOStream)) {
            outStream = new BufferedOutputStream(outStream);
        }
        if (this.md != null && this.md.modifyBoundarySemicolon) {
            outStream = new FixSemiColonStream(outStream);
        }
        if (this.md != null && this.md.transferEncoding != null && (bp = this.getBodyParts()) != null) {
            int siz = bp.length;
            for (int i = 0; i < siz; ++i) {
                bp[i].setHeader("Content-Transfer-Encoding", this.md.transferEncoding);
            }
        }
        mm.writeTo(outStream);
        outStream.flush();
        outStream.close();
    }

    public UrlPart writeToURL(String strUrl) throws IOException, MessagingException {
        UrlPart p = null;
        URL url = UrlUtil.stringToURL(strUrl);
        if ("File".equalsIgnoreCase(url.getProtocol())) {
            File outFile = this.writeToFile(UrlUtil.urlToFile(strUrl).getAbsolutePath());
            p = outFile == null ? null : new UrlPart(outFile);
        } else {
            ByteArrayIOStream bos = new ByteArrayIOStream();
            this.writeToStream(bos);
            p = UrlUtil.writeToURL(strUrl, bos.getInputStream(), "POST", this.theMultipart.getContentType(), this.md == null ? null : this.md.httpDetails);
        }
        return p;
    }

    public void buildMimePackage(Vector<? extends XMLDoc> vXMLDocs) {
        int imax = vXMLDocs.size();
        for (int i = 0; i < imax; ++i) {
            XMLDoc d1 = vXMLDocs.elementAt(i);
            this.updateXMLMultipart(d1, null);
        }
    }

    public void buildMimePackage(JDFDoc docJMF, XMLDoc docJDF, boolean extendReferenced) {
        String originalFileName;
        String cid = null;
        if (docJDF != null) {
            originalFileName = docJDF.getOriginalFileName();
            if (KElement.isWildCard(originalFileName)) {
                originalFileName = "TheJDF.jdf";
            }
            cid = MimeUtil.urlToCid(originalFileName);
        }
        if (docJMF != null && cid != null) {
            KElement e;
            VElement v;
            originalFileName = docJMF.getOriginalFileName();
            if (KElement.isWildCard(originalFileName)) {
                JDFJMF jmf = docJMF.getJMFRoot();
                JDFMessage m = jmf == null ? null : jmf.getMessageElement(null, null, 0);
                originalFileName = m == null ? "TheJMF.jmf" : m.getType() + ".jmf";
                docJMF.setOriginalFileName(originalFileName);
            }
            if ((v = (e = docJMF.getRoot()).getChildrenByTagName(null, null, new JDFAttributeMap("URL", "*"), false, false, 0)) != null) {
                int siz = v.size();
                for (int i = 0; i < siz; ++i) {
                    v.item(i).setAttribute("URL", cid);
                }
            }
        }
        this.updateXMLMultipart(docJMF, null);
        if (extendReferenced) {
            this.extendMultipart(docJDF, cid);
        } else {
            this.updateXMLMultipart(docJDF, cid);
        }
    }

    private int extendMultipart(XMLDoc docJDF, String cid) {
        int n = 0;
        if (docJDF == null) {
            this.log.error((Object)"cannot extend null JDF document");
            return 0;
        }
        KElement e = docJDF.getRoot();
        VElement fileSpecs = e.getChildrenByTagName("FileSpec", null, new JDFAttributeMap("URL", "*"), false, false, 0);
        if (fileSpecs != null) {
            int i;
            int vSize = fileSpecs.size();
            String[] urlStrings = MimeWriter.listURLs(fileSpecs);
            for (i = 0; i < urlStrings.length; ++i) {
                if (urlStrings[i] == null) continue;
                File f = UrlUtil.urlToFile(urlStrings[i]);
                if (f != null && !f.isAbsolute() && docJDF.getOriginalFileName() != null) {
                    File jdfFile = new File(docJDF.getOriginalFileName());
                    f = new File(jdfFile.getParent(), f.getPath());
                    urlStrings[i] = UrlUtil.fileToUrl(f, false);
                }
                if (f == null || !f.canRead()) {
                    urlStrings[i] = null;
                } else {
                    fileSpecs.item(i).setAttribute("URL", MimeUtil.urlToCid(urlStrings[i]), null);
                }
                for (int j = 0; j < i; ++j) {
                    if (urlStrings[i] == null || !urlStrings[i].equals(urlStrings[j])) continue;
                    urlStrings[i] = null;
                }
            }
            this.updateXMLMultipart(docJDF, cid);
            for (i = 0; i < vSize; ++i) {
                BodyPartHelper bph;
                BodyPart bp;
                String urlString = urlStrings[i];
                if (urlString == null || (bp = (bph = new BodyPartHelper()).createFromURL(urlString)) == null) continue;
                this.addBodyPart(bph);
                ++n;
            }
        }
        return n;
    }

    private void addBodyPart(BodyPartHelper bph) {
        try {
            this.theMultipart.addBodyPart(bph.getBodyPart());
        }
        catch (MessagingException e) {
            this.log.error((Object)"cannot add bodypart", (Throwable)e);
        }
    }

    private static String[] listURLs(VElement fileSpecs) {
        String[] urlStrings = new String[]{};
        if (fileSpecs != null) {
            int vSize = fileSpecs.size();
            urlStrings = new String[vSize];
            for (int i = 0; i < vSize; ++i) {
                urlStrings[i] = fileSpecs.item(i).getAttribute("URL", null, null);
            }
        }
        return urlStrings;
    }

    public JDFDoc writeToQueue(JDFDoc docJMF, JDFDoc docJDF, String strUrl) throws IOException, MessagingException {
        JDFDoc doc = null;
        this.buildMimePackage(docJMF, docJDF, true);
        UrlPart uc = this.writeToURL(strUrl);
        if (uc == null) {
            return doc;
        }
        int rc = uc.getResponseCode();
        InputStream inputStream = uc.getResponseStream();
        if (rc == 200) {
            ByteArrayIOStream.ByteArrayIOInputStream bis = ByteArrayIOStream.getBufferedInputStream(inputStream);
            MimeReader mr = new MimeReader(bis);
            BodyPartHelper bph = mr.getBodyPartHelper(0);
            JDFDoc jDFDoc = doc = bph == null ? null : bph.getJDFDoc();
            if (doc == null) {
                bis.reset();
                doc = new JDFParser().parseStream(bis);
                if (doc == null) {
                    JDFCommand c = docJMF.getJMFRoot().getCommand(0);
                    JDFJMF respJMF = c.createResponse();
                    JDFResponse r = respJMF.getResponse(0);
                    r.setErrorText("Invalid attached JDF", null);
                    r.setReturnCode(3);
                    doc = respJMF.getOwnerDocument_JDFElement();
                }
            }
        } else {
            JDFCommand c = docJMF.getJMFRoot().getCommand(0);
            JDFJMF respJMF = c.createResponse();
            JDFResponse r = respJMF.getResponse(0);
            r.setErrorText("Invalid http response - RC=" + rc, null);
            r.setReturnCode(3);
            doc = respJMF.getOwnerDocument_JDFElement();
        }
        inputStream.close();
        return doc;
    }

    static class FixSemiColonStream
    extends BufferedOutputStream {
        private int pos = 0;
        private byte[] smallBuf = new byte[4000];

        public FixSemiColonStream(OutputStream _out) {
            super(_out);
        }

        @Override
        public synchronized void write(int b) throws IOException {
            if (this.smallBuf != null) {
                if (this.pos == this.smallBuf.length) {
                    this.smallBuf = null;
                } else {
                    String s;
                    this.smallBuf[this.pos++] = (byte)b;
                    int first = Math.max(0, this.pos - 50);
                    if (b == 59 && (s = new String(this.smallBuf, first, this.pos - 1)).toLowerCase().indexOf("content-type:") > 0) {
                        super.write(10);
                        super.write(b);
                        this.smallBuf = null;
                        return;
                    }
                }
            }
            super.write(b);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            if (this.smallBuf == null) {
                super.write(b, off, len);
            } else {
                for (int i = off; i < len; ++i) {
                    this.write(b[i]);
                }
            }
        }
    }
}

