/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.auto;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.enums.ValuedEnum;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.resource.JDFBundleItem;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.resource.process.JDFContact;
import org.cip4.jdflib.resource.process.JDFIdentificationField;

public abstract class JDFAutoBundle
extends JDFResource {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[5];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return super.getTheElementInfo().updateReplace(elemInfoTable);
    }

    protected JDFAutoBundle(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    protected JDFAutoBundle(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    protected JDFAutoBundle(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return " JDFAutoBundle[  --> " + super.toString() + " ]";
    }

    @Override
    public boolean init() {
        boolean bRet = super.init();
        this.setResourceClass(JDFResource.EnumResourceClass.Quantity);
        return bRet;
    }

    @Override
    public JDFResource.EnumResourceClass getValidClass() {
        return JDFResource.EnumResourceClass.Quantity;
    }

    public void setBundleType(EnumBundleType enumVar) {
        this.setAttribute("BundleType", enumVar == null ? null : enumVar.getName(), null);
    }

    public EnumBundleType getBundleType() {
        return EnumBundleType.getEnum(this.getAttribute("BundleType", null, "Stack"));
    }

    public void setFolioCount(int value) {
        this.setAttribute("FolioCount", value, (String)null);
    }

    public int getFolioCount() {
        return this.getIntAttribute("FolioCount", null, 0);
    }

    public void setReaderPageCount(int value) {
        this.setAttribute("ReaderPageCount", value, (String)null);
    }

    public int getReaderPageCount() {
        return this.getIntAttribute("ReaderPageCount", null, 0);
    }

    public void setSheetCount(int value) {
        this.setAttribute("SheetCount", value, (String)null);
    }

    public int getSheetCount() {
        return this.getIntAttribute("SheetCount", null, 0);
    }

    public void setTotalAmount(int value) {
        this.setAttribute("TotalAmount", value, (String)null);
    }

    public int getTotalAmount() {
        return this.getIntAttribute("TotalAmount", null, 0);
    }

    public JDFBundleItem getCreateBundleItem(int iSkip) {
        return (JDFBundleItem)this.getCreateElement_KElement("BundleItem", null, iSkip);
    }

    public JDFBundleItem getBundleItem(int iSkip) {
        return (JDFBundleItem)this.getElement("BundleItem", null, iSkip);
    }

    public Collection<JDFBundleItem> getAllBundleItem() {
        VElement vc = this.getChildElementVector("BundleItem", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFBundleItem> v = new Vector<JDFBundleItem>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFBundleItem)vc.get(i));
        }
        return v;
    }

    public JDFBundleItem appendBundleItem() {
        return (JDFBundleItem)this.appendElement("BundleItem", null);
    }

    public JDFContact getCreateContact(int iSkip) {
        return (JDFContact)this.getCreateElement_KElement("Contact", null, iSkip);
    }

    public JDFContact getContact(int iSkip) {
        return (JDFContact)this.getElement("Contact", null, iSkip);
    }

    public Collection<JDFContact> getAllContact() {
        VElement vc = this.getChildElementVector("Contact", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFContact> v = new Vector<JDFContact>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFContact)vc.get(i));
        }
        return v;
    }

    @Override
    public JDFContact appendContact() {
        return (JDFContact)this.appendElement("Contact", null);
    }

    public void refContact(JDFContact refTarget) {
        this.refElement(refTarget);
    }

    @Override
    public JDFIdentificationField getCreateIdentificationField(int iSkip) {
        return (JDFIdentificationField)this.getCreateElement_KElement("IdentificationField", null, iSkip);
    }

    @Override
    public JDFIdentificationField getIdentificationField(int iSkip) {
        return (JDFIdentificationField)this.getElement("IdentificationField", null, iSkip);
    }

    public Collection<JDFIdentificationField> getAllIdentificationField() {
        VElement vc = this.getChildElementVector("IdentificationField", null);
        if (vc == null || vc.size() == 0) {
            return null;
        }
        Vector<JDFIdentificationField> v = new Vector<JDFIdentificationField>();
        for (int i = 0; i < vc.size(); ++i) {
            v.add((JDFIdentificationField)vc.get(i));
        }
        return v;
    }

    @Override
    public JDFIdentificationField appendIdentificationField() {
        return (JDFIdentificationField)this.appendElement("IdentificationField", null);
    }

    public void refIdentificationField(JDFIdentificationField refTarget) {
        this.refElement(refTarget);
    }

    static {
        JDFAutoBundle.atrInfoTable[0] = new AtrInfoTable("BundleType", 0x33333331L, AttributeInfo.EnumAttributeType.enumeration, EnumBundleType.getEnum(0), "Stack");
        JDFAutoBundle.atrInfoTable[1] = new AtrInfoTable("FolioCount", 0x33333331L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoBundle.atrInfoTable[2] = new AtrInfoTable("ReaderPageCount", 0x33333331L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoBundle.atrInfoTable[3] = new AtrInfoTable("SheetCount", 0x33311111L, AttributeInfo.EnumAttributeType.integer, null, null);
        JDFAutoBundle.atrInfoTable[4] = new AtrInfoTable("TotalAmount", 0x33333331L, AttributeInfo.EnumAttributeType.integer, null, null);
        elemInfoTable = new ElemInfoTable[3];
        JDFAutoBundle.elemInfoTable[0] = new ElemInfoTable("BundleItem", 0x33333331L);
        JDFAutoBundle.elemInfoTable[1] = new ElemInfoTable("Contact", 0x33333331L);
        JDFAutoBundle.elemInfoTable[2] = new ElemInfoTable("IdentificationField", 0x33333331L);
    }

    public static class EnumBundleType
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumBundleType BoundSet = new EnumBundleType("BoundSet");
        public static final EnumBundleType Box = new EnumBundleType("Box");
        public static final EnumBundleType Carton = new EnumBundleType("Carton");
        public static final EnumBundleType CollectedStack = new EnumBundleType("CollectedStack");
        public static final EnumBundleType CompensatedStack = new EnumBundleType("CompensatedStack");
        public static final EnumBundleType Pallet = new EnumBundleType("Pallet");
        public static final EnumBundleType Roll = new EnumBundleType("Roll");
        public static final EnumBundleType Sheet = new EnumBundleType("Sheet");
        public static final EnumBundleType SheetStream = new EnumBundleType("SheetStream");
        public static final EnumBundleType Stack = new EnumBundleType("Stack");
        public static final EnumBundleType StrappedStack = new EnumBundleType("StrappedStack");
        public static final EnumBundleType StrappedCompensatedStack = new EnumBundleType("StrappedCompensatedStack");
        public static final EnumBundleType WrappedBundle = new EnumBundleType("WrappedBundle");

        private EnumBundleType(String name) {
            super(name, m_startValue++);
        }

        public static EnumBundleType getEnum(String enumName) {
            return (EnumBundleType)EnumBundleType.getEnum(EnumBundleType.class, (String)enumName);
        }

        public static EnumBundleType getEnum(int enumValue) {
            return (EnumBundleType)EnumBundleType.getEnum(EnumBundleType.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumBundleType.getEnumMap(EnumBundleType.class);
        }

        public static List getEnumList() {
            return EnumBundleType.getEnumList(EnumBundleType.class);
        }

        public static Iterator iterator() {
            return EnumBundleType.iterator(EnumBundleType.class);
        }
    }
}

