/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.enums.ValuedEnum;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFVersions;
import org.cip4.jdflib.core.VString;

public class ElementInfo {
    public static HashMap<String, ElementInfo> fixedMap = new HashMap();
    HashMap<String, ElemInfo> elementInfoTable = new HashMap();
    private JDFElement.EnumVersion version = null;

    public ElementInfo(ElementInfo elemInfo_super, ElemInfoTable[] elemInfo_own) {
        if (elemInfo_super != null) {
            this.elementInfoTable = new HashMap<String, ElemInfo>(elemInfo_super.elementInfoTable);
            this.version = elemInfo_super.version;
        }
        this.updateAdd(elemInfo_own);
    }

    public ElementInfo updateAdd(ElemInfoTable elemInfo_update) {
        if (elemInfo_update != null && !this.elementInfoTable.containsKey(elemInfo_update.getElementName())) {
            this.elementInfoTable.put(elemInfo_update.getElementName(), new ElemInfo(elemInfo_update.getValidityStatus()));
        }
        return this;
    }

    public ElementInfo updateAdd(ElemInfoTable[] elemInfo_update) {
        if (elemInfo_update != null) {
            for (int i = 0; i < elemInfo_update.length; ++i) {
                if (elemInfo_update[i] == null || this.elementInfoTable.containsKey(elemInfo_update[i].getElementName())) continue;
                this.elementInfoTable.put(elemInfo_update[i].getElementName(), new ElemInfo(elemInfo_update[i].getValidityStatus()));
            }
        }
        return this;
    }

    public ElementInfo updateRemove(ElemInfoTable elemInfo_update) {
        if (elemInfo_update != null && this.elementInfoTable.containsKey(elemInfo_update.getElementName())) {
            this.elementInfoTable.remove(elemInfo_update.getElementName());
        }
        return this;
    }

    public ElementInfo updateRemove(ElemInfoTable[] elemInfo_update) {
        if (elemInfo_update != null) {
            for (int i = 0; i < elemInfo_update.length; ++i) {
                if (!this.elementInfoTable.containsKey(elemInfo_update[i].getElementName())) continue;
                this.elementInfoTable.remove(elemInfo_update[i].getElementName());
            }
        }
        return this;
    }

    public ElementInfo updateReplace(ElemInfoTable elemInfo_update) {
        if (elemInfo_update != null) {
            this.elementInfoTable.put(elemInfo_update.getElementName(), new ElemInfo(elemInfo_update.getValidityStatus()));
        }
        return this;
    }

    public ElementInfo updateReplace(ElemInfoTable[] elemInfo_update) {
        if (elemInfo_update != null) {
            for (int i = 0; i < elemInfo_update.length; ++i) {
                this.elementInfoTable.put(elemInfo_update[i].getElementName(), new ElemInfo(elemInfo_update[i].getValidityStatus()));
            }
        }
        return this;
    }

    private VString conformingElements(EnumElementValidity elemValidity1, EnumElementValidity elemValidity2, EnumElementValidity elemValidity3, EnumElementValidity elemValidity4) {
        VString matchingElements = new VString();
        Set<String> keySet = this.elementInfoTable.keySet();
        long l2 = JDFVersions.getTheMask(this.version);
        long v2 = JDFVersions.getTheOffset(this.version);
        for (String theKey : keySet) {
            ElemInfo ei = this.elementInfoTable.get(theKey);
            long eiValStatus = ei.getElemValidityStatus() & l2;
            if (eiValStatus == (long)elemValidity1.getValue() << (int)v2) {
                matchingElements.add(theKey);
                continue;
            }
            if (eiValStatus == (long)elemValidity2.getValue() << (int)v2) {
                matchingElements.add(theKey);
                continue;
            }
            if (eiValStatus == (long)elemValidity3.getValue() << (int)v2) {
                matchingElements.add(theKey);
                continue;
            }
            if (eiValStatus != (long)elemValidity4.getValue() << (int)v2) continue;
            matchingElements.add(theKey);
        }
        return matchingElements;
    }

    public boolean hasConformingElements(EnumElementValidity elemValidity1, EnumElementValidity elemValidity2, EnumElementValidity elemValidity3, EnumElementValidity elemValidity4) {
        return !this.conformingElements(elemValidity1, elemValidity2, elemValidity3, elemValidity4).isEmpty();
    }

    public VString requiredElements() {
        return this.conformingElements(EnumElementValidity.Required, EnumElementValidity.SingleRequired, EnumElementValidity.Dummy, EnumElementValidity.Dummy);
    }

    public VString optionalElements() {
        return this.conformingElements(EnumElementValidity.Optional, EnumElementValidity.Deprecated, EnumElementValidity.SingleDeprecated, EnumElementValidity.SingleOptional);
    }

    public VString deprecatedElements() {
        return this.conformingElements(EnumElementValidity.Deprecated, EnumElementValidity.SingleDeprecated, EnumElementValidity.Dummy, EnumElementValidity.Dummy);
    }

    public VString uniqueElements() {
        return this.conformingElements(EnumElementValidity.SingleRequired, EnumElementValidity.SingleOptional, EnumElementValidity.SingleDeprecated, EnumElementValidity.Dummy);
    }

    public VString prereleaseElements() {
        return this.conformingElements(EnumElementValidity.None, EnumElementValidity.Dummy, EnumElementValidity.Dummy, EnumElementValidity.Dummy);
    }

    public void setVersion(JDFElement.EnumVersion v) {
        this.version = v;
    }

    public String toString() {
        String s = "ElementInfoTable version=" + (Object)((Object)this.version);
        s = s + this.elementInfoTable.toString();
        return s;
    }

    public JDFElement.EnumVersion getFirstVersion(String elementName) {
        if (this.elementInfoTable.containsKey(elementName)) {
            return this.elementInfoTable.get(elementName).getFirstVersion();
        }
        return null;
    }

    public JDFElement.EnumVersion getLastVersion(String elementName) {
        if (this.elementInfoTable.containsKey(elementName)) {
            return this.elementInfoTable.get(elementName).getLastVersion();
        }
        return null;
    }

    public static final class EnumElementValidity
    extends ValuedEnum {
        private static final long serialVersionUID = 1L;
        private static int m_startValue = 0;
        public static final EnumElementValidity Unknown = new EnumElementValidity("Unknown");
        public static final EnumElementValidity None = new EnumElementValidity("None");
        public static final EnumElementValidity Required = new EnumElementValidity("Required");
        public static final EnumElementValidity Optional = new EnumElementValidity("Optional");
        public static final EnumElementValidity Deprecated = new EnumElementValidity("Deprecated");
        public static final EnumElementValidity SingleRequired = new EnumElementValidity("SingleRequired");
        public static final EnumElementValidity SingleOptional = new EnumElementValidity("SingleOptional");
        public static final EnumElementValidity SingleDeprecated = new EnumElementValidity("SingleDeprecated");
        public static final EnumElementValidity Dummy = new EnumElementValidity("Dummy");

        private EnumElementValidity(String name) {
            super(name, m_startValue++);
        }

        public static EnumElementValidity getEnum(String enumName) {
            return (EnumElementValidity)EnumElementValidity.getEnum(EnumElementValidity.class, (String)enumName);
        }

        public static AttributeInfo.EnumAttributeValidity getEnum(int enumValue) {
            return (AttributeInfo.EnumAttributeValidity)EnumElementValidity.getEnum(AttributeInfo.EnumAttributeValidity.class, (int)enumValue);
        }

        public static Map getEnumMap() {
            return EnumElementValidity.getEnumMap(EnumElementValidity.class);
        }

        public static List getEnumList() {
            return EnumElementValidity.getEnumList(EnumElementValidity.class);
        }

        public static Iterator iterator() {
            return EnumElementValidity.iterator(EnumElementValidity.class);
        }
    }
}

