/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.datatypes;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.datatypes.JDFRange;
import org.cip4.jdflib.datatypes.JDFRangeList;
import org.cip4.jdflib.util.StringUtil;

public class JDFIntegerRangeList
extends JDFRangeList {
    private int m_xDef = JDFIntegerRange.getDefaultDef();

    public JDFIntegerRangeList() {
    }

    public JDFIntegerRangeList(String s) throws DataFormatException {
        this(s, JDFIntegerRange.getDefaultDef());
    }

    public JDFIntegerRangeList(String s, int xdef) throws DataFormatException {
        this.setString(s);
        this.setDef(xdef);
    }

    public JDFIntegerRangeList(JDFIntegerRangeList irl) {
        this.rangeList = new Vector(irl.rangeList);
        this.setDef(irl.getDef());
    }

    public JDFIntegerRangeList(JDFIntegerRange ir) {
        this.rangeList = new Vector();
        this.rangeList.addElement(ir);
        this.setDef(ir.getDef());
    }

    public JDFIntegerRangeList(int[] array) {
        this.rangeList = new Vector();
        if (array != null) {
            for (int i : array) {
                this.append(i);
            }
        }
    }

    @Deprecated
    public static JDFIntegerRangeList getIntegerRangeList(String rangelist) {
        return JDFIntegerRangeList.createIntegerRangeList(rangelist);
    }

    public static JDFIntegerRangeList createIntegerRangeList(String rangelist) {
        if (StringUtil.getNonEmpty(rangelist) == null) {
            return null;
        }
        try {
            return new JDFIntegerRangeList(rangelist);
        }
        catch (DataFormatException e) {
            return null;
        }
    }

    public boolean inRange(int x) {
        int sz = this.rangeList.size();
        for (int i = 0; i < sz; ++i) {
            JDFIntegerRange r = (JDFIntegerRange)this.rangeList.elementAt(i);
            if (!r.inRange(x)) continue;
            return true;
        }
        return false;
    }

    public void setString(String s) throws DataFormatException {
        this.rangeList.clear();
        if (s == null || s.equals("")) {
            return;
        }
        if (s.indexOf("~") == 0 || s.lastIndexOf("~") == s.length() - 1) {
            throw new DataFormatException("JDFIntegerRangeList::SetString: Illegal string " + s);
        }
        String zappedWS = StringUtil.zappTokenWS(s, "~");
        VString vs = StringUtil.tokenize(zappedWS, " \t", false);
        for (int i = 0; i < vs.size(); ++i) {
            String str = vs.elementAt(i);
            try {
                JDFIntegerRange ir = new JDFIntegerRange(str);
                this.rangeList.addElement(ir);
                continue;
            }
            catch (DataFormatException dfe) {
                throw new DataFormatException("JDFIntegerRangeList::SetString: Illegal string " + s);
            }
        }
    }

    public boolean isValid(String s) {
        try {
            new JDFIntegerRangeList(s);
        }
        catch (DataFormatException e) {
            return false;
        }
        return true;
    }

    public int getElementCount() {
        int sz = this.rangeList.size();
        int elementCount = 0;
        for (int i = 0; i < sz; ++i) {
            JDFIntegerRange r = (JDFIntegerRange)this.rangeList.elementAt(i);
            int elemCount = r.getElementCount();
            if (elemCount <= 0) {
                return -1;
            }
            elementCount += elemCount;
        }
        return elementCount;
    }

    public int getElement(int i) throws NoSuchElementException {
        int n = this.getElementCount();
        if (i >= n || i < -n) {
            throw new NoSuchElementException("JDFIntegerRangeList::Element out of range error!");
        }
        if (i < 0) {
            return this.getElement(n + i);
        }
        n = 0;
        for (int j = 0; j < this.rangeList.size(); ++j) {
            JDFIntegerRange r = (JDFIntegerRange)this.rangeList.elementAt(j);
            int k = r.getElementCount();
            if (i >= k) {
                i -= k;
                continue;
            }
            return r.getElement(i);
        }
        return 0;
    }

    public void append(JDFIntegerRange r) {
        r.setDef(this.getDef());
        this.rangeList.addElement(r);
    }

    public void append(int xMin, int xMax) {
        this.append(new JDFIntegerRange(xMin, xMax, this.m_xDef));
    }

    public void append(int x) {
        JDFIntegerRange r;
        if (this.rangeList != null && this.rangeList.size() > 0 && (r = (JDFIntegerRange)this.rangeList.elementAt(this.rangeList.size() - 1)).append(x)) {
            return;
        }
        this.append(new JDFIntegerRange(x, x, this.m_xDef));
    }

    public JDFIntegerList getIntegerList() {
        JDFIntegerList irl = new JDFIntegerList();
        for (int i = 0; i < this.rangeList.size(); ++i) {
            JDFIntegerRange r = (JDFIntegerRange)this.rangeList.elementAt(i);
            irl.addAll(r.getIntegerList());
        }
        return irl;
    }

    public void setDef(int xdef) {
        this.m_xDef = xdef;
        for (int i = 0; i < this.rangeList.size(); ++i) {
            ((JDFIntegerRange)this.rangeList.elementAt(i)).setDef(xdef);
        }
    }

    public int getDef() {
        return this.m_xDef;
    }

    @Override
    public boolean isOrdered() {
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < siz; ++i) {
            JDFIntegerRange r = (JDFIntegerRange)this.rangeList.elementAt(i);
            v.addElement(r.getLeft());
            if (r.getLeft() == r.getRight()) continue;
            v.addElement(r.getRight());
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        int first = (Integer)v.elementAt(0);
        int last = (Integer)v.elementAt(n);
        for (int j = 0; j < n; ++j) {
            int value = (Integer)v.elementAt(j);
            int nextvalue = (Integer)v.elementAt(j + 1);
            if (first == last && value == nextvalue || first < last && value <= nextvalue || first > last && value >= nextvalue) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUniqueOrdered() {
        int last;
        int siz = this.rangeList.size();
        if (siz == 0) {
            return false;
        }
        Vector<Integer> v = new Vector<Integer>();
        for (int i = 0; i < siz; ++i) {
            JDFIntegerRange r = (JDFIntegerRange)this.rangeList.elementAt(i);
            v.addElement(r.getLeft());
            if (Integer.valueOf(r.getLeft()).equals(r.getRight())) continue;
            v.addElement(r.getRight());
        }
        int n = v.size() - 1;
        if (n == 0) {
            return true;
        }
        int first = (Integer)v.elementAt(0);
        if (first == (last = ((Integer)v.elementAt(n)).intValue())) {
            return false;
        }
        for (int j = 0; j < n; ++j) {
            int value = (Integer)v.elementAt(j);
            int nextvalue = (Integer)v.elementAt(j + 1);
            if (first < last && value < nextvalue || first > last && value < nextvalue) continue;
            return false;
        }
        return true;
    }

    public JDFIntegerRangeList deepCopy() throws DataFormatException {
        JDFIntegerRangeList rl = new JDFIntegerRangeList();
        rl.setString(this.toString());
        return rl;
    }

    public boolean isOverlapping(JDFIntegerRange newRange, JDFIntegerRange oldRange) {
        Vector<JDFRange> rangeListToCheck = this.rangeList;
        if (oldRange != null) {
            rangeListToCheck = new Vector<JDFRange>();
            rangeListToCheck.addAll(this.rangeList);
            rangeListToCheck.remove(oldRange);
        }
        return this.checkOverlap(rangeListToCheck, newRange);
    }

    private boolean checkOverlap(Vector<JDFRange> vRangeList, JDFIntegerRange newRange) {
        int rangeLower = newRange.getLowerValue();
        int rangeUpper = newRange.getUpperValue();
        for (int i = 0; i < vRangeList.size(); ++i) {
            JDFIntegerRange r = (JDFIntegerRange)vRangeList.elementAt(i);
            if (rangeUpper < r.getLowerValue() || rangeLower > r.getUpperValue()) continue;
            return true;
        }
        return false;
    }

    public void normalize(boolean bSort) {
        int[] l = this.getIntegerList().getIntArray();
        if (bSort) {
            Arrays.sort(l);
        }
        this.clear();
        int lSiz = l.length;
        for (int i = 0; i < lSiz; ++i) {
            this.append(l[i]);
        }
    }
}

