/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.Collection;
import java.util.Vector;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.ifaces.IXJDFSplit;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.node.LinkInfo;
import org.cip4.jdflib.node.LinkInfoMap;
import org.cip4.jdflib.node.LinkValidatorMap;
import org.cip4.jdflib.util.StringUtil;

public abstract class AbstractXJDFSplit
implements IXJDFSplit {
    @Override
    public abstract Collection<XJDFHelper> splitXJDF(XJDFHelper var1);

    public void fixInOutLinks(XJDFHelper xjdf) {
        Vector<SetHelper> sets;
        LinkInfoMap map = this.getLinkInfoMap(xjdf);
        if (map != null && (sets = xjdf.getSets()) != null) {
            VString types = xjdf.getTypes();
            for (SetHelper set : sets) {
                SetHelper set2 = this.matchesType(set, types);
                this.fixInOutLink(set2, map);
            }
        }
    }

    protected SetHelper matchesType(SetHelper set, VString types) {
        String processUsage;
        VString allUsages;
        if (set != null && types != null && (allUsages = StringUtil.tokenize(processUsage = set.getProcessUsage(), null, false)) != null && allUsages.size() > 0) {
            if (!allUsages.containsAny(types)) {
                set.deleteNode();
            }
            set = null;
        }
        return set;
    }

    protected LinkInfoMap getLinkInfoMap(XJDFHelper xjdf) {
        JDFNode.EnumType typ = xjdf.getType();
        VString types = JDFNode.EnumType.ProcessGroup.equals((Object)typ) ? xjdf.getTypes() : null;
        LinkInfoMap map = LinkValidatorMap.getLinkValidatorMap().getLinkInfoMap(typ, types);
        return map;
    }

    protected void fixInOutLink(SetHelper set, LinkInfoMap map) {
        if (map == null || set == null) {
            return;
        }
        String name = set.getName();
        LinkInfo li = map.getStar(name);
        if (li == null) {
            set.deleteNode();
        } else {
            this.fixUsage(set, li);
        }
    }

    protected void fixUsage(SetHelper set, LinkInfo li) {
        String processUsage;
        JDFResourceLink.EnumUsage usage = set.getUsage();
        if (!li.isValidLink(usage, processUsage = set.getProcessUsage(), 1)) {
            if (usage == null || !li.isValidLink(usage.invert(), processUsage, 1)) {
                set.deleteNode();
            } else if (usage != null) {
                set.setUsage(usage.invert());
            }
        } else if (usage == null) {
            boolean outReq;
            boolean inReq;
            usage = li.getUsage(processUsage);
            if (usage == null) {
                usage = li.getUsage(null);
            }
            if (usage == null && (inReq = li.isRequired(JDFResourceLink.EnumUsage.Input)) ^ (outReq = li.isRequired(JDFResourceLink.EnumUsage.Output))) {
                usage = inReq ? JDFResourceLink.EnumUsage.Input : JDFResourceLink.EnumUsage.Output;
            }
            set.setUsage(usage);
        }
    }

    protected void consolidateExchangeResources(Vector<XJDFHelper> v) {
        if (v == null || v.size() < 2) {
            return;
        }
        for (int i = 1; i < v.size(); ++i) {
            XJDFHelper h0 = v.get(i - 1);
            XJDFHelper h1 = v.get(i);
            Vector<SetHelper> sets0 = h0.getSets(null, JDFResourceLink.EnumUsage.Output);
            Vector<SetHelper> sets1 = h1.getSets(null, JDFResourceLink.EnumUsage.Output);
            if (sets0 == null || sets1 == null) continue;
            for (SetHelper set0 : sets0) {
                for (SetHelper set1 : sets1) {
                    if (!set0.isEqual(set1)) continue;
                    this.consolidateExchangeResource(h0, set0, h1, set1);
                }
            }
        }
    }

    protected void consolidateExchangeResource(XJDFHelper h0, SetHelper set0, XJDFHelper h1, SetHelper set1) {
        String newID = "ID_Ex_" + StringUtil.setvString(h0.getTypes(), "_", null, null);
        SetHelper set0Out = h0.appendSet(set0.getFamily().name(), set0.getName(), JDFResourceLink.EnumUsage.Output);
        set0Out.setID(newID);
        set0.deleteNode();
        SetHelper newSet = new SetHelper(h1.getRoot().copyElement(set0Out.getRoot(), null));
        newSet.setUsage(JDFResourceLink.EnumUsage.Input);
    }
}

