/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.Vector;
import java.util.zip.DataFormatException;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.JDFIntegerList;
import org.cip4.jdflib.datatypes.JDFRectangle;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseElementWalker;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.extensions.PartitionHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.extensions.XJDF20;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFStrippingParams;
import org.cip4.jdflib.resource.intent.JDFArtDeliveryIntent;
import org.cip4.jdflib.resource.intent.JDFDeliveryIntent;
import org.cip4.jdflib.resource.process.JDFBinderySignature;
import org.cip4.jdflib.resource.process.JDFDeliveryParams;
import org.cip4.jdflib.resource.process.JDFDrop;
import org.cip4.jdflib.resource.process.JDFLayout;
import org.cip4.jdflib.resource.process.JDFPosition;
import org.cip4.jdflib.resource.process.JDFSignatureCell;
import org.cip4.jdflib.resource.process.JDFStripCellParams;
import org.cip4.jdflib.util.StringUtil;

public class PostXJDFWalker
extends BaseElementWalker {
    public boolean mergeLayout = true;
    protected JDFElement newRoot;
    public boolean bIntentPartition = false;
    public boolean bDeliveryIntent = false;

    public PostXJDFWalker(JDFElement newRoot) {
        super(new BaseWalkerFactory());
        this.newRoot = newRoot;
    }

    public class WalkProductList
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "ProductList".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement firstProduct = xjdf.getElement("Product");
            if (firstProduct == null) {
                xjdf.deleteNode();
                return null;
            }
            return super.walk(xjdf, dummy);
        }
    }

    protected class WalkXJDF
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck.getLocalName().equals("XJDF");
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            this.reorderSets((JDFElement)xjdf);
            this.reorderProductList(xjdf);
            super.walk(xjdf, dummy);
            return xjdf;
        }

        protected void reorderProductList(KElement xjdf) {
            KElement productList = xjdf.getElement("ProductList");
            KElement auditPool = xjdf.getElement("AuditPool");
            if (productList != null && auditPool != null) {
                xjdf.moveElement(productList, auditPool);
            }
        }

        private void reorderSets(JDFElement xjdf) {
            Vector<SetHelper> v = new XJDFHelper(xjdf).getSets();
            if (v == null) {
                return;
            }
            int n = v.size();
            int j = 0;
            while (n > 0) {
                for (int i = 0; i < v.size(); ++i) {
                    KElement e;
                    SetHelper setHelper = v.get(i);
                    KElement kElement = e = setHelper == null ? null : setHelper.getSet();
                    if (e == null) continue;
                    JDFIntegerList lcpi = null;
                    String cpi = e.getAttribute("CombinedProcessIndex", null, null);
                    try {
                        lcpi = cpi == null ? null : new JDFIntegerList(cpi);
                    }
                    catch (DataFormatException dfe) {
                        // empty catch block
                    }
                    if (lcpi == null || lcpi.contains(j)) {
                        v.set(i, null);
                        e.removeAttribute("CombinedProcessIndex");
                        --n;
                        continue;
                    }
                    xjdf.moveElement(e, null);
                }
                ++j;
            }
        }
    }

    protected class WalkIntent
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "Intent".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            xjdf.removeAttribute("Status");
            xjdf.removeAttribute("StatusDetails");
            KElement ret = super.walk(xjdf, dummy);
            return ret;
        }
    }

    protected class WalkResourceSet
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return SetHelper.isSet(toCheck);
        }

        @Override
        public KElement walk(KElement set, KElement dummy) {
            KElement ret = super.walk(set, dummy);
            set.eraseEmptyNodes(true);
            KElement res = set.getElement(StringUtil.leftStr(set.getLocalName(), -3));
            if (res != null) {
                return ret;
            }
            KElement comment = set.getElement("Comment");
            if (comment != null) {
                return ret;
            }
            JDFAttributeMap map = set.getAttributeMap();
            map.remove("ID");
            map.remove("Name");
            map.remove("ProcessUsage");
            map.remove("Usage");
            map.remove("CombinedProcessIndex");
            if (map.size() == 0) {
                set.deleteNode();
                return null;
            }
            return ret;
        }
    }

    protected class WalkResource
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return "Resource".equals(toCheck.getLocalName()) || "Parameter".equals(toCheck.getLocalName());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            String name;
            KElement ret = super.walk(xjdf, dummy);
            xjdf.eraseEmptyNodes(true);
            KElement set = xjdf.getParentNode_KElement();
            String string = name = set == null ? null : StringUtil.getNonEmpty(set.getAttribute("Name"));
            if (name == null) {
                return null;
            }
            KElement realRes = xjdf.getElement(name);
            if (realRes != null) {
                return ret;
            }
            KElement aPool = xjdf.getElement("AmountPool");
            if (aPool != null) {
                return ret;
            }
            KElement comment = xjdf.getElement("Comment");
            if (comment != null) {
                return ret;
            }
            JDFAttributeMap map = xjdf.getAttributeMap();
            map.remove("ID");
            map.remove("Status");
            if (map.size() == 0) {
                xjdf.deleteNode();
                return null;
            }
            return ret;
        }
    }

    protected class WalkResourceElement
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return PartitionHelper.isResourceElement(toCheck);
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement ret = super.walk(xjdf, dummy);
            xjdf.eraseEmptyNodes(true);
            if (xjdf.getFirstChild() == null && xjdf.getAttributeMap().size() == 0) {
                xjdf.deleteNode();
                return null;
            }
            return ret;
        }
    }

    protected class WalkIntentSet
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck.getLocalName().equals("IntentSet");
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement intent = xjdf.getElement("Intent");
            if (!PostXJDFWalker.this.bIntentPartition && intent != null) {
                intent.copyAttribute("ID", xjdf);
                intent.copyAttribute("Name", xjdf);
                xjdf.getParentNode_KElement().moveElement(intent, xjdf);
                xjdf.deleteNode();
            } else {
                super.walk(xjdf, dummy);
            }
            return intent;
        }
    }

    public class WalkDeliveryParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFDeliveryParams;
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement delParams = super.walk(xjdf, dummy);
            if (delParams != null) {
                KElement set;
                Vector<JDFDrop> vDrop = delParams.getChildrenByClass(JDFDrop.class, false, 0);
                int size = vDrop == null ? 0 : vDrop.size();
                KElement param = delParams.getParentNode_KElement();
                KElement kElement = set = param == null ? null : param.getParentNode_KElement();
                if (set != null) {
                    PartitionHelper ph = new PartitionHelper(param);
                    SetHelper sh = new SetHelper(set);
                    JDFAttributeMap partMap = ph.getPartMap();
                    partMap.put("Drop", "DROP_0");
                    ph.setPartMap(partMap);
                    delParams.removeChildren("Drop", null, null);
                    for (int j = 0; j < size; ++j) {
                        KElement newDrop;
                        PartitionHelper newParam;
                        int i = (j + 1) % size;
                        partMap.put("Drop", "DROP_" + i);
                        if (i != 0) {
                            newParam = sh.getCreatePartition(partMap, true);
                            newDrop = newParam.getResource();
                            newDrop.copyInto(delParams, false);
                        } else {
                            newDrop = delParams;
                            newParam = ph;
                        }
                        newDrop.copyInto(vDrop.get(i), false);
                    }
                }
            }
            return delParams;
        }
    }

    public class WalkDeliveryIntentSet
    extends WalkIntentSet {
        @Override
        public boolean matches(KElement toCheck) {
            return !PostXJDFWalker.this.bDeliveryIntent && super.matches(toCheck) && "DeliveryIntent".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement intent = super.walk(xjdf, dummy);
            if (intent != null) {
                XJDFHelper h = new XJDFHelper(xjdf.getDeepParent("XJDF", 0));
                SetHelper delResHelper = h.getCreateSet("Parameter", "DeliveryParams", JDFResourceLink.EnumUsage.Input);
                PartitionHelper ph = delResHelper.appendPartition(null, true);
                JDFDeliveryParams dp = (JDFDeliveryParams)ph.getResource();
                dp.setFromDeliveryIntent((JDFDeliveryIntent)intent.getElement("DeliveryIntent"));
            }
            return intent;
        }
    }

    public class WalkArtDeliveryIntentSet
    extends WalkIntentSet {
        @Override
        public boolean matches(KElement toCheck) {
            return super.matches(toCheck) && "ArtDeliveryIntent".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            KElement intent = super.walk(xjdf, dummy);
            if (intent != null) {
                XJDFHelper h = new XJDFHelper(xjdf.getDeepParent("XJDF", 0));
                SetHelper artDelResHelper = h.getCreateSet("Parameter", "DeliveryParams", JDFResourceLink.EnumUsage.Input);
                PartitionHelper ph = artDelResHelper.appendPartition(null, true);
                JDFDeliveryParams dp = (JDFDeliveryParams)ph.getResource();
                dp.setFromArtDelivery((JDFArtDeliveryIntent)intent.getElement("ArtDeliveryIntent"));
            }
            return intent;
        }
    }

    protected class WalkStrippingSet
    extends WalkResourceSet {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck.getLocalName().equals(SetHelper.PARAMETER_SET) && "StrippingParams".equals(toCheck.getAttribute("Name"));
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            if (PostXJDFWalker.this.mergeLayout) {
                xjdf.deleteNode();
                return null;
            }
            return super.walk(xjdf, dummy);
        }
    }

    protected class WalkStrippingParams
    extends WalkResourceElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFStrippingParams;
        }

        @Override
        public KElement walk(KElement strippingParams, KElement dummy) {
            if (!PostXJDFWalker.this.mergeLayout) {
                super.walk(strippingParams, dummy);
                return strippingParams;
            }
            XJDFHelper h = new XJDFHelper(PostXJDFWalker.this.newRoot);
            SetHelper layoutseth = h.getCreateSet("Parameter", "Layout", JDFResourceLink.EnumUsage.Input);
            VJDFAttributeMap vmap = new PartitionHelper(strippingParams.getParentNode_KElement()).getPartMapVector();
            JDFAttributeMap map = vmap.size() == 0 ? null : vmap.get(0);
            map = this.mergeStrippingParamsLayout((JDFStrippingParams)strippingParams, layoutseth, map);
            this.mergeSurfaces(map);
            super.walk(strippingParams, dummy);
            return null;
        }

        private JDFAttributeMap mergeStrippingParamsLayout(JDFStrippingParams strippingParams, SetHelper layoutseth, JDFAttributeMap map) {
            String bsName = map.remove("BinderySignatureName");
            String cellIndex = map.remove("CellIndex");
            PartitionHelper layoutPartitionH = layoutseth.getCreatePartition(map, true);
            JDFLayout layoutPartition = (JDFLayout)layoutPartitionH.getResource();
            this.ensureLayoutPositions(strippingParams, layoutPartition);
            JDFBinderySignature bsOld = (JDFBinderySignature)layoutPartition.getChildWithAttribute("BinderySignature", "BinderySignatureName", null, bsName, 0, true);
            VElement childElementVector = strippingParams.getChildElementVector("SignatureCell", null);
            if (childElementVector != null) {
                for (KElement kid : childElementVector) {
                    JDFStripCellParams scp = (JDFStripCellParams)kid;
                    scp.setAttribute("CellIndex", cellIndex);
                }
            }
            if (bsOld != null) {
                this.moveStripCells(bsOld, childElementVector);
            } else {
                JDFBinderySignature bs;
                String bsID = strippingParams.getAttribute("BinderySignatureRef", null, null);
                PartitionHelper bsHelper = XJDFHelper.getHelper(layoutPartition).getPartition(bsID);
                JDFBinderySignature jDFBinderySignature = bs = bsHelper == null ? null : (JDFBinderySignature)bsHelper.getResource();
                if (bs != null) {
                    bs.setBinderySignatureName(bsName);
                    this.moveStripCells(bs, childElementVector);
                    this.moveBSFromStripping(bs, strippingParams);
                    VElement positions = layoutPartition.getChildElementVector("Position", null);
                    for (KElement position : positions) {
                        position.setAttribute("BinderySignatureRef", bsID);
                    }
                    strippingParams.removeAttribute("BinderySignatureRef");
                }
                layoutPartition.copyInto(strippingParams, false);
            }
            return map;
        }

        private void ensureLayoutPositions(JDFStrippingParams strippingParams, JDFLayout layoutPartition) {
            VElement positions = strippingParams.getChildElementVector("Position", null);
            if (positions != null && positions.size() > 0) {
                layoutPartition.moveElements(positions, null);
            } else {
                JDFPosition newPos = (JDFPosition)layoutPartition.appendElement("Position");
                newPos.setRelativeBox(new JDFRectangle(0.0, 0.0, 1.0, 1.0));
            }
        }

        private void moveBSFromStripping(JDFBinderySignature bs, JDFStrippingParams strippingParams) {
            if (strippingParams == null || bs == null) {
                return;
            }
            bs.moveAttribute("AssemblyID", bs, "AssemblyIDs", null, null);
            bs.moveAttribute("JobID", bs);
            bs.moveAttribute("InnermostShingling", bs);
            bs.moveAttribute("OutermostShingling", bs);
        }

        private void moveStripCells(JDFBinderySignature bindSig, VElement childElementVector) {
            if (childElementVector == null) {
                return;
            }
            for (KElement sigCell : childElementVector) {
                String cellindex = sigCell.getAttribute("CellIndex", null, null);
                JDFIntegerList il = JDFIntegerList.createIntegerList(cellindex);
                Vector<JDFSignatureCell> vbsCell = this.getSigCellForIndex(bindSig, il);
                sigCell.removeAttribute("CellIndex");
                if (vbsCell != null) {
                    for (JDFSignatureCell bsCell : vbsCell) {
                        bsCell.mergeElement(sigCell, false);
                    }
                }
                sigCell.deleteNode();
            }
        }

        private Vector<JDFSignatureCell> getSigCellForIndex(JDFBinderySignature bindSig, JDFIntegerList il) {
            Vector<JDFSignatureCell> v = bindSig.getChildrenByClass(JDFSignatureCell.class, true, 0);
            Vector<JDFSignatureCell> vRet = new Vector<JDFSignatureCell>();
            if (v == null || v.size() == 0) {
                vRet.add(bindSig.appendSignatureCell());
            } else {
                for (JDFSignatureCell sc : v) {
                    if (!this.matchesIndex(sc, il)) continue;
                    vRet.add(sc);
                }
            }
            if (vRet.size() == 0) {
                vRet.add(bindSig.appendSignatureCell());
            }
            return vRet;
        }

        private boolean matchesIndex(JDFSignatureCell sc, JDFIntegerList il) {
            if (il == null) {
                return true;
            }
            try {
                il = new JDFIntegerList(il);
            }
            catch (DataFormatException e) {
                return false;
            }
            il.scale(2.0);
            JDFIntegerList fp = sc.getFrontPages();
            return il.contains(fp);
        }

        private void mergeSurfaces(JDFAttributeMap map) {
        }
    }

    protected class WalkStripCellParams
    extends WalkElement {
        @Override
        public boolean matches(KElement toCheck) {
            return toCheck instanceof JDFStripCellParams;
        }

        @Override
        public KElement walk(KElement stripCellParams, KElement dummy) {
            if (!PostXJDFWalker.this.mergeLayout) {
                super.walk(stripCellParams, dummy);
                return stripCellParams;
            }
            stripCellParams.renameElement("SignatureCell", null);
            super.walk(stripCellParams, dummy);
            return stripCellParams;
        }
    }

    protected class WalkPart
    extends WalkElement {
        @Override
        public KElement walk(KElement part, KElement dummy) {
            part.removeAttribute("SignatureName");
            return super.walk(part, dummy);
        }

        @Override
        public boolean matches(KElement e) {
            return e instanceof JDFPart;
        }
    }

    protected class WalkElement
    extends BaseWalker {
        public WalkElement() {
            super(PostXJDFWalker.this.getFactory());
        }

        @Override
        public KElement walk(KElement xjdf, KElement dummy) {
            if (xjdf.hasAttribute("xmlns")) {
                xjdf.removeAttribute("xmlns");
            }
            if (xjdf.getNamespaceURI().equals(JDFElement.getSchemaURL())) {
                xjdf.setNamespaceURI(XJDF20.getSchemaURL());
            }
            return xjdf;
        }
    }
}

