/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.util.Vector;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.IntentHelper;
import org.cip4.jdflib.extensions.PartitionHelper;

public class ProductHelper
extends BaseXJDFHelper {
    public static final String PRODUCT = "Product";
    public static final String PRODUCTLIST = "ProductList";
    public static boolean partitionProducts = false;
    public static final String rootProduct = "IsRoot";

    public ProductHelper(KElement product) {
        this.theElement = product;
        this.theElement.appendAnchor(null);
    }

    public void setRoot() {
        this.theElement.setAttribute(rootProduct, true, null);
    }

    public IntentHelper getCreateIntent(String name) {
        IntentHelper ih = this.getIntent(name);
        if (ih == null) {
            KElement intent = this.theElement.appendElement("Intent");
            ih = new IntentHelper(intent);
            intent.appendElement(name);
            intent.setAttribute("Name", name);
        }
        return ih;
    }

    public IntentHelper getIntent(String name) {
        KElement intent = this.theElement.getChildWithAttribute("Intent", "Name", null, name, 0, true);
        return intent == null ? null : new IntentHelper(intent);
    }

    public String toString() {
        return "ProductHelper: " + this.theElement;
    }

    public int getAmount() {
        return this.theElement.getIntAttribute("Amount", null, -1);
    }

    public void setAmount(int amount) {
        this.theElement.setAttribute("Amount", amount, (String)null);
    }

    public int getMaxAmount() {
        int a = this.theElement.getIntAttribute("MaxAmount", null, -4242);
        return a == -4242 ? this.getAmount() : a;
    }

    public double getOverproduction() {
        int a1 = this.getAmount();
        int max = this.getMaxAmount();
        return a1 > 0 ? 100.0 * (double)(max - a1) / (double)a1 : 0.0;
    }

    public void setMaxAmount(int amount) {
        this.theElement.setAttribute("MaxAmount", amount, (String)null);
    }

    public int getMinAmount() {
        int a = this.theElement.getIntAttribute("MinAmount", null, -4242);
        return a == -4242 ? this.getAmount() : a;
    }

    public void setMinAmount(int amount) {
        this.theElement.setAttribute("MinAmount", amount, (String)null);
    }

    public void setChild(ProductHelper phCover, int amount) {
        KElement e = this.theElement.getChildWithAttribute("ChildProduct", "Childref", null, phCover.theElement.getID(), 0, true);
        if (e == null) {
            e = this.theElement.appendElement("ChildProduct");
            e.copyAttribute("ChildRef", phCover.theElement, "ID", null, null);
            phCover.theElement.removeAttribute(rootProduct);
        }
        if (amount > 0) {
            e.setAttribute("Amount", amount, (String)null);
        }
    }

    public ProductHelper getChild(int nChild) {
        KElement e = this.theElement.getElement("ChildProduct", null, nChild);
        if (e == null) {
            return null;
        }
        String id = e.getAttribute("ChildRef", null, null);
        if (id == null) {
            return null;
        }
        KElement list = this.theElement.getParentNode_KElement();
        KElement kid = list.getChildWithAttribute(PRODUCT, "ID", null, id, 0, true);
        return kid == null ? null : new ProductHelper(kid);
    }

    public ProductHelper getChild(String productType, int n) {
        Vector<ProductHelper> v = this.getChildren();
        if (v == null || v.size() < n) {
            return null;
        }
        for (ProductHelper p : v) {
            if (productType != null && !productType.equals(p.getProduct().getAttribute("ProductType")) || n-- != 0) continue;
            return p;
        }
        return null;
    }

    public Vector<ProductHelper> getChildren() {
        VElement v = this.theElement.getChildElementVector("ChildProduct", null);
        if (v == null) {
            return null;
        }
        Vector<ProductHelper> vRet = new Vector<ProductHelper>();
        KElement list = this.theElement.getParentNode_KElement();
        for (KElement e : v) {
            KElement kid;
            String id = e.getAttribute("ChildRef", null, null);
            if (id == null || (kid = list.getChildWithAttribute(PRODUCT, "ID", null, id, 0, true)) == null) continue;
            vRet.add(new ProductHelper(kid));
        }
        return vRet;
    }

    public KElement getProduct() {
        return this.theElement;
    }

    public boolean isRootProduct() {
        boolean b = this.theElement.getBoolAttribute(rootProduct, null, false);
        if (!b) {
            KElement list = this.theElement.getParentNode_KElement();
            b = list != null && list.getElement(PRODUCT, null, 0) == this.theElement && list.getChildWithAttribute(PRODUCT, rootProduct, null, "true", 0, true) == null;
        }
        return b;
    }

    public void setCustomerInfo(PartitionHelper cuph) {
        if (cuph != null) {
            this.getRoot().setAttribute("CustomerInfoRef", cuph.getID());
        }
    }

    @Override
    public void cleanUp() {
    }
}

