/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import org.cip4.jdflib.core.JDFAudit;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.core.XMLDoc;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.BaseXJDFHelper;
import org.cip4.jdflib.extensions.PartitionHelper;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.SetHelper;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFAuditPool;
import org.cip4.jdflib.util.ContainerUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;

public class XJDFHelper
extends BaseXJDFHelper {
    public static final String RESOURCE = "Resource";
    public static final String XJDF = "XJDF";
    public static final String XJMF = "XJMF";
    public static final String PARAMETER = "Parameter";

    public static XJDFHelper getHelper(XMLDoc doc) {
        if (doc == null) {
            return null;
        }
        KElement root = doc.getRoot();
        return root.getLocalName().equals(XJDF) ? new XJDFHelper(root) : null;
    }

    public static XJDFHelper getHelper(KElement root) {
        if (root == null) {
            return null;
        }
        if (!root.getLocalName().equals(XJDF)) {
            root = root.getDeepParent(XJDF, 0);
        }
        return root != null ? new XJDFHelper(root) : null;
    }

    public XJDFHelper(KElement xjdf) {
        if (xjdf == null) {
            this.newXJDF();
        } else {
            this.theElement = xjdf;
        }
        if (this.theElement instanceof JDFElement) {
            ((JDFElement)this.theElement).getOwnerDocument_JDFElement().setInitOnCreate(false);
        }
    }

    public XJDFHelper(String jobID, String jobPartID, VJDFAttributeMap parts) {
        this.newXJDF();
        if (jobID == null) {
            jobID = "Job_" + new JDFDate().getFormattedDateTime("MMdd_hhmmss");
        }
        this.theElement.setAttribute("JobID", jobID);
        this.theElement.setAttribute("JobPartID", jobPartID);
        this.setParts(parts);
    }

    private void setParts(VJDFAttributeMap parts) {
        SetHelper niHelper = this.getCreateSet(PARAMETER, "NodeInfo", JDFResourceLink.EnumUsage.Input);
        niHelper.getCreatePartitions(parts, true);
    }

    private void newXJDF() {
        JDFDoc doc = new JDFDoc(XJDF, JDFElement.EnumVersion.Version_2_0);
        doc.setInitOnCreate(false);
        this.theElement = doc.getRoot();
        JDFAuditPool ap = (JDFAuditPool)this.theElement.getCreateElement("AuditPool");
        ap.addAudit(JDFAudit.EnumAuditType.Created, null).init();
    }

    public Vector<SetHelper> getSets() {
        return this.getSets(null, null);
    }

    public Vector<SetHelper> getSets(SetHelper.EnumFamily family, JDFResourceLink.EnumUsage usage) {
        Vector<SetHelper> v = new Vector<SetHelper>();
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!SetHelper.isSet(e)) continue;
            SetHelper set = new SetHelper(e);
            if (family != null && !set.getFamily().equals((Object)family) || usage != null && !usage.equals((Object)set.getUsage())) continue;
            v.add(set);
        }
        return v.size() == 0 ? null : v;
    }

    public SetHelper getSet(String id) {
        if (id == null) {
            return null;
        }
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!id.equals(e.getID()) || !SetHelper.isSet(e)) continue;
            return new SetHelper(e);
        }
        return null;
    }

    public SetHelper getSetForPartition(String id) {
        PartitionHelper ph = this.getPartition(id);
        if (ph != null) {
            return ph.getSet();
        }
        return this.getSet(id);
    }

    public PartitionHelper getPartition(String id) {
        if (id == null) {
            return null;
        }
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            PartitionHelper ph;
            if (!SetHelper.isSet(e) || (ph = new SetHelper(e).getPartition(id)) == null) continue;
            return ph;
        }
        return null;
    }

    @Deprecated
    public boolean isSet(KElement e) {
        return SetHelper.isSet(e);
    }

    public String getJobID() {
        return this.getXPathValue("@JobID");
    }

    public ProductHelper getRootProduct(int iProduct) {
        Vector<ProductHelper> rootProductHelpers = this.getRootProductHelpers();
        if (rootProductHelpers == null) {
            return null;
        }
        if (iProduct < 0) {
            iProduct = rootProductHelpers.size() + iProduct;
        }
        if (iProduct >= rootProductHelpers.size() || iProduct < 0) {
            return null;
        }
        ProductHelper productHelper = rootProductHelpers.get(iProduct);
        return productHelper;
    }

    public ProductHelper getCreateRootProduct(int iProduct) {
        ProductHelper productHelper = this.getRootProduct(iProduct);
        if (productHelper == null) {
            productHelper = this.appendProduct();
            productHelper.setRoot();
        }
        return productHelper;
    }

    public int numProductHelpers(boolean rootOnly) {
        Vector<ProductHelper> v = rootOnly ? this.getRootProductHelpers() : this.getProductHelpers();
        return v == null ? 0 : v.size();
    }

    public Vector<ProductHelper> getRootProductHelpers() {
        Vector<ProductHelper> vp = this.getProductHelpers();
        if (vp == null) {
            return null;
        }
        Vector<ProductHelper> vp2 = new Vector<ProductHelper>();
        for (ProductHelper ph : vp) {
            if (!ph.isRootProduct()) continue;
            vp2.add(ph);
        }
        return vp2.size() == 0 ? null : vp2;
    }

    public Vector<ProductHelper> getProductHelpers() {
        VElement products;
        if (this.theElement == null) {
            return null;
        }
        KElement productList = this.theElement.getElement("ProductList");
        VElement vElement = products = productList == null ? null : productList.getChildElementVector("Product", null);
        if (products == null || products.size() == 0) {
            return null;
        }
        Vector<ProductHelper> vph = new Vector<ProductHelper>();
        for (KElement e : products) {
            vph.add(new ProductHelper(e));
        }
        return vph;
    }

    public PartitionHelper getPartition(String name, int iSet, int iPart) {
        SetHelper sh = this.getSet(name, iSet);
        return sh == null ? null : sh.getPartition(iPart);
    }

    public KElement getResource(String name, int iSet, int iPart) {
        PartitionHelper ph = this.getPartition(name, iSet, iPart);
        return ph == null ? null : ph.getResource();
    }

    public SetHelper getSet(String name, int iSkip) {
        int n = 0;
        KElement e2 = null;
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!SetHelper.isSet(e) || name != null && !name.equals(e.getAttribute("Name", null, null)) || n++ != iSkip) continue;
            e2 = e;
            break;
        }
        return e2 == null ? null : new SetHelper(e2);
    }

    public SetHelper getSet(String name, String processUsage) {
        for (KElement e = this.theElement.getFirstChildElement(); e != null; e = e.getNextSiblingElement()) {
            if (!SetHelper.isSet(e) || name != null && !name.equals(e.getAttribute("Name", null, null)) || !ContainerUtil.equals(StringUtil.getNonEmpty(processUsage), e.getAttribute("ProcessUsage", null, null))) continue;
            return new SetHelper(e);
        }
        return null;
    }

    public SetHelper appendSet(String family, String name, JDFResourceLink.EnumUsage usage) {
        KElement newSet = this.theElement.appendElement(family + "Set");
        newSet.setAttribute("Name", name);
        if (name == null) {
            name = "Set";
        }
        newSet.setAttribute("ID", name + KElement.uniqueID(0));
        SetHelper h = new SetHelper(newSet);
        if (usage != null) {
            h.setUsage(usage);
        }
        return h;
    }

    public SetHelper getCreateSet(String family, String name, JDFResourceLink.EnumUsage usage) {
        SetHelper newSet = this.getSet(name, 0);
        if (newSet == null) {
            newSet = this.appendSet(family, name, usage);
        }
        return newSet;
    }

    public SetHelper getCreateResourceSet(String name, JDFResourceLink.EnumUsage usage) {
        return this.getCreateSet(RESOURCE, name, usage);
    }

    public SetHelper getCreateParameterSet(String name, JDFResourceLink.EnumUsage usage) {
        return this.getCreateSet(PARAMETER, name, usage);
    }

    public void removeSet(String name) {
        SetHelper newSet = this.getSet(name, 0);
        if (newSet != null) {
            newSet.getSet().deleteNode();
        }
    }

    public SetHelper appendParameter(String name, JDFResourceLink.EnumUsage usage) {
        return this.appendSet(PARAMETER, name, usage);
    }

    public ProductHelper appendProduct() {
        KElement product = this.theElement.getCreateElement("ProductList").appendElement("Product");
        this.reorder();
        return new ProductHelper(product);
    }

    public SetHelper appendResource(String name, JDFResourceLink.EnumUsage usage) {
        return this.appendSet(RESOURCE, name, usage);
    }

    public String toString() {
        return "XJDFHelper: " + this.theElement;
    }

    public boolean writeToFile(String file) {
        boolean b = this.getRoot().getOwnerDocument_KElement().write2File(file, 2, false);
        return b;
    }

    public void writeToStream(OutputStream os) throws IOException {
        this.getRoot().getOwnerDocument_KElement().write2Stream(os, 2, false);
    }

    public void setTypes(String types) {
        VString vtypes = VString.getVString(types, null);
        this.setTypes(vtypes);
    }

    public void setTypes(VString vtypes) {
        this.setXPathValue("@Types", StringUtil.setvString(vtypes));
    }

    public VString getTypes() {
        return VString.getVString(this.getXPathValue("@Types"), null);
    }

    public JDFNode.EnumType getType() {
        VString types = VString.getVString(this.getXPathValue("@Types"), null);
        JDFNode.EnumType typ = null;
        if (types != null && types.size() == 1) {
            typ = JDFNode.EnumType.getEnum(types.get(0));
        }
        return typ == null ? JDFNode.EnumType.ProcessGroup : typ;
    }

    @Override
    public void cleanUp() {
        Vector<SetHelper> v = this.getSets();
        for (SetHelper sh : v) {
            sh.cleanUp();
        }
    }

    public XJDFHelper clone() {
        KElement k = this.theElement == null ? null : this.theElement.cloneNewDoc();
        return new XJDFHelper(k);
    }

    public String getJobPartID() {
        return this.getXPathValue("@JobPartID");
    }

    public void setJobPartID(String jobPartID) {
        this.setXPathValue("@JobPartID", jobPartID);
    }

    public void setJobID(String jobID) {
        this.setXPathValue("@JobID", jobID);
    }

    @Override
    public void reorder() {
        KElement f;
        KElement pl = this.theElement.getElement("ProductList");
        KElement ap = this.theElement.getElement("AuditPool");
        if (pl != null) {
            f = this.theElement.getFirstChildElement();
            if (f == ap) {
                f = f.getNextSiblingElement();
            }
            this.theElement.moveElement(pl, f);
        }
        if (ap != null) {
            f = this.theElement.getFirstChildElement();
            this.theElement.moveElement(ap, f);
        }
    }
}

