/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import org.cip4.jdflib.core.JDFDoc;
import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.elementwalker.BaseWalker;
import org.cip4.jdflib.elementwalker.BaseWalkerFactory;
import org.cip4.jdflib.elementwalker.FixVersion;
import org.cip4.jdflib.elementwalker.IWalker;
import org.cip4.jdflib.elementwalker.PackageElementWalker;
import org.cip4.jdflib.extensions.PostXJDFWalker;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkElement;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkResource;
import org.cip4.jdflib.jmf.JDFJMF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.StringUtil;

public class JDFToXJDF
extends PackageElementWalker {
    public static final String rootName = "XJDF";
    public static final String rootJMF = "JMF";
    final String m_spawnInfo = "SpawnInfo";
    public static final VString amountAttribs = new VString("Amount,ActualAmount,MinAmount,MaxAmount", ",");
    private boolean trackAudits;
    protected VString resAttribs;
    protected KElement newRoot = null;
    protected JDFNode oldRoot = null;
    protected Set<String> first = new HashSet<String>();
    private boolean bExplicitWaste = false;
    private boolean bMergeLayout = true;
    private boolean bMergeLayoutPrep = true;
    private boolean bMergeRunList = true;
    boolean bRetainSpawnInfo = false;
    private boolean bSingleNode = true;
    private boolean bUpdateVersion = true;
    boolean bTypeSafeMessage = true;
    boolean bAbstractMessage = false;
    private boolean bSpanAsAttribute = true;
    boolean bIntentPartition = false;
    boolean wantProduct = true;
    private JDFAttributeMap componentProductMap;
    boolean bHTMLColor = false;
    private boolean bConvertTilde = true;
    String rootID = null;

    public JDFToXJDF() {
        super(new BaseWalkerFactory());
        KElement.uniqueID(-1000);
        this.trackAudits = true;
        this.init();
    }

    @Override
    protected BaseWalker constructWalker(String name) {
        WalkElement constructWalker = (WalkElement)super.constructWalker(name);
        if (constructWalker != null) {
            constructWalker.setParent(this);
        }
        return constructWalker;
    }

    protected String getClassName(JDFResource r) {
        WalkResource w = this.getWalker(r);
        return w == null ? null : w.getClassName(r);
    }

    protected WalkResource getWalker(JDFResource r) {
        if (r == null) {
            return null;
        }
        IWalker walker = this.theFactory.getWalker(r);
        return walker instanceof WalkResource ? (WalkResource)walker : null;
    }

    public void setTrackAudits(boolean trackAudits) {
        this.trackAudits = trackAudits;
    }

    public static String getSchemaURL() {
        return JDFElement.getSchemaURL(2, 0);
    }

    public boolean isExplicitWaste() {
        return this.bExplicitWaste;
    }

    public void setExplicitWaste(boolean bExplicitWaste) {
        this.bExplicitWaste = bExplicitWaste;
    }

    public boolean isWantProduct() {
        return this.wantProduct;
    }

    public void setWantProduct(boolean wantProduct) {
        this.wantProduct = wantProduct;
    }

    public KElement convert(KElement root) {
        if (root instanceof JDFJMF) {
            return this.makeNewJMF((JDFJMF)root);
        }
        if (root instanceof JDFNode) {
            return this.makeNewJDF((JDFNode)root, null);
        }
        return null;
    }

    public KElement makeNewJMF(JDFJMF jmf) {
        JDFJMF root = (JDFJMF)jmf.cloneNewDoc();
        this.prepareNewDoc(true);
        this.walkTree(root, this.newRoot);
        this.newRoot.eraseEmptyNodes(true);
        this.postWalk();
        return this.newRoot;
    }

    public KElement makeNewJDF(JDFNode node, VJDFAttributeMap vMap) {
        JDFNode root = (JDFNode)node.getJDFRoot().cloneNewDoc();
        this.rootID = node.getID();
        if (this.trackAudits) {
            root.getCreateAuditPool().addCreated("XJDF Converter", null);
        }
        FixVersion vers = new FixVersion(JDFElement.EnumVersion.Version_1_5);
        vers.setLayoutPrepToStripping(this.bMergeLayoutPrep);
        vers.walkTree(root, null);
        String id = StringUtil.getNonEmpty(node.getID());
        JDFNode jDFNode = this.oldRoot = id == null ? root : (JDFNode)root.getChildWithAttribute(null, "ID", null, id, 0, false);
        if (this.oldRoot == null) {
            this.oldRoot = root;
        }
        this.prepareNewDoc(false);
        this.loopNodes(root);
        this.prepareRoot(root);
        this.postWalk();
        this.newRoot.getOwnerDocument_KElement().copyMeta(node.getOwnerDocument_KElement());
        return this.newRoot;
    }

    private void postWalk() {
        PostXJDFWalker pw = new PostXJDFWalker((JDFElement)this.newRoot);
        pw.mergeLayout = this.bMergeLayout;
        pw.bIntentPartition = this.bIntentPartition;
        pw.walkTreeKidsFirst(this.newRoot);
        this.newRoot.eraseEmptyNodes(true);
    }

    private void prepareRoot(JDFNode node) {
        if (node != null) {
            node.ensureLink(node.getInheritedCustomerInfo(null), JDFResourceLink.EnumUsage.Input, null);
            node.ensureLink(node.getInheritedNodeInfo(null), JDFResourceLink.EnumUsage.Input, null);
        }
    }

    private void loopNodes(JDFNode node) {
        this.walkTree(node, this.newRoot);
    }

    private void prepareNewDoc(boolean bJMF) {
        JDFDoc newDoc = new JDFDoc(bJMF ? (this.bTypeSafeMessage ? "XJMF" : rootJMF) : rootName, JDFElement.EnumVersion.Version_2_0);
        newDoc.setInitOnCreate(false);
        this.newRoot = newDoc.getRoot();
        this.newRoot.setNamespaceURI(JDFToXJDF.getSchemaURL());
        this.first = new HashSet<String>();
    }

    private void init() {
        this.componentProductMap = new JDFAttributeMap();
        this.resAttribs = this.generateResourceAttributes();
    }

    protected void putComponentProduct(String compID, String productID) {
        this.componentProductMap.put(compID, productID);
    }

    protected String getProduct(String compID) {
        return this.componentProductMap.get(compID);
    }

    protected VString generateResourceAttributes() {
        VString resAttribs = new VString();
        JDFResourcePool dummyResPool = (JDFResourcePool)new JDFDoc("ResourcePool").getRoot();
        JDFResource intRes = dummyResPool.appendResource("intent", JDFResource.EnumResourceClass.Intent, null);
        JDFResource physRes = dummyResPool.appendResource("physical", JDFResource.EnumResourceClass.Consumable, null);
        JDFResource paramRes = dummyResPool.appendResource("param", JDFResource.EnumResourceClass.Parameter, null);
        JDFPart part = (JDFPart)dummyResPool.appendElement("Part");
        resAttribs = paramRes.knownAttributes();
        resAttribs.appendUnique(physRes.knownAttributes());
        resAttribs.appendUnique(intRes.knownAttributes());
        resAttribs.appendUnique(part.knownAttributes());
        return resAttribs;
    }

    public static String getExtension() {
        return rootName.toLowerCase();
    }

    public void saveZip(String fileName, JDFNode rootNode, boolean replace) {
        File file = new File(fileName);
        if (file.canRead()) {
            if (replace) {
                file.delete();
            } else {
                throw new JDFException("output file exists: " + file.getPath());
            }
        }
        try {
            VElement v = rootNode.getvJDFNode(null, null, false);
            BufferedOutputStream fos = FileUtil.getBufferedOutputStream(new File(fileName));
            ZipOutputStream zos = new ZipOutputStream(fos);
            boolean keepProduct = this.wantProduct;
            this.wantProduct = true;
            for (int i = 0; i < v.size(); ++i) {
                JDFNode n = (JDFNode)v.elementAt(i);
                if (!n.isProcessNode()) continue;
                String nam = n.getJobPartID(false);
                if (nam == "") {
                    nam = "Node" + i;
                }
                try {
                    nam = nam + ".XJDF";
                    ZipEntry ze = new ZipEntry(nam);
                    zos.putNextEntry(ze);
                    KElement newRootL = this.makeNewJDF(n, null);
                    newRootL.getOwnerDocument_KElement().write2Stream(zos, 2, true);
                    zos.closeEntry();
                }
                catch (ZipException x) {
                    this.log.error((Object)"oops: ", (Throwable)x);
                }
                catch (IOException x) {
                    this.log.error((Object)"oops: ", (Throwable)x);
                }
                this.wantProduct = false;
            }
            zos.close();
            this.wantProduct = keepProduct;
        }
        catch (IOException x) {
            this.log.error((Object)"oops: ", (Throwable)x);
        }
    }

    protected static VJDFAttributeMap getPartMapVector(KElement res) {
        VJDFAttributeMap omaMaps = null;
        VElement parts = res.getChildElementVector("Part", null, null, true, 0, false);
        if (parts != null && parts.size() > 0) {
            omaMaps = new VJDFAttributeMap();
            for (int i = 0; i < parts.size(); ++i) {
                omaMaps.add(((JDFPart)parts.get(i)).getPartMap());
            }
        }
        return omaMaps;
    }

    public void retainAll() {
        this.bUpdateVersion = false;
        this.bHTMLColor = false;
        this.bMergeLayout = false;
        this.bIntentPartition = false;
        this.bSpanAsAttribute = false;
        this.bMergeLayoutPrep = false;
        this.bMergeRunList = false;
        this.bTypeSafeMessage = false;
        this.bRetainSpawnInfo = true;
    }

    public void setUpdateVersion(boolean bUpdateVersion) {
        this.bUpdateVersion = bUpdateVersion;
    }

    public boolean isMergeLayout() {
        return this.bMergeLayout;
    }

    public void setMergeLayout(boolean bMergeLayout) {
        this.bMergeLayout = bMergeLayout;
    }

    public boolean isMergeLayoutPrep() {
        return this.bMergeLayoutPrep;
    }

    public void setMergeLayoutPrep(boolean bMergeLayoutPrep) {
        this.bMergeLayoutPrep = bMergeLayoutPrep;
    }

    public boolean isMergeRunList() {
        return this.bMergeRunList;
    }

    public void setMergeRunList(boolean bMergeRunList) {
        this.bMergeRunList = bMergeRunList;
    }

    public boolean isRetainSpawnInfo() {
        return this.bRetainSpawnInfo;
    }

    public void setRetainSpawnInfo(boolean bRetainSpawnInfo) {
        this.bRetainSpawnInfo = bRetainSpawnInfo;
    }

    public boolean isSingleNode() {
        return this.bSingleNode;
    }

    public void setSingleNode(boolean bSingleNode) {
        this.bSingleNode = bSingleNode;
    }

    public boolean isUpdateVersion() {
        return this.bUpdateVersion;
    }

    public boolean isTypeSafeMessage() {
        return this.bTypeSafeMessage;
    }

    public void setTypeSafeMessage(boolean bTypeSafeMessage) {
        this.bTypeSafeMessage = bTypeSafeMessage;
    }

    public boolean isAbstractMessage() {
        return this.bAbstractMessage;
    }

    public void setAbstractMessage(boolean bAbstractMessage) {
        this.bAbstractMessage = bAbstractMessage;
    }

    public boolean isSpanAsAttribute() {
        return this.bSpanAsAttribute;
    }

    public void setSpanAsAttribute(boolean bSpanAsAttribute) {
        this.bSpanAsAttribute = bSpanAsAttribute;
    }

    public boolean isIntentPartition() {
        return this.bIntentPartition;
    }

    public void setIntentPartition(boolean bIntentPartition) {
        this.bIntentPartition = bIntentPartition;
    }

    public boolean isHTMLColor() {
        return this.bHTMLColor;
    }

    public void setHTMLColor(boolean bHTMLColor) {
        this.bHTMLColor = bHTMLColor;
    }

    public boolean isConvertTilde() {
        return this.bConvertTilde;
    }

    public void setConvertTilde(boolean bConvertTilde) {
        this.bConvertTilde = bConvertTilde;
    }

    protected String getSetName(JDFResource r) {
        WalkResource w = this.getWalker(r);
        return w == null ? null : w.getXJDFName(r);
    }

    protected boolean isProductResource(JDFResource linkTarget) {
        WalkResource w = this.getWalker(linkTarget);
        return w.isProductResource(linkTarget);
    }
}

