/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf;

import org.cip4.jdflib.auto.JDFAutoComponent;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.extensions.ProductHelper;
import org.cip4.jdflib.extensions.XJDFHelper;
import org.cip4.jdflib.extensions.xjdfwalker.jdftoxjdf.WalkJDF;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.process.JDFComponent;

public class WalkProduct
extends WalkJDF {
    @Override
    public KElement walk(KElement jdf, KElement xjdf) {
        JDFNode node = (JDFNode)jdf;
        this.setRootAttributes(node, xjdf);
        this.walkProduct(jdf, xjdf);
        return xjdf;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && this.jdfToXJDF.wantProduct && JDFNode.EnumType.Product.equals((Object)((JDFNode)toCheck).getEnumType());
    }

    @Override
    protected void removeUnused(KElement newRootP) {
        newRootP.removeAttribute("Status");
        newRootP.removeAttribute("StatusDetails");
        newRootP.removeAttribute("Activation");
        newRootP.removeAttribute("Template");
        super.removeUnused(newRootP);
    }

    private void calcChildren(JDFNode node, KElement prod) {
        VString kids = new VString();
        VElement vComp = node.getPredecessors(true, true);
        if (vComp != null) {
            for (KElement e : vComp) {
                JDFNode nPre = (JDFNode)e;
                if (!JDFNode.EnumType.Product.equals((Object)nPre.getEnumType())) continue;
                kids.add(nPre.getID());
            }
        }
        for (String kid : kids) {
            KElement sub = prod.appendElement("ChildProduct");
            sub.setAttribute("ChildRef", kid, null);
        }
        node.setAttribute("RootProduct", true, null);
    }

    private boolean readComponent(JDFNode node, KElement prod) {
        JDFResourceLink cOutLink = node.getLink(0, "Component", new JDFAttributeMap("Usage", "Output"), null);
        if (cOutLink == null) {
            return false;
        }
        int amount = (int)cOutLink.getAmountPoolSumDouble("Amount", null);
        if (amount > 0) {
            prod.setAttribute("Amount", amount, (String)null);
        }
        prod.renameAttribute("AmountGood", "Amount", null, null);
        prod.removeAttribute("AmountWaste");
        JDFComponent component = (JDFComponent)cOutLink.getTarget();
        if (component != null) {
            prod.copyAttribute("ProductType", component);
            prod.copyAttribute("ProductTypeDetails", component);
            if (component.isComponentType(JDFAutoComponent.EnumComponentType.FinalProduct)) {
                new ProductHelper(prod).setRoot();
            }
            this.jdfToXJDF.putComponentProduct(component.getID(), node.getID());
        }
        return true;
    }

    private KElement walkProduct(KElement jdf, KElement xjdf) {
        JDFNode node = (JDFNode)jdf;
        KElement prod = new XJDFHelper(xjdf).appendProduct().getProduct();
        if (this.readComponent(node, prod)) {
            prod.setAttributes(jdf);
            prod.removeAttribute("Type");
            prod.removeAttribute("Activation");
            prod.removeAttribute("Version");
            prod.removeAttribute("MaxVersion");
            prod.removeAttribute("ICSVersions");
            prod.removeAttribute("Status");
            prod.removeAttribute("StatusDetails");
            prod.removeAttribute("xmlns");
            prod.removeAttribute("xsi:type");
            prod.removeAttribute("JobID");
            prod.renameAttribute("JobPartID", "ProductID", null, null);
            prod.removeAttribute("xmlns:xsi");
            this.calcChildren(node, prod);
            return prod;
        }
        prod.deleteNode();
        return xjdf;
    }
}

