/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf;

import org.cip4.jdflib.core.JDFElement;
import org.cip4.jdflib.core.JDFResourceLink;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.extensions.PartitionHelper;
import org.cip4.jdflib.extensions.xjdfwalker.xjdftojdf.WalkXElement;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.resource.JDFPart;
import org.cip4.jdflib.resource.JDFResource;
import org.cip4.jdflib.util.StringUtil;

public class WalkXJDFResource
extends WalkXElement {
    @Override
    public KElement walk(KElement xjdfRes, KElement jdfResource) {
        KElement ap;
        JDFResource newPartition;
        JDFNode theNode = this.xjdfToJDFImpl.currentJDFNode == null ? ((JDFElement)jdfResource).getParentJDF() : this.xjdfToJDFImpl.currentJDFNode;
        JDFPart part = (JDFPart)xjdfRes.getElement("Part");
        JDFAttributeMap partmap = null;
        JDFNode partialProductNode = null;
        if (part != null) {
            newPartition = this.createPartition(xjdfRes, jdfResource, part);
            partmap = part.getPartMap();
            String productPart = partmap == null ? null : StringUtil.getNonEmpty(partmap.get("ProductPart"));
            partialProductNode = productPart == null ? null : theNode.getChildJDFNode(productPart, false);
        } else if (xjdfRes.getPreviousSiblingElement(xjdfRes.getNodeName(), null) != null) {
            newPartition = theNode.getJDFRoot().addResource(jdfResource.getLocalName(), null);
            newPartition.copyAttribute("ID", xjdfRes);
        } else {
            newPartition = (JDFResource)jdfResource;
        }
        if (newPartition == null) {
            return null;
        }
        JDFAttributeMap map = xjdfRes.getAttributeMap();
        map.remove("ID");
        map.remove("PartIDKeys");
        JDFResourceLink rl = theNode.getLink(newPartition, null);
        JDFResourceLink rlpart = null;
        if (partialProductNode != null) {
            JDFResourceLink.EnumUsage newUsage;
            rlpart = partialProductNode.getLink(newPartition, null);
            JDFResourceLink.EnumUsage enumUsage = newUsage = rl == null ? null : rl.getUsage();
            if (rlpart == null && newUsage != null) {
                rlpart = partialProductNode.ensureLink(newPartition, newUsage, null);
            }
            if (rlpart != null) {
                rl = rlpart;
            }
        }
        if ((ap = xjdfRes.getElement("AmountPool")) != null) {
            this.xjdfToJDFImpl.walkTree(ap, rl);
            ap.deleteNode();
        }
        this.xjdfToJDFImpl.moveAmountsToLink(partmap, map, rl);
        newPartition.setAttributes(map);
        return newPartition;
    }

    protected JDFResource createPartition(KElement xjdfRes, KElement jdfRes, JDFPart part) {
        VJDFAttributeMap partMapVector;
        JDFNode theNode = this.xjdfToJDFImpl.currentJDFNode == null ? ((JDFElement)jdfRes).getParentJDF() : this.xjdfToJDFImpl.currentJDFNode;
        JDFResource r = (JDFResource)jdfRes;
        JDFAttributeMap partMap = this.getPartMap(part);
        JDFResource rPart = r.getCreatePartition(partMap, part.guessPartIDKeys());
        JDFResourceLink rll = theNode.getLink(r, null);
        VJDFAttributeMap vJDFAttributeMap = partMapVector = rll != null ? rll.getPartMapVector() : null;
        if (!(rll == null || partMapVector != null && partMapVector.contains(partMap))) {
            rll.appendPart().setPartMap(partMap);
            part.deleteNode();
        }
        return rPart;
    }

    JDFAttributeMap getPartMap(JDFPart part) {
        JDFAttributeMap p = part.getPartMap();
        if (p != null) {
            String sheetName = p.get("SheetName");
            String signatureName = p.get("SignatureName");
            if (StringUtil.getNonEmpty(sheetName) != null && StringUtil.getNonEmpty(signatureName) == null) {
                signatureName = "Sig_" + sheetName;
                p.put("SignatureName", signatureName);
                part.setSignatureName(signatureName);
            }
        }
        return p;
    }

    @Override
    public boolean matches(KElement toCheck) {
        return super.matches(toCheck) && PartitionHelper.isAsset(toCheck);
    }
}

