/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.pool;

import java.util.Vector;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoAncestorPool;
import org.cip4.jdflib.core.JDFComment;
import org.cip4.jdflib.core.JDFCustomerInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.JDFNodeInfo;
import org.cip4.jdflib.core.JDFRefElement;
import org.cip4.jdflib.core.KElement;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.datatypes.VJDFAttributeMap;
import org.cip4.jdflib.node.JDFAncestor;
import org.cip4.jdflib.node.JDFNode;
import org.cip4.jdflib.pool.JDFResourcePool;
import org.cip4.jdflib.resource.process.JDFGeneralID;

public class JDFAncestorPool
extends JDFAutoAncestorPool {
    private static final long serialVersionUID = 1L;

    public JDFAncestorPool(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFAncestorPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFAncestorPool(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    public String getAncestorAttribute(String attrib, String nameSpaceURI, String def) {
        VElement v = this.getPoolChildren(null);
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFAncestor ancestor = (JDFAncestor)v.elementAt(i);
            if (!ancestor.hasAttribute(attrib, nameSpaceURI, false)) continue;
            return ancestor.getAttribute(attrib, nameSpaceURI, "");
        }
        return def;
    }

    @Deprecated
    public KElement getAncestorElement(String element, String nameSpaceURI) {
        return this.getAncestorElement(element, nameSpaceURI, null);
    }

    public KElement getAncestorElement(String element, String nameSpaceURI, String xPath) {
        VElement v = this.getPoolChildren(null);
        boolean bWildCard = JDFAncestorPool.isWildCard(xPath);
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFAncestor ancestor = (JDFAncestor)v.elementAt(i);
            KElement e = ancestor.getElement(element, nameSpaceURI, 0);
            if (e == null || !bWildCard && !e.hasXPathNode(xPath)) continue;
            return e;
        }
        return null;
    }

    public boolean hasAncestorElement(String attrib, String nameSpaceURI) {
        return this.getAncestorElement(attrib, nameSpaceURI, null) != null;
    }

    public VElement getLinkedResources(JDFAttributeMap mResAtt, boolean bFollowRefs) {
        VElement vChild = this.getPoolChildren(mResAtt);
        VElement vElem = new VElement();
        for (int i = 0; i < vChild.size(); ++i) {
            JDFAncestor anc = (JDFAncestor)vChild.elementAt(i);
            vElem.appendUnique(anc.getLinkedResources(mResAtt, bFollowRefs));
        }
        return vElem;
    }

    @Deprecated
    public void copyNodeData(JDFNode parentNode) {
        this.copyNodeData(parentNode, true, true, true);
    }

    public void copyNodeData(JDFNode parentNode, boolean bCopyNodeInfo, boolean bCopyCustomerInfo, boolean bCopyComments) {
        int i;
        VElement vAncestors = this.getPoolChildren(null);
        JDFNode node = parentNode;
        JDFNode thisParentNode = this.getParentJDF();
        for (i = vAncestors.size() - 1; i >= 0; --i) {
            JDFNode node2;
            JDFAncestor ancestor = (JDFAncestor)vAncestors.elementAt(i);
            if (!node.getID().equals(ancestor.getNodeID())) {
                throw new JDFException("JDFAncestorPool::CopyNodeData: Invalid pairing");
            }
            ancestor.setAttributes(node);
            ancestor.removeAttribute("xsi:type");
            ancestor.renameAttribute("ID", "NodeID", null, null);
            if (!thisParentNode.getID().equals(node.getID())) {
                JDFCustomerInfo customerInfo;
                JDFRefElement re;
                JDFNodeInfo nodeInfo;
                if (bCopyNodeInfo && (nodeInfo = node.getNodeInfo()) != null) {
                    if (nodeInfo.getParentNode_KElement() instanceof JDFResourcePool) {
                        re = (JDFRefElement)ancestor.appendElement("NodeInfoRef");
                        re.setrRef(nodeInfo.getID());
                        re.setPartMap(nodeInfo.getPartMap());
                    } else {
                        ancestor.copyElement(nodeInfo, null);
                    }
                }
                if (bCopyCustomerInfo && (customerInfo = node.getCustomerInfo()) != null) {
                    if (customerInfo.getParentNode_KElement() instanceof JDFResourcePool) {
                        re = (JDFRefElement)ancestor.appendElement("CustomerInfoRef");
                        re.setrRef(customerInfo.getID());
                        re.setPartMap(customerInfo.getPartMap());
                    } else {
                        ancestor.copyElement(customerInfo, null);
                    }
                }
                if (bCopyComments) {
                    Vector<JDFComment> vc = node.getChildrenByClass(JDFComment.class, false, 0);
                    for (KElement kElement : vc) {
                        ancestor.copyElement(kElement, null);
                    }
                    Vector<JDFGeneralID> vgid = node.getChildrenByClass(JDFGeneralID.class, false, 0);
                    for (KElement kElement : vgid) {
                        ancestor.copyElement(kElement, null);
                    }
                }
            }
            if ((node2 = node.getParentJDF()) == null) {
                --i;
                break;
            }
            node = node2;
        }
        if (i >= 0) {
            VElement parentAncestors = node.getAncestorPool().getPoolChildren(null);
            int parentAncestorSize = parentAncestors.size();
            if (parentAncestorSize < i + 1) {
                throw new JDFException("JDFAncestorPool.CopyNodeData: Invalid AncestorPool pairing");
            }
            while (i >= 0) {
                JDFAncestor ancestor = (JDFAncestor)vAncestors.elementAt(i);
                JDFAncestor jDFAncestor = (JDFAncestor)parentAncestors.elementAt(i);
                ancestor.mergeElement(jDFAncestor, false);
                --i;
            }
        }
    }

    public VElement getPoolChildren(JDFAttributeMap mAttrib) {
        return this.getPoolChildrenGeneric("Ancestor", mAttrib, null);
    }

    public JDFAncestor getPoolChild(int i, JDFAttributeMap mAttrib) {
        return (JDFAncestor)this.getPoolChildGeneric(i, "Ancestor", mAttrib, "");
    }

    @Override
    public VJDFAttributeMap getPartMapVector() {
        return super.getPartMapVector();
    }

    @Override
    public void setPartMapVector(VJDFAttributeMap vParts) {
        super.setPartMapVector(vParts);
    }

    @Override
    public void setPartMap(JDFAttributeMap mPart) {
        super.setPartMap(mPart);
    }

    @Override
    public void removePartMap(JDFAttributeMap mPart) {
        super.removePartMap(mPart);
    }

    @Override
    public boolean hasPartMap(JDFAttributeMap mPart) {
        return super.hasPartMap(mPart);
    }

    public boolean hasAncestorAttribute(String attrib, String nameSpaceURI) {
        return this.getAncestorAttribute(attrib, nameSpaceURI, null) != null;
    }

    public String getAncestorElementAttribute(String element, String attrib, String nameSpaceURI, String def) {
        VElement v = this.getPoolChildren(null);
        for (int i = v.size() - 1; i >= 0; --i) {
            JDFAncestor ancestor = (JDFAncestor)v.elementAt(i);
            KElement e = ancestor.getElement(element, nameSpaceURI, 0);
            if (e == null || !e.hasAttribute(attrib, nameSpaceURI, false)) continue;
            return e.getAttribute(attrib, nameSpaceURI, "");
        }
        return def;
    }

    public boolean isPartitioned() {
        VJDFAttributeMap partMapVector = this.getPartMapVector();
        return partMapVector != null && partMapVector.size() > 0;
    }
}

