/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.devicecapability;

import java.util.zip.DataFormatException;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.core.AtrInfoTable;
import org.cip4.jdflib.core.AttributeInfo;
import org.cip4.jdflib.core.ElemInfoTable;
import org.cip4.jdflib.core.ElementInfo;
import org.cip4.jdflib.core.JDFException;
import org.cip4.jdflib.core.VElement;
import org.cip4.jdflib.datatypes.JDFIntegerRange;
import org.cip4.jdflib.resource.JDFValue;
import org.cip4.jdflib.resource.devicecapability.JDFEvaluation;

public class JDFPDFPathEvaluation
extends JDFEvaluation {
    private static final long serialVersionUID = 1L;
    private static AtrInfoTable[] atrInfoTable = new AtrInfoTable[1];
    private static ElemInfoTable[] elemInfoTable;

    @Override
    protected AttributeInfo getTheAttributeInfo() {
        return super.getTheAttributeInfo().updateReplace(atrInfoTable);
    }

    @Override
    protected ElementInfo getTheElementInfo() {
        return new ElementInfo(super.getTheElementInfo(), elemInfoTable);
    }

    public JDFPDFPathEvaluation(CoreDocumentImpl myOwnerDocument, String qualifiedName) {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPDFPathEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPDFPathEvaluation(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPDFPathEvaluation[ --> " + super.toString() + " ]";
    }

    public void setLength(JDFIntegerRange value) {
        this.setAttribute("Length", value.toString());
    }

    public JDFIntegerRange getLengthRange() {
        try {
            return new JDFIntegerRange(this.getAttribute("Length"));
        }
        catch (DataFormatException dfe) {
            throw new JDFException("JDFPDFPathEvaluation.getLengthRange: Attribute LENGTH is not applicable to create JDFIntegerRange");
        }
    }

    public JDFValue getValue(int iSkip) {
        JDFValue e = (JDFValue)this.getElement("Value", "", iSkip);
        return e;
    }

    public JDFValue appendValue() {
        return (JDFValue)this.appendElement("Value", null);
    }

    public void setValueValue(int iSkip, String value) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        e.setValue(value);
    }

    public final String getValueValue(int iSkip) {
        JDFValue e = (JDFValue)this.getElement("Value", null, iSkip);
        return e.getValue();
    }

    @Override
    public final boolean fitsValue(String value) {
        return this.fitsLength(value) && this.fitsValueElem(value);
    }

    private final boolean fitsLength(String pdfPath) {
        if (!this.hasAttribute("Length")) {
            int len = pdfPath.length();
            return this.getLengthRange().inRange(len);
        }
        return true;
    }

    private final boolean fitsValueElem(String pdfPath) {
        VElement v = this.getChildElementVector("Value", null, null, true, 0, false);
        int siz = v.size();
        if (siz == 0) {
            return true;
        }
        for (int i = 0; i < siz; ++i) {
            String value = this.getValueValue(i);
            if (value.compareTo(pdfPath) != 0) continue;
            return true;
        }
        return false;
    }

    static {
        JDFPDFPathEvaluation.atrInfoTable[0] = new AtrInfoTable("Length", 0x33333333L, AttributeInfo.EnumAttributeType.IntegerRange, null, null);
        elemInfoTable = new ElemInfoTable[1];
        JDFPDFPathEvaluation.elemInfoTable[0] = new ElemInfoTable("Value", 0x33333333L);
    }
}

