/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.resource.process;

import java.util.Set;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.cip4.jdflib.auto.JDFAutoAction;
import org.cip4.jdflib.auto.JDFAutoPreflightReport;
import org.cip4.jdflib.core.VString;
import org.cip4.jdflib.datatypes.JDFAttributeMap;
import org.cip4.jdflib.resource.devicecapability.JDFAction;
import org.cip4.jdflib.resource.process.JDFPRGroup;
import org.cip4.jdflib.resource.process.JDFPRItem;
import org.cip4.jdflib.resource.process.JDFPROccurrence;
import org.w3c.dom.DOMException;

public class JDFPreflightReport
extends JDFAutoPreflightReport {
    private static final long serialVersionUID = 1L;

    public JDFPreflightReport(CoreDocumentImpl myOwnerDocument, String qualifiedName) throws DOMException {
        super(myOwnerDocument, qualifiedName);
    }

    public JDFPreflightReport(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName);
    }

    public JDFPreflightReport(CoreDocumentImpl myOwnerDocument, String myNamespaceURI, String qualifiedName, String myLocalName) throws DOMException {
        super(myOwnerDocument, myNamespaceURI, qualifiedName, myLocalName);
    }

    @Override
    public String toString() {
        return "JDFPreflightReport[  --> " + super.toString() + " ]";
    }

    public JDFPRItem setPR(JDFAction action, int pageSet, JDFAttributeMap prMap, VString groupBy) {
        JDFAttributeMap groupMap = null;
        JDFAttributeMap instanceMap = null;
        if (prMap != null) {
            groupMap = new JDFAttributeMap(prMap);
            Set<String> set = groupBy.getSet();
            groupMap.reduceMap(set);
            instanceMap = new JDFAttributeMap(prMap);
            instanceMap.removeKeys(set);
        }
        JDFPRItem pi = this.getCreatePRItem(action, groupMap);
        JDFPRGroup pg = pi.getCreatePRGroup(groupMap);
        JDFPROccurrence pgInstance = pg.getCreatePROccurrence(instanceMap);
        pgInstance.addOccurrences(1, action.getSeverity());
        pi.insertPageSet(pageSet);
        return pi;
    }

    public int addErrorCount(int i) {
        return this.addAttribute("ErrorCount", i, (String)null);
    }

    public int addWarningCount(int i) {
        return this.addAttribute("WarningCount", i, (String)null);
    }

    public void addOccurrences(int i, JDFAutoAction.EnumSeverity sev) {
        if (JDFAutoAction.EnumSeverity.Warning.equals((Object)sev)) {
            this.addWarningCount(i);
        } else if (JDFAutoAction.EnumSeverity.Error.equals((Object)sev)) {
            this.addErrorCount(i);
        }
    }

    public JDFPRItem getCreatePRItem(JDFAction action, JDFAttributeMap groupMap) {
        JDFPRItem pi = this.getPRItem(action, null);
        if (pi == null) {
            pi = this.appendPRItem();
            pi.setActionRef(action.getID());
        }
        pi.getCreatePRGroup(groupMap);
        return pi;
    }

    private JDFPRItem getPRItem(JDFAction action, JDFAttributeMap groupMap) {
        JDFPRGroup pg;
        String id = action == null ? null : action.getID();
        JDFAttributeMap map = id == null ? null : new JDFAttributeMap("ActionRef", id);
        JDFPRItem pi = (JDFPRItem)this.getChildByTagName("PRItem", null, 0, map, true, true);
        if (groupMap != null && pi != null && (pg = pi.getPRGroup(groupMap)) == null) {
            return null;
        }
        return pi;
    }

    @Override
    public boolean init() {
        boolean b = super.init();
        this.setWarningCount(0);
        this.setErrorCount(0);
        return b;
    }
}

