/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.jdflib.util.file;

import java.io.File;
import org.cip4.jdflib.util.FileUtil;
import org.cip4.jdflib.util.JDFDate;
import org.cip4.jdflib.util.StringUtil;
import org.cip4.jdflib.util.file.RollingFile;

public class RollingDateFile
extends RollingFile {
    private static final long serialVersionUID = 1L;
    public static final String MM = "yyMM";
    public static final String DD = "yyMMdd";
    public static final String DDHH = "yyMMddHH";
    private String format = "yyMMdd";

    public RollingDateFile(String pathname, String baseName) {
        super(pathname, baseName);
    }

    @Override
    protected String getNewFileName() {
        return this.getNewFileName(System.currentTimeMillis());
    }

    protected String getNewFileName(long t) {
        String exp = this.getFileExpression();
        JDFDate d = new JDFDate(t);
        String date = "." + d.getFormattedDateTime(this.format);
        return StringUtil.replaceString(exp, "(.)*", date);
    }

    @Override
    protected void calcPos() {
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public File getNewFile(long t) {
        File file = FileUtil.getFileInDirectory(this, new File(this.getNewFileName(t)));
        if (!file.exists()) {
            boolean bSnafu;
            boolean bl = bSnafu = !FileUtil.createNewFile(file);
            if (bSnafu) {
                this.log.error((Object)("cannot create file: " + file.getAbsolutePath()));
                file = null;
            } else {
                this.init(file);
            }
        }
        return file;
    }

    public void init(File file) {
    }
}

